/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression;

import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.node.value.NodeVariableDouble;
import buildcraft.lib.misc.ColourUtil;
import net.minecraft.item.EnumDyeColor;

public class DefaultContexts {
    public static final FunctionContext STRINGS = new FunctionContext();
    public static final FunctionContext MATH_SCALAR = new FunctionContext();
    public static final FunctionContext MATH_VECTOR = new FunctionContext();
    public static final FunctionContext RENDERING = new FunctionContext();
    public static final NodeVariableDouble RENDER_PARTIAL_TICKS;
    public static final INodeFunc.INodeFuncLong MATH_SCALAR_FUNC_ROUND;
    private static final FunctionContext[] CTX_ARRAY_ALL;

    public static FunctionContext createWithAll() {
        return new FunctionContext(CTX_ARRAY_ALL);
    }

    private static long convertColourToAbgr(String c) {
        EnumDyeColor colour = ColourUtil.parseColourOrNull(c);
        if (colour == null) {
            return -1L;
        }
        return 0xFF000000 | ColourUtil.swapArgbToAbgr(ColourUtil.getLightHex(colour));
    }

    private static long convertColourToArgb(String c) {
        EnumDyeColor colour = ColourUtil.parseColourOrNull(c);
        if (colour == null) {
            return -1L;
        }
        return 0xFF000000 | ColourUtil.getLightHex(colour);
    }

    static {
        CTX_ARRAY_ALL = new FunctionContext[]{STRINGS, MATH_SCALAR, MATH_VECTOR, RENDERING};
        STRINGS.put_s_l("length", String::length);
        MATH_SCALAR.putConstantDouble("pi", Math.PI);
        MATH_SCALAR.putConstantDouble("e", Math.E);
        MATH_SCALAR.put_l_l("abs_long", Math::abs);
        MATH_SCALAR.put_d_d("abs_double", Math::abs);
        MATH_SCALAR_FUNC_ROUND = MATH_SCALAR.put_d_l("round", Math::round);
        MATH_SCALAR.put_d_l("floor", a -> (long)Math.floor(a));
        MATH_SCALAR.put_d_l("ceil", a -> (long)Math.ceil(a));
        MATH_SCALAR.put_d_l("sign", a -> a == 0.0 ? 0L : (a < 0.0 ? -1L : 1L));
        MATH_SCALAR.put_d_d("log", Math::log);
        MATH_SCALAR.put_d_d("log10", Math::log10);
        MATH_SCALAR.put_d_d("sqrt", Math::sqrt);
        MATH_SCALAR.put_d_d("cbrt", Math::cbrt);
        MATH_SCALAR.put_d_d("degrees", Math::toDegrees);
        MATH_SCALAR.put_d_d("radians", Math::toRadians);
        MATH_SCALAR.put_d_d("round_float", a -> (double)Math.round(a * 1.0E10) / 1.0E10);
        MATH_SCALAR.put_d_d("sin", Math::sin);
        MATH_SCALAR.put_d_d("cos", Math::cos);
        MATH_SCALAR.put_d_d("tan", Math::tan);
        MATH_SCALAR.put_d_d("asin", Math::asin);
        MATH_SCALAR.put_d_d("acos", Math::acos);
        MATH_SCALAR.put_d_d("atan", Math::atan);
        MATH_SCALAR.put_dd_d("atan2", Math::atan2);
        MATH_SCALAR.put_d_d("sinh", Math::sinh);
        MATH_SCALAR.put_d_d("cosh", Math::cosh);
        MATH_SCALAR.put_d_d("tanh", Math::tanh);
        MATH_SCALAR.put_ll_l("min_long", Math::min);
        MATH_SCALAR.put_ll_l("max_long", Math::max);
        MATH_SCALAR.put_dd_d("min_double", Math::min);
        MATH_SCALAR.put_dd_d("max_double", Math::max);
        MATH_SCALAR.put_dd_d("pow", Math::pow);
        RENDERING.put_s_l("convertColourToAbgr", DefaultContexts::convertColourToAbgr);
        RENDERING.put_s_l("convertColourToArgb", DefaultContexts::convertColourToArgb);
        RENDER_PARTIAL_TICKS = RENDERING.putVariableDouble("partial_ticks");
    }
}

