/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.debug;

import buildcraft.lib.client.model.ModelUtil;
import buildcraft.lib.client.model.MutableQuad;
import buildcraft.lib.client.render.DetachedRenderer;
import buildcraft.lib.debug.BCAdvDebugging;
import buildcraft.lib.debug.IAdvDebugTarget;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum DebugRenderHelper implements DetachedRenderer.IDetachedRenderer
{
    INSTANCE;

    private static final MutableQuad[] smallCuboid;

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(EntityPlayer player, float partialTicks) {
        DetachedRenderer.IDetachedRenderer renderer;
        IAdvDebugTarget target = BCAdvDebugging.INSTANCE.targetClient;
        if (target == null) {
            return;
        }
        if (!target.doesExistInWorld()) {
            // empty if block
        }
        if ((renderer = target.getDebugRenderer()) != null) {
            renderer.render(player, partialTicks);
        }
    }

    public static void renderSmallCuboid(VertexBuffer vb, BlockPos pos, int colour) {
        vb.func_178969_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        for (MutableQuad q : smallCuboid) {
            q.texFromSprite((TextureAtlasSprite)ModelLoader.White.INSTANCE);
            q.colouri(colour);
            q.render(vb);
        }
        vb.func_178969_c(0.0, 0.0, 0.0);
    }

    static {
        smallCuboid = new MutableQuad[6];
        Point3f center = new Point3f(0.5f, 0.5f, 0.5f);
        Point3f radius = new Point3f(0.25f, 0.25f, 0.25f);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            MutableQuad quad = ModelUtil.createFace(face, (Tuple3f)center, (Tuple3f)radius, null);
            quad.lightf(1.0f, 1.0f);
            DebugRenderHelper.smallCuboid[face.ordinal()] = quad;
        }
    }
}

