/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.crops;

import buildcraft.api.crops.ICropHandler;
import buildcraft.lib.misc.BlockUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockMelon;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public enum CropHandlerPlantable implements ICropHandler
{
    INSTANCE;


    @Override
    public boolean isSeed(ItemStack stack) {
        Block block;
        if (stack.func_77973_b() instanceof IPlantable) {
            return true;
        }
        return stack.func_77973_b() instanceof ItemBlock && (block = ((ItemBlock)stack.func_77973_b()).field_150939_a) instanceof IPlantable && block != Blocks.field_150436_aH;
    }

    @Override
    public boolean canSustainPlant(World world, ItemStack seed, BlockPos pos) {
        IPlantable plantable;
        IBlockState state = world.func_180495_p(pos);
        if (seed.func_77973_b() instanceof IPlantable) {
            Block block = state.func_177230_c();
            return block.canSustainPlant(state, (IBlockAccess)world, pos, EnumFacing.UP, (IPlantable)seed.func_77973_b()) && world.func_175623_d(pos.func_177984_a());
        }
        Block block = state.func_177230_c();
        return block.canSustainPlant(state, (IBlockAccess)world, pos, EnumFacing.UP, plantable = (IPlantable)((ItemBlock)seed.func_77973_b()).field_150939_a) && block != ((ItemBlock)seed.func_77973_b()).field_150939_a && world.func_175623_d(pos.func_177984_a());
    }

    @Override
    public boolean plantCrop(World world, EntityPlayer player, ItemStack seed, BlockPos pos) {
        return BlockUtil.useItemOnBlock(world, player, seed, pos, EnumFacing.UP);
    }

    @Override
    public boolean isMature(IBlockAccess blockAccess, IBlockState state, BlockPos pos) {
        Block block = state.func_177230_c();
        if (block instanceof BlockFlower || block instanceof BlockTallGrass || block instanceof BlockMelon || block instanceof BlockMushroom || block instanceof BlockDoublePlant || block == Blocks.field_150423_aK) {
            return true;
        }
        if (block instanceof BlockCrops) {
            return ((BlockCrops)block).func_185525_y(state);
        }
        if (block instanceof BlockNetherWart) {
            return (Integer)state.func_177229_b((IProperty)BlockNetherWart.field_176486_a) == 3;
        }
        return block instanceof IPlantable && blockAccess.func_180495_p(pos.func_177977_b()).func_177230_c() == block;
    }

    @Override
    public boolean harvestCrop(World world, BlockPos pos, NonNullList<ItemStack> drops) {
        return false;
    }
}

