/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.sprite;

import buildcraft.api.core.BCDebugging;
import buildcraft.api.core.BCLog;
import buildcraft.lib.client.sprite.AtlasSpriteVariants;
import buildcraft.lib.client.sprite.ISprite;
import buildcraft.lib.misc.SpriteUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class SpriteHolderRegistry {
    public static final boolean DEBUG = BCDebugging.shouldDebugLog("lib.sprite.holder");
    private static final Map<ResourceLocation, SpriteHolder> HOLDER_MAP = new HashMap<ResourceLocation, SpriteHolder>();

    public static SpriteHolder getHolder(ResourceLocation location) {
        if (!HOLDER_MAP.containsKey(location)) {
            HOLDER_MAP.put(location, new SpriteHolder(location));
            if (DEBUG) {
                BCLog.logger.info("[lib.sprite.holder] Created a new sprite holder for " + location);
            }
        } else if (DEBUG) {
            BCLog.logger.info("[lib.sprite.holder] Returned existing sprite holder for " + location);
        }
        return HOLDER_MAP.get(location);
    }

    public static SpriteHolder getHolder(String location) {
        return SpriteHolderRegistry.getHolder(new ResourceLocation(location));
    }

    public static void onTextureStitchPre(TextureMap map) {
        for (SpriteHolder holder : HOLDER_MAP.values()) {
            holder.onTextureStitchPre(map);
        }
    }

    public static void exportTextureMap() {
        if (!DEBUG) {
            return;
        }
        TextureMap map = Minecraft.func_71410_x().func_147117_R();
        GlStateManager.func_179144_i((int)map.func_110552_b());
        for (int l = 0; l < 4; ++l) {
            int width = GL11.glGetTexLevelParameteri((int)3553, (int)l, (int)4096);
            int height = GL11.glGetTexLevelParameteri((int)3553, (int)l, (int)4097);
            GL11.glPixelStorei((int)3333, (int)1);
            GL11.glPixelStorei((int)3317, (int)1);
            int totalSize = width * height;
            IntBuffer intbuffer = BufferUtils.createIntBuffer((int)totalSize);
            int[] aint = new int[totalSize];
            GL11.glGetTexImage((int)3553, (int)l, (int)32993, (int)33639, (IntBuffer)intbuffer);
            intbuffer.get(aint);
            BufferedImage bufferedimage = new BufferedImage(width, height, 2);
            bufferedimage.setRGB(0, 0, width, height, aint, 0, width);
            try {
                ImageIO.write((RenderedImage)bufferedimage, "png", new File("bc_spritemap_" + l + ".png"));
                continue;
            }
            catch (IOException io) {
                BCLog.logger.warn((Object)io);
            }
        }
    }

    public static void onTextureStitchPost() {
        if (DEBUG && Loader.instance().isInState(LoaderState.AVAILABLE)) {
            BCLog.logger.info("[lib.sprite.holder] List of registered sprites:");
            ArrayList<ResourceLocation> locations = new ArrayList<ResourceLocation>();
            locations.addAll(HOLDER_MAP.keySet());
            locations.sort(Comparator.comparing(ResourceLocation::toString));
            TextureAtlasSprite missing = Minecraft.func_71410_x().func_147117_R().func_174944_f();
            for (ResourceLocation r : locations) {
                SpriteHolder sprite = HOLDER_MAP.get(r);
                TextureAtlasSprite stitched = sprite.sprite;
                String status = "  ";
                if (stitched == null) {
                    status = status + "(Sprite was registered too late)";
                } else if (missing.func_94209_e() == stitched.func_94209_e() && missing.func_94206_g() == stitched.func_94206_g()) {
                    status = status + "(Sprite did not exist in a resource pack)";
                }
                BCLog.logger.info("  - " + r + status);
            }
            BCLog.logger.info("[lib.sprite.holder] Total of " + HOLDER_MAP.size() + " sprites");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class SpriteHolder
    implements ISprite {
        public final ResourceLocation spriteLocation;
        private TextureAtlasSprite sprite;
        private boolean hasCalled = false;

        private SpriteHolder(ResourceLocation spriteLocation) {
            this.spriteLocation = spriteLocation;
        }

        protected void onTextureStitchPre(TextureMap map) {
            map.setTextureEntry((TextureAtlasSprite)AtlasSpriteVariants.createForConfig(this.spriteLocation));
            this.sprite = map.func_174942_a(this.spriteLocation);
        }

        private TextureAtlasSprite getSpriteChecking() {
            if (this.sprite == null & !this.hasCalled) {
                this.hasCalled = true;
                String warnText = "[lib.sprite.holder] Tried to use the sprite " + this.spriteLocation + " before it was stitched!";
                if (DEBUG) {
                    BCLog.logger.warn(warnText, new Throwable());
                } else {
                    BCLog.logger.warn(warnText);
                }
            }
            return this.sprite;
        }

        public TextureAtlasSprite getSprite() {
            return this.getSpriteChecking();
        }

        @Override
        public double getInterpU(double u) {
            TextureAtlasSprite s = this.getSpriteChecking();
            return s == null ? u : (double)s.func_94209_e() + u * (double)(s.func_94212_f() - s.func_94209_e());
        }

        @Override
        public double getInterpV(double v) {
            TextureAtlasSprite s = this.getSpriteChecking();
            return s == null ? v : (double)s.func_94206_g() + v * (double)(s.func_94210_h() - s.func_94206_g());
        }

        @Override
        public void bindTexture() {
            SpriteUtil.bindBlockTextureMap();
        }
    }
}

