/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.sprite;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class DynamicTextureBC {
    public final int width;
    public final int height;
    private final int[] colorMap;
    private final int widthPow2;
    private final int heightPow2;
    private DynamicTexture dynamicTexture;

    public DynamicTextureBC(int iWidth, int iHeight) {
        this.width = iWidth;
        this.height = iHeight;
        this.widthPow2 = MathHelper.func_151236_b((int)iWidth);
        this.heightPow2 = MathHelper.func_151236_b((int)iHeight);
        this.dynamicTexture = new DynamicTexture(this.widthPow2, this.heightPow2);
        this.colorMap = this.dynamicTexture.func_110565_c();
    }

    public void setColord(int x, int y, double r, double g, double b, double a) {
        int a2 = (int)(a * 255.0);
        int r2 = (int)(r * 255.0);
        int g2 = (int)(g * 255.0);
        int b2 = (int)(b * 255.0);
        this.setColor(x, y, a2 << 24 | r2 << 16 | g2 << 8 | b2);
    }

    public void setColori(int x, int y, int r, int g, int b, int a) {
        this.setColor(x, y, (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF);
    }

    public void setColor(int x, int y, int color, float alpha) {
        int a = (int)(alpha * 255.0f);
        this.setColor(x, y, a << 24 | color & 0xFFFFFF);
    }

    public void setColor(int x, int y, int color) {
        this.colorMap[x + y * this.widthPow2] = color;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateTexture() {
        this.dynamicTexture.func_110564_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void bindGlTexture() {
        GlStateManager.func_179144_i((int)this.dynamicTexture.func_110552_b());
    }

    @SideOnly(value=Side.CLIENT)
    public void deleteGlTexture() {
        this.dynamicTexture.func_147631_c();
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(int screenX, int screenY, float zLevel) {
        this.draw(screenX, screenY, zLevel, 0, 0, this.width, this.height);
    }

    @SideOnly(value=Side.CLIENT)
    public float getMaxU() {
        return (float)this.width / (float)this.widthPow2;
    }

    @SideOnly(value=Side.CLIENT)
    public float getMaxV() {
        return (float)this.height / (float)this.heightPow2;
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(int screenX, int screenY, float zLevel, int clipX, int clipY, int clipWidth, int clipHeight) {
        this.updateTexture();
        float f = 1.0f / (float)this.widthPow2;
        float f1 = 1.0f / (float)this.heightPow2;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vb = tessellator.func_178180_c();
        vb.func_181668_a(7, vb.func_178973_g());
        DynamicTextureBC.vertexUV(vb, screenX + 0, screenY + clipHeight, zLevel, (float)(clipX + 0) * f, (float)(clipY + clipHeight) * f1);
        DynamicTextureBC.vertexUV(vb, screenX + clipWidth, screenY + clipHeight, zLevel, (float)(clipX + clipWidth) * f, (float)(clipY + clipHeight) * f1);
        DynamicTextureBC.vertexUV(vb, screenX + clipWidth, screenY + 0, zLevel, (float)(clipX + clipWidth) * f, (float)(clipY + 0) * f1);
        DynamicTextureBC.vertexUV(vb, screenX + 0, screenY + 0, zLevel, (float)(clipX + 0) * f, (float)(clipY + 0) * f1);
        tessellator.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    private static void vertexUV(VertexBuffer vb, double x, double y, double z, double u, double v) {
        vb.func_181662_b(x, y, z);
        vb.func_187315_a(u, v);
        vb.func_181675_d();
    }
}

