/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.render.laser;

import buildcraft.lib.client.render.laser.ILaserRenderer;
import buildcraft.lib.client.render.laser.LaserRenderer_BC8;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import org.lwjgl.opengl.GL11;

public abstract class LaserCompiledList {
    public abstract void render();

    public abstract void delete();

    private static class Vbo
    extends LaserCompiledList {
        private final boolean useColour;
        private final VertexBuffer buffer;

        private Vbo(boolean useColour, VertexBuffer buffer) {
            this.useColour = useColour;
            this.buffer = buffer;
        }

        @Override
        public void render() {
            int stride = this.useColour ? 28 : 24;
            this.buffer.func_177359_a();
            GlStateManager.func_187410_q((int)32884);
            GlStateManager.func_187420_d((int)3, (int)5126, (int)stride, (int)0);
            GlStateManager.func_187410_q((int)32888);
            GlStateManager.func_187405_c((int)2, (int)5126, (int)stride, (int)12);
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
            GlStateManager.func_187410_q((int)32888);
            GlStateManager.func_187405_c((int)2, (int)5122, (int)stride, (int)20);
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
            if (this.useColour) {
                GlStateManager.func_187410_q((int)32886);
                GlStateManager.func_187406_e((int)4, (int)5121, (int)stride, (int)24);
            }
            this.buffer.func_177358_a(7);
            this.buffer.func_177361_b();
            GlStateManager.func_187429_p((int)32884);
            GlStateManager.func_187429_p((int)32888);
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
            GlStateManager.func_187429_p((int)32888);
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
            if (this.useColour) {
                GlStateManager.func_187429_p((int)32886);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }

        @Override
        public void delete() {
            this.buffer.func_177362_c();
        }
    }

    private static class GlList
    extends LaserCompiledList {
        private final int glListId;

        private GlList(int glListId) {
            this.glListId = glListId;
        }

        @Override
        public void render() {
            GL11.glCallList((int)this.glListId);
        }

        @Override
        public void delete() {
            GL11.glDeleteLists((int)this.glListId, (int)1);
        }
    }

    public static class Builder
    implements ILaserRenderer {
        private final Tessellator tess;
        private final net.minecraft.client.renderer.VertexBuffer buffer;
        private final boolean useColour;

        public Builder(boolean useNormalColour) {
            this.useColour = useNormalColour;
            this.tess = Tessellator.func_178181_a();
            this.buffer = this.tess.func_178180_c();
            this.buffer.func_181668_a(7, useNormalColour ? LaserRenderer_BC8.FORMAT_ALL : LaserRenderer_BC8.FORMAT_LESS);
        }

        @Override
        public void vertex(double x, double y, double z, double u, double v, int lmap, float nx, float ny, float nz, float diffuse) {
            this.buffer.func_181662_b(x, y, z);
            this.buffer.func_187315_a(u, v);
            this.buffer.func_187314_a(lmap >> 16 & 0xFFFF, lmap & 0xFFFF);
            if (this.useColour) {
                this.buffer.func_181666_a(diffuse, diffuse, diffuse, 1.0f);
            }
            this.buffer.func_181675_d();
        }

        public LaserCompiledList build() {
            if (OpenGlHelper.func_176075_f()) {
                VertexBuffer vb = new VertexBuffer(this.buffer.func_178973_g());
                this.buffer.func_178977_d();
                this.buffer.func_178965_a();
                vb.func_181722_a(this.buffer.func_178966_f());
                return new Vbo(this.useColour, vb);
            }
            int glList = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)glList, (int)4864);
            this.tess.func_78381_a();
            GL11.glEndList();
            return new GlList(glList);
        }
    }
}

