/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.render.fluid;

import buildcraft.lib.client.model.MutableVertex;
import buildcraft.lib.client.render.fluid.FluidSpriteType;
import buildcraft.lib.client.render.fluid.SpriteFluidFrozen;
import buildcraft.lib.misc.MathUtil;
import buildcraft.lib.misc.RenderUtil;
import buildcraft.lib.misc.VecUtil;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class FluidRenderer {
    private static final EnumMap<FluidSpriteType, Map<Fluid, TextureAtlasSprite>> fluidSprites = new EnumMap(FluidSpriteType.class);
    public static final MutableVertex vertex = new MutableVertex();
    private static final boolean[] DEFAULT_FACES = new boolean[]{true, true, true, true, true, true};
    private static VertexBuffer vb;
    private static TextureAtlasSprite sprite;
    private static TexMap texmap;
    private static boolean invertU;
    private static boolean invertV;
    private static double xTexDiff;
    private static double yTexDiff;
    private static double zTexDiff;

    public static void onTextureStitchPre(TextureMap map) {
        for (FluidSpriteType type : FluidSpriteType.values()) {
            fluidSprites.get((Object)type).clear();
        }
        HashMap<ResourceLocation, SpriteFluidFrozen> spritesStitched = new HashMap<ResourceLocation, SpriteFluidFrozen>();
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            ResourceLocation still = fluid.getStill();
            if (spritesStitched.containsKey(still)) {
                fluidSprites.get((Object)FluidSpriteType.FROZEN).put(fluid, (TextureAtlasSprite)spritesStitched.get(still));
                continue;
            }
            SpriteFluidFrozen spriteFrozen = new SpriteFluidFrozen(still);
            spritesStitched.put(still, spriteFrozen);
            if (!map.setTextureEntry((TextureAtlasSprite)spriteFrozen)) {
                throw new IllegalStateException("Failed to set the frozen variant of " + still + "!");
            }
            fluidSprites.get((Object)FluidSpriteType.FROZEN).put(fluid, spriteFrozen);
        }
    }

    public static void onTextureStitchPost(TextureMap map) {
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            fluidSprites.get((Object)FluidSpriteType.STILL).put(fluid, map.func_174942_a(fluid.getStill()));
            fluidSprites.get((Object)FluidSpriteType.FLOWING).put(fluid, map.func_174942_a(fluid.getFlowing()));
        }
    }

    public static void renderFluid(FluidSpriteType type, IFluidTank tank, Vec3d min, Vec3d max, VertexBuffer vbIn, boolean[] sideRender) {
        FluidRenderer.renderFluid(type, tank.getFluid(), tank.getCapacity(), min, max, vbIn, sideRender);
    }

    public static void renderFluid(FluidSpriteType type, FluidStack fluid, int cap, Vec3d min, Vec3d max, VertexBuffer vbIn, boolean[] sideRender) {
        FluidRenderer.renderFluid(type, fluid, fluid == null ? 0.0 : (double)fluid.amount, cap, min, max, vbIn, sideRender);
    }

    public static void renderFluid(FluidSpriteType type, FluidStack fluid, double amount, double cap, Vec3d min, Vec3d max, VertexBuffer vbIn, boolean[] sideRender) {
        Vec3d realMax;
        Vec3d realMin;
        if (fluid == null || fluid.getFluid() == null || amount <= 0.0) {
            return;
        }
        if (sideRender == null) {
            sideRender = DEFAULT_FACES;
        }
        double height = MathHelper.func_151237_a((double)(amount / cap), (double)0.0, (double)1.0);
        if (fluid.getFluid().isGaseous(fluid)) {
            realMin = VecUtil.replaceValue(min, EnumFacing.Axis.Y, MathUtil.interp(1.0 - height, min.field_72448_b, max.field_72448_b));
            realMax = max;
        } else {
            realMin = min;
            realMax = VecUtil.replaceValue(max, EnumFacing.Axis.Y, MathUtil.interp(height, min.field_72448_b, max.field_72448_b));
        }
        vb = vbIn;
        if (type == null) {
            type = FluidSpriteType.STILL;
        }
        if ((sprite = fluidSprites.get((Object)type).get(fluid.getFluid())) == null) {
            sprite = Minecraft.func_71410_x().func_147117_R().func_174944_f();
        }
        double xs = realMin.field_72450_a;
        double ys = realMin.field_72448_b;
        double zs = realMin.field_72449_c;
        double xb = realMax.field_72450_a;
        double yb = realMax.field_72448_b;
        double zb = realMax.field_72449_c;
        if (type == FluidSpriteType.FROZEN) {
            xTexDiff = min.field_72450_a > 1.0 ? Math.floor(min.field_72450_a) : (min.field_72450_a < 0.0 ? Math.floor(min.field_72450_a) : 0.0);
            yTexDiff = min.field_72448_b > 1.0 ? Math.floor(min.field_72448_b) : (min.field_72448_b < 0.0 ? Math.floor(min.field_72448_b) : 0.0);
            zTexDiff = min.field_72449_c > 1.0 ? Math.floor(min.field_72449_c) : (min.field_72449_c < 0.0 ? Math.floor(min.field_72449_c) : 0.0);
        } else {
            xTexDiff = 0.0;
            yTexDiff = 0.0;
            zTexDiff = 0.0;
        }
        vertex.colouri(RenderUtil.swapARGBforABGR(fluid.getFluid().getColor(fluid)));
        texmap = TexMap.XZ;
        invertU = false;
        invertV = false;
        if (sideRender[EnumFacing.UP.ordinal()]) {
            FluidRenderer.vertex(xs, yb, zb);
            FluidRenderer.vertex(xb, yb, zb);
            FluidRenderer.vertex(xb, yb, zs);
            FluidRenderer.vertex(xs, yb, zs);
        }
        if (sideRender[EnumFacing.DOWN.ordinal()]) {
            FluidRenderer.vertex(xs, ys, zs);
            FluidRenderer.vertex(xb, ys, zs);
            FluidRenderer.vertex(xb, ys, zb);
            FluidRenderer.vertex(xs, ys, zb);
        }
        texmap = TexMap.ZY;
        if (sideRender[EnumFacing.WEST.ordinal()]) {
            FluidRenderer.vertex(xs, ys, zs);
            FluidRenderer.vertex(xs, ys, zb);
            FluidRenderer.vertex(xs, yb, zb);
            FluidRenderer.vertex(xs, yb, zs);
        }
        if (sideRender[EnumFacing.EAST.ordinal()]) {
            FluidRenderer.vertex(xb, yb, zs);
            FluidRenderer.vertex(xb, yb, zb);
            FluidRenderer.vertex(xb, ys, zb);
            FluidRenderer.vertex(xb, ys, zs);
        }
        texmap = TexMap.XY;
        if (sideRender[EnumFacing.NORTH.ordinal()]) {
            FluidRenderer.vertex(xs, yb, zs);
            FluidRenderer.vertex(xb, yb, zs);
            FluidRenderer.vertex(xb, ys, zs);
            FluidRenderer.vertex(xs, ys, zs);
        }
        if (sideRender[EnumFacing.SOUTH.ordinal()]) {
            FluidRenderer.vertex(xs, ys, zb);
            FluidRenderer.vertex(xb, ys, zb);
            FluidRenderer.vertex(xb, yb, zb);
            FluidRenderer.vertex(xs, yb, zb);
        }
        sprite = null;
        texmap = null;
        vb = null;
    }

    private static void vertex(double x, double y, double z) {
        vertex.positiond(x, y, z);
        FluidRenderer.texmap.apply(x - FluidRenderer.xTexDiff, y - FluidRenderer.yTexDiff, z - FluidRenderer.zTexDiff);
        vertex.render(vb);
    }

    public static void drawFluidForGui(FluidStack fluid, int startX, int startY, int endX, int endY) {
        int y;
        int y2;
        sprite = fluidSprites.get((Object)FluidSpriteType.STILL).get(fluid.getFluid());
        if (sprite == null) {
            sprite = Minecraft.func_71410_x().func_147117_R().func_174944_f();
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        RenderUtil.setGLColorFromInt(fluid.getFluid().getColor(fluid));
        Tessellator tess = Tessellator.func_178181_a();
        vb = tess.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        int diffX = endX - startX;
        int diffY = endY - startY;
        int stepX = diffX > 0 ? 16 : -16;
        int stepY = diffY > 0 ? 16 : -16;
        int loopEndX = startX + 16 * (diffX / 16);
        int loopEndY = startY + 16 * (diffY / 16);
        for (int x = startX; x != loopEndX; x += stepX) {
            for (y2 = startY; y2 != loopEndY; y2 += stepY) {
                FluidRenderer.guiVertex(x, y2, 0, 0);
                FluidRenderer.guiVertex(x + stepX, y2, 16, 0);
                FluidRenderer.guiVertex(x + stepX, y2 + stepY, 16, 16);
                FluidRenderer.guiVertex(x, y2 + stepY, 0, 16);
            }
        }
        if (diffX % 16 != 0) {
            int additionalWidth = diffX % 16;
            int x = endX - additionalWidth;
            int xTex = additionalWidth < 0 ? -additionalWidth : additionalWidth;
            for (y = startY; y != loopEndY; y += stepY) {
                FluidRenderer.guiVertex(x, y, 0, 0);
                FluidRenderer.guiVertex(endX, y, xTex, 0);
                FluidRenderer.guiVertex(endX, y + stepY, xTex, 16);
                FluidRenderer.guiVertex(x, y + stepY, 0, 16);
            }
        }
        if (diffY % 16 != 0) {
            int additionalHeight = diffY % 16;
            y2 = endY - additionalHeight;
            int yTex = additionalHeight < 0 ? -additionalHeight : additionalHeight;
            for (int x = startX; x != loopEndX; x += stepX) {
                FluidRenderer.guiVertex(x, y2, 0, 0);
                FluidRenderer.guiVertex(x + stepX, y2, 16, 0);
                FluidRenderer.guiVertex(x + stepX, endY, 16, yTex);
                FluidRenderer.guiVertex(x, endY, 0, yTex);
            }
        }
        if (diffX % 16 != 0 && diffY % 16 != 0) {
            int w = diffX % 16;
            int h = diffY % 16;
            int x = endX - w;
            y = endY - h;
            int tx = w < 0 ? -w : w;
            int ty = h < 0 ? -h : h;
            FluidRenderer.guiVertex(x, y, 0, 0);
            FluidRenderer.guiVertex(endX, y, tx, 0);
            FluidRenderer.guiVertex(endX, endY, tx, ty);
            FluidRenderer.guiVertex(x, endY, 0, ty);
        }
        tess.func_78381_a();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        sprite = null;
        vb = null;
    }

    private static void guiVertex(int x, int y, int u, int v) {
        float ru = sprite.func_94214_a((double)u);
        float rv = sprite.func_94207_b((double)v);
        vb.func_181662_b((double)x, (double)y, 0.0);
        vb.func_187315_a((double)ru, (double)rv);
        vb.func_181675_d();
    }

    static {
        vertex.lighti(15, 15);
        for (FluidSpriteType type : FluidSpriteType.values()) {
            fluidSprites.put(type, new HashMap());
        }
    }

    public static class TankSize {
        public final Vec3d min;
        public final Vec3d max;

        public TankSize(int sx, int sy, int sz, int ex, int ey, int ez) {
            this(new Vec3d((double)sx, (double)sy, (double)sz).func_186678_a(0.0625), new Vec3d((double)ex, (double)ey, (double)ez).func_186678_a(0.0625));
        }

        public TankSize(Vec3d min, Vec3d max) {
            this.min = min;
            this.max = max;
        }

        public TankSize shrink(double by) {
            return this.shrink(by, by, by);
        }

        public TankSize shrink(double x, double y, double z) {
            return new TankSize(this.min.func_72441_c(x, y, z), this.max.func_178786_a(x, y, z));
        }

        public TankSize shink(Vec3d by) {
            return this.shrink(by.field_72450_a, by.field_72448_b, by.field_72449_c);
        }

        public TankSize rotateY() {
            Vec3d _min = TankSize.rotateY(this.min);
            Vec3d _max = TankSize.rotateY(this.max);
            return new TankSize(VecUtil.min(_min, _max), VecUtil.max(_min, _max));
        }

        private static Vec3d rotateY(Vec3d vec) {
            return new Vec3d(1.0 - vec.field_72449_c, vec.field_72448_b, vec.field_72450_a);
        }
    }

    private static enum TexMap {
        XY(true, true),
        XZ(true, false),
        ZY(false, true);

        private final boolean ux;
        private final boolean vy;

        private TexMap(boolean ux, boolean vy) {
            this.ux = ux;
            this.vy = vy;
        }

        private void apply(double x, double y, double z) {
            double realv;
            double realu = this.ux ? x : z;
            double d = realv = this.vy ? y : z;
            if (invertU) {
                realu = 1.0 - realu;
            }
            if (invertV) {
                realv = 1.0 - realv;
            }
            vertex.texf(sprite.func_94214_a(realu * 16.0), sprite.func_94207_b(realv * 16.0));
        }
    }
}

