/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.render;

import buildcraft.lib.client.model.MutableVertex;
import buildcraft.lib.misc.SpriteUtil;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;

public class CuboidRenderer {
    private static final boolean[] DEFAULT_FACES = new boolean[]{true, true, true, true, true, true};

    public static void renderCuboid(TextureAtlasSprite sprite, Vec3d min, Vec3d max, Vec3d offset, VertexBuffer vb, boolean[] sideRender) {
        if (sprite == null) {
            sprite = SpriteUtil.missingSprite();
        }
        if (sideRender == null) {
            sideRender = DEFAULT_FACES;
        }
        CuboidRenderContext ctx = new CuboidRenderContext();
        ctx.buffer = vb;
        double xs = min.field_72450_a;
        double ys = min.field_72448_b;
        double zs = min.field_72449_c;
        double xb = max.field_72450_a;
        double yb = max.field_72448_b;
        double zb = max.field_72449_c;
        ctx.texmap = TexMap.XZ;
        ctx.invertU = false;
        ctx.invertV = false;
        if (sideRender[EnumFacing.UP.ordinal()]) {
            CuboidRenderer.vertex(ctx, xs, yb, zb);
            CuboidRenderer.vertex(ctx, xb, yb, zb);
            CuboidRenderer.vertex(ctx, xb, yb, zs);
            CuboidRenderer.vertex(ctx, xs, yb, zs);
        }
        if (sideRender[EnumFacing.DOWN.ordinal()]) {
            CuboidRenderer.vertex(ctx, xs, ys, zs);
            CuboidRenderer.vertex(ctx, xb, ys, zs);
            CuboidRenderer.vertex(ctx, xb, ys, zb);
            CuboidRenderer.vertex(ctx, xs, ys, zb);
        }
        ctx.texmap = TexMap.ZY;
        if (sideRender[EnumFacing.WEST.ordinal()]) {
            CuboidRenderer.vertex(ctx, xs, ys, zs);
            CuboidRenderer.vertex(ctx, xs, ys, zb);
            CuboidRenderer.vertex(ctx, xs, yb, zb);
            CuboidRenderer.vertex(ctx, xs, yb, zs);
        }
        if (sideRender[EnumFacing.EAST.ordinal()]) {
            CuboidRenderer.vertex(ctx, xb, yb, zs);
            CuboidRenderer.vertex(ctx, xb, yb, zb);
            CuboidRenderer.vertex(ctx, xb, ys, zb);
            CuboidRenderer.vertex(ctx, xb, ys, zs);
        }
        ctx.texmap = TexMap.XY;
        if (sideRender[EnumFacing.NORTH.ordinal()]) {
            CuboidRenderer.vertex(ctx, xs, yb, zs);
            CuboidRenderer.vertex(ctx, xb, yb, zs);
            CuboidRenderer.vertex(ctx, xb, ys, zs);
            CuboidRenderer.vertex(ctx, xs, ys, zs);
        }
        if (sideRender[EnumFacing.SOUTH.ordinal()]) {
            CuboidRenderer.vertex(ctx, xs, ys, zb);
            CuboidRenderer.vertex(ctx, xb, ys, zb);
            CuboidRenderer.vertex(ctx, xb, yb, zb);
            CuboidRenderer.vertex(ctx, xs, yb, zb);
        }
    }

    private static void vertex(CuboidRenderContext ctx, double x, double y, double z) {
        ctx.vertex.positiond(x, y, z);
        ctx.texmap.apply(ctx, x - ctx.xTexDiff, y - ctx.yTexDiff, z - ctx.zTexDiff);
        ctx.vertex.render(ctx.buffer);
    }

    private static enum TexMap {
        XY(true, true),
        XZ(true, false),
        ZY(false, true);

        private final boolean ux;
        private final boolean vy;

        private TexMap(boolean ux, boolean vy) {
            this.ux = ux;
            this.vy = vy;
        }

        void apply(CuboidRenderContext ctx, double x, double y, double z) {
            double realv;
            double realu = this.ux ? x : z;
            double d = realv = this.vy ? y : z;
            if (ctx.invertU) {
                realu = 1.0 - realu;
            }
            if (ctx.invertV) {
                realv = 1.0 - realv;
            }
            ctx.vertex.texf(ctx.sprite.func_94214_a(realu * 16.0), ctx.sprite.func_94207_b(realv * 16.0));
        }
    }

    public static class CuboidRenderContext {
        public final MutableVertex vertex = new MutableVertex();
        VertexBuffer buffer;
        TextureAtlasSprite sprite;
        TexMap texmap;
        boolean invertU;
        boolean invertV;
        public double xTexDiff;
        public double yTexDiff;
        public double zTexDiff;
    }
}

