/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.model.json;

import buildcraft.lib.client.model.ModelUtil;
import buildcraft.lib.client.model.MutableQuad;
import buildcraft.lib.client.model.json.JsonVariableModel;
import buildcraft.lib.client.model.json.JsonVariableModelPart;
import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.node.value.NodeConstantBoolean;
import buildcraft.lib.expression.node.value.NodeConstantLong;
import buildcraft.lib.misc.RenderUtil;
import com.google.gson.JsonObject;
import java.util.List;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;

public abstract class VariablePartCuboidBase
extends JsonVariableModelPart {
    public final IExpressionNode.INodeDouble[] from;
    public final IExpressionNode.INodeDouble[] to;
    public final IExpressionNode.INodeBoolean visible;
    public final IExpressionNode.INodeBoolean shade;
    public final IExpressionNode.INodeLong light;
    public final IExpressionNode.INodeLong colour;

    public VariablePartCuboidBase(JsonObject obj, FunctionContext fnCtx) {
        this.from = VariablePartCuboidBase.readVariablePosition(obj, "from", fnCtx);
        this.to = VariablePartCuboidBase.readVariablePosition(obj, "to", fnCtx);
        this.shade = obj.has("shade") ? VariablePartCuboidBase.readVariableBoolean(obj, "shade", fnCtx) : NodeConstantBoolean.TRUE;
        this.visible = obj.has("visible") ? VariablePartCuboidBase.readVariableBoolean(obj, "visible", fnCtx) : NodeConstantBoolean.TRUE;
        this.light = obj.has("light") ? VariablePartCuboidBase.readVariableLong(obj, "light", fnCtx) : new NodeConstantLong(0L);
        this.colour = obj.has("colour") ? VariablePartCuboidBase.readVariableLong(obj, "colour", fnCtx) : new NodeConstantLong(-1L);
    }

    @Override
    public void addQuads(List<MutableQuad> addTo, JsonVariableModel.ITextureGetter spriteLookup) {
        if (this.visible.evaluate()) {
            float[] f = VariablePartCuboidBase.bakePosition(this.from);
            float[] t = VariablePartCuboidBase.bakePosition(this.to);
            boolean s = this.shade.evaluate();
            int l = (int)(this.light.evaluate() & 0xFL);
            int rgba = RenderUtil.swapARGBforABGR((int)this.colour.evaluate());
            for (EnumFacing face : EnumFacing.field_82609_l) {
                VariableFaceData data = this.getFaceData(face, spriteLookup);
                if (data == null) continue;
                Vector3f radius = new Vector3f(t[0] - f[0], t[1] - f[1], t[2] - f[2]);
                radius.scale(0.5f);
                Vector3f center = new Vector3f(f);
                center.add((Tuple3f)radius);
                MutableQuad quad = ModelUtil.createFace(face, (Tuple3f)center, (Tuple3f)radius, data.uvs);
                quad.rotateTextureUp(data.rotations);
                quad.lighti(l, 0);
                quad.colouri(rgba);
                quad.texFromSprite(data.sprite);
                quad.setSprite(data.sprite);
                quad.setShade(s);
                if (data.invertNormal) {
                    quad = quad.copyAndInvertNormal();
                }
                addTo.add(quad);
            }
        }
    }

    private static float[] bakePosition(IExpressionNode.INodeDouble[] in) {
        float x = (float)in[0].evaluate() / 16.0f;
        float y = (float)in[1].evaluate() / 16.0f;
        float z = (float)in[2].evaluate() / 16.0f;
        return new float[]{x, y, z};
    }

    protected abstract VariableFaceData getFaceData(EnumFacing var1, JsonVariableModel.ITextureGetter var2);

    public static class VariableFaceData {
        public ModelUtil.UvFaceData uvs = new ModelUtil.UvFaceData();
        public TextureAtlasSprite sprite;
        public int rotations = 0;
        public boolean invertNormal = false;
    }
}

