/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.model.json;

import buildcraft.lib.client.model.ModelUtil;
import buildcraft.lib.client.model.json.JsonVariableFaceUV;
import buildcraft.lib.client.model.json.JsonVariableModel;
import buildcraft.lib.client.model.json.VariablePartCuboidBase;
import buildcraft.lib.expression.FunctionContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.EnumFacing;

public class VariablePartCuboid
extends VariablePartCuboidBase {
    public final Map<EnumFacing, JsonVariableFaceUV> faces = new HashMap<EnumFacing, JsonVariableFaceUV>();

    public VariablePartCuboid(JsonObject obj, FunctionContext fnCtx) {
        super(obj, fnCtx);
        if (!obj.has("faces")) {
            throw new JsonSyntaxException("Expected between 1 and 6 faces, got nothing");
        }
        JsonElement elem = obj.get("faces");
        if (!elem.isJsonObject()) {
            throw new JsonSyntaxException("Expected between 1 and 6 faces, got '" + elem + "'");
        }
        JsonObject jFaces = elem.getAsJsonObject();
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (!jFaces.has(face.func_176610_l())) continue;
            JsonElement jFace = jFaces.get(face.func_176610_l());
            if (!jFace.isJsonObject()) {
                throw new JsonSyntaxException("Expected an object, but got " + jFace);
            }
            this.faces.put(face, new JsonVariableFaceUV(jFace.getAsJsonObject(), fnCtx));
        }
        if (this.faces.size() == 0) {
            throw new JsonSyntaxException("Expected between 1 and 6 faces, got an empty object " + jFaces);
        }
    }

    @Override
    protected VariablePartCuboidBase.VariableFaceData getFaceData(EnumFacing side, JsonVariableModel.ITextureGetter spriteLookup) {
        JsonVariableFaceUV var = this.faces.get(side);
        if (var == null || !var.visible.evaluate()) {
            return null;
        }
        VariablePartCuboidBase.VariableFaceData data = new VariablePartCuboidBase.VariableFaceData();
        ModelUtil.TexturedFace face = spriteLookup.get(var.texture.evaluate());
        data.sprite = face.sprite;
        data.rotations = (int)var.textureRotation.evaluate();
        data.uvs.minU = (float)(var.uv[0].evaluate() / 16.0);
        data.uvs.minV = (float)(var.uv[1].evaluate() / 16.0);
        data.uvs.maxU = (float)(var.uv[2].evaluate() / 16.0);
        data.uvs.maxV = (float)(var.uv[3].evaluate() / 16.0);
        data.uvs = data.uvs.inParent(face.faceData);
        return data;
    }
}

