/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.model.json;

import buildcraft.lib.client.model.ModelUtil;
import buildcraft.lib.client.model.ResourceLoaderContext;
import buildcraft.lib.client.model.json.JsonModelRule;
import buildcraft.lib.client.model.json.JsonTexture;
import buildcraft.lib.client.model.json.JsonVariableModelPart;
import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.InternalCompiler;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.api.NodeType;
import buildcraft.lib.expression.node.value.ITickableNode;
import buildcraft.lib.expression.node.value.NodeStateful;
import buildcraft.lib.expression.node.value.NodeUpdatable;
import buildcraft.lib.misc.JsonUtil;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;

public class JsonVariableModel {
    public final boolean ambientOcclusion;
    public final Map<String, JsonTexture> textures;
    public final Map<String, ITickableNode.Source> variables;
    public final JsonModelRule[] rules;
    private final ITickableNode.Source[] variablesArray;
    public final JsonVariableModelPart[] cutoutElements;
    public final JsonVariableModelPart[] translucentElements;

    public static JsonVariableModel deserialize(ResourceLocation from, FunctionContext fnCtx) throws JsonParseException, IOException {
        return JsonVariableModel.deserialize(from, fnCtx, new ResourceLoaderContext());
    }

    /*
     * Loose catch block
     */
    public static JsonVariableModel deserialize(ResourceLocation from, FunctionContext fnCtx, ResourceLoaderContext ctx) throws JsonParseException, IOException {
        try {
            try (InputStreamReader isr = ctx.startLoading(from);){
                JsonVariableModel jsonVariableModel = new JsonVariableModel(JsonUtil.inlineCustom((JsonObject)new Gson().fromJson((Reader)isr, JsonObject.class)), fnCtx, ctx);
                return jsonVariableModel;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ctx.finishLoading();
        }
    }

    private static JsonVariableModelPart[] deserializePartArray(JsonObject json, String member, FunctionContext fnCtx, ResourceLoaderContext ctx, boolean require) {
        if (!json.has(member)) {
            if (require) {
                throw new JsonSyntaxException("Did not have '" + member + "' in '" + json + "'");
            }
            return new JsonVariableModelPart[0];
        }
        JsonElement elem = json.get(member);
        if (!elem.isJsonArray()) {
            throw new JsonSyntaxException("Expected an array, got '" + elem + "'");
        }
        JsonArray array = elem.getAsJsonArray();
        JsonVariableModelPart[] to = new JsonVariableModelPart[array.size()];
        for (int i = 0; i < to.length; ++i) {
            to[i] = JsonVariableModelPart.deserializeModelPart(array.get(i), fnCtx, ctx);
        }
        return to;
    }

    public JsonVariableModel(JsonObject obj, FunctionContext fnCtx, ResourceLoaderContext ctx) throws JsonParseException {
        boolean require;
        boolean ambf = false;
        this.textures = new HashMap<String, JsonTexture>();
        this.variables = new LinkedHashMap<String, ITickableNode.Source>();
        ArrayList cutout = new ArrayList();
        ArrayList translucent = new ArrayList();
        ArrayList<JsonModelRule> rulesP = new ArrayList<JsonModelRule>();
        if (obj.has("values")) {
            fnCtx = new FunctionContext(fnCtx);
            this.putVariables(JsonUtils.func_152754_s((JsonObject)obj, (String)"values"), fnCtx);
        }
        if (obj.has("parent")) {
            JsonVariableModel parent;
            String parentName = JsonUtils.func_151200_h((JsonObject)obj, (String)"parent");
            parentName = parentName + ".json";
            ResourceLocation from = new ResourceLocation(parentName);
            try {
                parent = JsonVariableModel.deserialize(from, fnCtx, ctx);
            }
            catch (IOException e) {
                throw new JsonParseException("Didn't find the parent '" + parentName + "'!", (Throwable)e);
            }
            ambf = parent.ambientOcclusion;
            if (!JsonUtils.func_151209_a((JsonObject)obj, (String)"textures_reset", (boolean)false)) {
                this.textures.putAll(parent.textures);
            }
            this.variables.putAll(parent.variables);
            if (!JsonUtils.func_151209_a((JsonObject)obj, (String)"cutout_replace", (boolean)false)) {
                Collections.addAll(cutout, parent.cutoutElements);
            }
            if (!JsonUtils.func_151209_a((JsonObject)obj, (String)"translucent_replace", (boolean)false)) {
                Collections.addAll(translucent, parent.translucentElements);
            }
            if (!JsonUtils.func_151209_a((JsonObject)obj, (String)"rules_replace", (boolean)false)) {
                Collections.addAll(rulesP, parent.rules);
            }
        }
        this.ambientOcclusion = JsonUtils.func_151209_a((JsonObject)obj, (String)"ambientocclusion", (boolean)ambf);
        this.deserializeTextures(obj.get("textures"));
        if (obj.has("variables")) {
            fnCtx = new FunctionContext(fnCtx);
            this.putVariables(JsonUtils.func_152754_s((JsonObject)obj, (String)"variables"), fnCtx);
        }
        this.variablesArray = this.variables.values().toArray(new ITickableNode.Source[0]);
        boolean bl = require = cutout.isEmpty() && translucent.isEmpty();
        if (obj.has("elements")) {
            Collections.addAll(cutout, JsonVariableModel.deserializePartArray(obj, "elements", fnCtx, ctx, require));
        } else {
            Collections.addAll(cutout, JsonVariableModel.deserializePartArray(obj, "cutout", fnCtx, ctx, require));
            Collections.addAll(translucent, JsonVariableModel.deserializePartArray(obj, "translucent", fnCtx, ctx, require));
        }
        this.cutoutElements = cutout.toArray(new JsonVariableModelPart[cutout.size()]);
        this.translucentElements = translucent.toArray(new JsonVariableModelPart[translucent.size()]);
        if (obj.has("rules")) {
            JsonElement elem = obj.get("rules");
            if (!elem.isJsonArray()) {
                throw new JsonSyntaxException("Expected an array, got " + elem + " for 'rules'");
            }
            JsonArray arr = elem.getAsJsonArray();
            for (int i = 0; i < arr.size(); ++i) {
                rulesP.add(JsonModelRule.deserialize(arr.get(i), fnCtx, ctx));
            }
        }
        this.rules = rulesP.toArray(new JsonModelRule[rulesP.size()]);
    }

    private void deserializeTextures(JsonElement elem) {
        if (elem == null) {
            return;
        }
        if (!elem.isJsonObject()) {
            throw new JsonSyntaxException("Expected to find an object for 'textures', but found " + elem);
        }
        JsonObject obj = elem.getAsJsonObject();
        for (Map.Entry entry : obj.entrySet()) {
            JsonTexture texture;
            String name = (String)entry.getKey();
            JsonElement tex = (JsonElement)entry.getValue();
            if (tex.isJsonPrimitive() && tex.getAsJsonPrimitive().isString()) {
                String location = tex.getAsString();
                texture = new JsonTexture(location);
            } else if (tex.isJsonObject()) {
                texture = new JsonTexture(tex.getAsJsonObject());
            } else {
                throw new JsonSyntaxException("Expected a string or an object, but got " + tex);
            }
            this.textures.put(name, texture);
        }
    }

    private void putVariables(JsonObject values, FunctionContext fnCtx) {
        for (Map.Entry entry : values.entrySet()) {
            IExpressionNode node;
            String name = (String)entry.getKey();
            if (fnCtx.hasLocalVariable(name = name.toLowerCase(Locale.ROOT))) {
                throw new JsonSyntaxException("Duplicate local variable '" + name + "'");
            }
            if (fnCtx.getVariable(name) != null) continue;
            JsonElement value = (JsonElement)entry.getValue();
            String type = null;
            String getter = null;
            String rounder = null;
            if (value.isJsonObject()) {
                JsonObject objValue = value.getAsJsonObject();
                value = objValue.get("value");
                type = JsonUtils.func_151200_h((JsonObject)objValue, (String)"type");
                getter = JsonUtils.func_151200_h((JsonObject)objValue, (String)"getter");
                if (objValue.has("rounder")) {
                    rounder = JsonUtils.func_151200_h((JsonObject)objValue, (String)"rounder");
                }
            }
            if (!value.isJsonPrimitive() && value.getAsJsonPrimitive().isString()) {
                throw new JsonSyntaxException("Expected a string, got " + value + " for the variable '" + name + "'");
            }
            NodeStateful stateful = null;
            if (getter != null) {
                NodeType nodeType;
                try {
                    nodeType = NodeType.parseType(type);
                }
                catch (InvalidExpressionException iee) {
                    throw new JsonSyntaxException("Could not parse node type for variable '" + name + "'", (Throwable)iee);
                }
                NodeStateful.IGetterFunc getterFunc = JsonVariableModel.parseGetterFunction(getter, fnCtx);
                try {
                    stateful = new NodeStateful(name, nodeType, getterFunc);
                }
                catch (InvalidExpressionException iee) {
                    throw new JsonSyntaxException("Could not create a getter for the variable '" + name + "'", (Throwable)iee);
                }
                fnCtx.putVariable(name, stateful.getter);
                if (rounder != null) {
                    FunctionContext fnCtx2 = new FunctionContext(fnCtx);
                    fnCtx2.putVariable("last", stateful.last);
                    fnCtx2.putVariable("var", stateful.variable);
                    fnCtx2.putVariable("value", stateful.rounderValue);
                    try {
                        IExpressionNode nodeRounder = InternalCompiler.compileExpression(rounder, fnCtx2);
                        stateful.setRounder(nodeRounder);
                    }
                    catch (InvalidExpressionException iee) {
                        throw new JsonSyntaxException("Could not compile a rounder for the variable '" + name + "'", (Throwable)iee);
                    }
                }
            }
            String expression = value.getAsString();
            try {
                node = InternalCompiler.compileExpression(expression, fnCtx);
            }
            catch (InvalidExpressionException e) {
                throw new JsonSyntaxException("Invalid expression " + expression, (Throwable)e);
            }
            if (this.variables.containsKey(name)) {
                ITickableNode.Source existing = this.variables.get(name);
                existing.setSource(node);
                continue;
            }
            if (stateful != null) {
                stateful.setSource(node);
                this.variables.put(name, stateful);
                continue;
            }
            NodeUpdatable nodeUpdatable = new NodeUpdatable(name, node);
            this.variables.put(name, nodeUpdatable);
            fnCtx.putVariable(name, nodeUpdatable.variable);
        }
    }

    private static NodeStateful.IGetterFunc parseGetterFunction(String getter, FunctionContext fnCtx) {
        if ("interpolate_partial_ticks".equalsIgnoreCase(getter)) {
            return NodeStateful.GetterType.INTERPOLATE_PARTIAL_TICKS;
        }
        if ("last".equalsIgnoreCase(getter)) {
            return NodeStateful.GetterType.USE_LAST;
        }
        if ("var".equalsIgnoreCase(getter)) {
            return NodeStateful.GetterType.USE_VAR;
        }
        return (var, last) -> {
            FunctionContext fnCtx2 = new FunctionContext(fnCtx);
            fnCtx2.putVariable("var", var);
            fnCtx2.putVariable("last", last);
            return InternalCompiler.compileExpression(getter, fnCtx2);
        };
    }

    public ITickableNode[] createTickableNodes() {
        ITickableNode[] nodes = new ITickableNode[this.variablesArray.length];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = this.variablesArray[i].createTickable();
        }
        return nodes;
    }

    public static interface ITextureGetter {
        public ModelUtil.TexturedFace get(String var1);
    }
}

