/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.model.json;

import buildcraft.api.core.BCLog;
import buildcraft.lib.client.model.MutableQuad;
import buildcraft.lib.client.model.ResourceLoaderContext;
import buildcraft.lib.client.model.json.JsonVariableModelPart;
import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.node.value.NodeConstantDouble;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.JsonUtils;

public abstract class JsonModelRule {
    public final IExpressionNode.INodeBoolean when;

    public JsonModelRule(IExpressionNode.INodeBoolean when) {
        this.when = when;
    }

    public static JsonModelRule deserialize(JsonElement json, FunctionContext fnCtx, ResourceLoaderContext ctx) {
        if (!json.isJsonObject()) {
            throw new JsonSyntaxException("Expected an object, got " + json);
        }
        JsonObject obj = json.getAsJsonObject();
        String when = JsonUtils.func_151200_h((JsonObject)obj, (String)"when");
        IExpressionNode.INodeBoolean nodeWhen = JsonVariableModelPart.convertStringToBooleanNode(when, fnCtx);
        String type = JsonUtils.func_151200_h((JsonObject)obj, (String)"type");
        if (type.startsWith("builtin:")) {
            String builtin = type.substring("builtin:".length());
            if ("rotate_facing".equals(builtin)) {
                String from = JsonUtils.func_151200_h((JsonObject)obj, (String)"from");
                IExpressionNode.INodeString nodeFrom = JsonVariableModelPart.convertStringToStringNode(from, fnCtx);
                String to = JsonUtils.func_151200_h((JsonObject)obj, (String)"to");
                IExpressionNode.INodeString nodeTo = JsonVariableModelPart.convertStringToStringNode(to, fnCtx);
                IExpressionNode.INodeDouble[] origin = obj.has("origin") ? JsonVariableModelPart.readVariablePosition(obj, "origin", fnCtx) : RuleRotateFacing.DEFAULT_ORIGIN;
                return new RuleRotateFacing(nodeWhen, nodeFrom, nodeTo, origin);
            }
            throw new JsonSyntaxException("Unknown built in rule type '" + builtin + "'");
        }
        throw new JsonSyntaxException("Unknown rule type '" + type + "'");
    }

    public abstract void apply(List<MutableQuad> var1);

    public static class RuleRotateFacing
    extends JsonModelRule {
        private static final NodeConstantDouble CONST_ORIGIN = new NodeConstantDouble(0.5);
        public static final IExpressionNode.INodeDouble[] DEFAULT_ORIGIN = new IExpressionNode.INodeDouble[]{CONST_ORIGIN, CONST_ORIGIN, CONST_ORIGIN};
        public final IExpressionNode.INodeString from;
        public final IExpressionNode.INodeString to;
        public final IExpressionNode.INodeDouble[] origin;
        private final Set<String> invalidFaceStrings = new HashSet<String>();

        public RuleRotateFacing(IExpressionNode.INodeBoolean when, IExpressionNode.INodeString from, IExpressionNode.INodeString to, IExpressionNode.INodeDouble[] origin) {
            super(when);
            this.from = from;
            this.to = to;
            this.origin = origin;
        }

        @Override
        public void apply(List<MutableQuad> quads) {
            EnumFacing faceTo;
            EnumFacing faceFrom = this.evaluateFace(this.from);
            if (faceFrom == (faceTo = this.evaluateFace(this.to))) {
                return;
            }
            float ox = (float)this.origin[0].evaluate();
            float oy = (float)this.origin[1].evaluate();
            float oz = (float)this.origin[2].evaluate();
            for (MutableQuad q : quads) {
                q.rotate(faceFrom, faceTo, ox, oy, oz);
            }
        }

        private EnumFacing evaluateFace(IExpressionNode.INodeString node) {
            String s = node.evaluate();
            EnumFacing face = EnumFacing.func_176739_a((String)s);
            if (face == null) {
                if (this.invalidFaceStrings.add(s)) {
                    BCLog.logger.warn("Invalid facing '" + s + "' from expression '" + node + "'");
                }
                return EnumFacing.UP;
            }
            return face;
        }
    }
}

