/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.model;

import buildcraft.api.core.BCLog;
import buildcraft.lib.client.model.ModelHolder;
import buildcraft.lib.client.model.ModelHolderRegistry;
import buildcraft.lib.client.model.ModelUtil;
import buildcraft.lib.client.model.MutableQuad;
import buildcraft.lib.client.model.json.JsonModelRule;
import buildcraft.lib.client.model.json.JsonTexture;
import buildcraft.lib.client.model.json.JsonVariableModel;
import buildcraft.lib.client.model.json.JsonVariableModelPart;
import buildcraft.lib.client.reload.ReloadManager;
import buildcraft.lib.client.reload.ReloadSource;
import buildcraft.lib.client.reload.SourceType;
import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.node.value.ITickableNode;
import buildcraft.lib.misc.SpriteUtil;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;

public class ModelHolderVariable
extends ModelHolder {
    private final FunctionContext context;
    private JsonVariableModel rawModel;
    private boolean unseen = true;

    public ModelHolderVariable(String modelLocation, FunctionContext context) {
        super(modelLocation);
        this.context = context;
    }

    @Override
    public boolean hasBakedQuads() {
        return this.rawModel != null;
    }

    @Override
    protected void onTextureStitchPre(Set<ResourceLocation> toRegisterSprites) {
        this.rawModel = null;
        this.failReason = null;
        try {
            this.rawModel = JsonVariableModel.deserialize(this.modelLocation, this.context);
        }
        catch (JsonParseException jse) {
            this.rawModel = null;
            this.failReason = "The model had errors: " + jse.getMessage();
            BCLog.logger.warn("[lib.model.holder] Failed to load the model " + this.modelLocation + " because ", (Throwable)jse);
        }
        catch (IOException io) {
            this.rawModel = null;
            this.failReason = "The model did not exist in any resource pack: " + io.getMessage();
            BCLog.logger.warn("[lib.model.holder] Failed to load the model " + this.modelLocation + " because ", (Throwable)io);
        }
        if (this.rawModel != null) {
            if (ModelHolderRegistry.DEBUG) {
                BCLog.logger.info("[lib.model.holder] The model " + this.modelLocation + " requires these sprites:");
            }
            ReloadSource srcModel = new ReloadSource(this.modelLocation, SourceType.MODEL);
            for (Map.Entry<String, JsonTexture> entry : this.rawModel.textures.entrySet()) {
                JsonTexture lookup = entry.getValue();
                String location = lookup.location;
                if (location.startsWith("#")) continue;
                ResourceLocation textureLoc = new ResourceLocation(location);
                toRegisterSprites.add(textureLoc);
                ReloadSource srcSprite = new ReloadSource(SpriteUtil.transformLocation(textureLoc), SourceType.SPRITE);
                ReloadManager.INSTANCE.addDependency(srcSprite, srcModel);
                if (!ModelHolderRegistry.DEBUG) continue;
                BCLog.logger.info("[lib.model.holder]  - " + location);
            }
        }
    }

    @Override
    protected void onModelBake() {
    }

    private MutableQuad[] bakePart(JsonVariableModelPart[] a) {
        ArrayList<MutableQuad> list = new ArrayList<MutableQuad>();
        for (JsonVariableModelPart part : a) {
            part.addQuads(list, this::lookupTexture);
        }
        for (JsonModelRule rule : this.rawModel.rules) {
            if (!rule.when.evaluate()) continue;
            rule.apply(list);
        }
        return list.toArray(new MutableQuad[list.size()]);
    }

    private ModelUtil.TexturedFace lookupTexture(String lookup) {
        JsonTexture tex;
        JsonTexture texture = new JsonTexture(lookup);
        for (int attempts = 0; texture.location.startsWith("#") && attempts < 10 && (tex = this.rawModel.textures.get(texture.location)) != null; ++attempts) {
            texture = texture.inParent(tex);
        }
        lookup = texture.location;
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(lookup);
        ModelUtil.TexturedFace face = new ModelUtil.TexturedFace();
        face.sprite = sprite;
        face.faceData = texture.faceData;
        return face;
    }

    private void printNoModelWarning() {
        if (this.unseen) {
            this.unseen = false;
            String warnText = "[lib.model.holder] Tried to use the model " + this.modelLocation + " before it was baked!";
            if (ModelHolderRegistry.DEBUG) {
                BCLog.logger.warn(warnText, new Throwable());
            } else {
                BCLog.logger.warn(warnText);
            }
        }
    }

    public ITickableNode[] createTickableNodes() {
        if (this.rawModel == null) {
            this.printNoModelWarning();
            return new ITickableNode[0];
        }
        return this.rawModel.createTickableNodes();
    }

    public MutableQuad[] getCutoutQuads() {
        if (this.rawModel == null) {
            this.printNoModelWarning();
            return MutableQuad.EMPTY_ARRAY;
        }
        return this.bakePart(this.rawModel.cutoutElements);
    }

    public MutableQuad[] getTranslucentQuads() {
        if (this.rawModel == null) {
            this.printNoModelWarning();
            return MutableQuad.EMPTY_ARRAY;
        }
        return this.bakePart(this.rawModel.translucentElements);
    }
}

