/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.parts.recipe;

import buildcraft.lib.client.guide.parts.GuidePartFactory;
import buildcraft.lib.client.guide.parts.recipe.GuideCraftingFactory;
import buildcraft.lib.client.guide.parts.recipe.IStackRecipes;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.recipe.ChangingItemStack;
import buildcraft.lib.recipe.IRecipeViewable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public enum GuideCraftingRecipes implements IStackRecipes
{
    INSTANCE;


    @Override
    public List<GuidePartFactory> getUsages(@Nonnull ItemStack target) {
        ArrayList<GuidePartFactory> list = new ArrayList<GuidePartFactory>();
        for (IRecipe recipe : CraftingManager.func_77594_a().func_77592_b()) {
            GuidePartFactory factory;
            if (!GuideCraftingRecipes.checkRecipeUses(recipe, target) || (factory = GuideCraftingFactory.getFactory(recipe)) == null) continue;
            list.add(factory);
        }
        return list;
    }

    private static boolean checkRecipeUses(IRecipe recipe, @Nonnull ItemStack target) {
        block6: {
            block9: {
                block8: {
                    block7: {
                        block5: {
                            if (!(recipe instanceof ShapedRecipes)) break block5;
                            ShapedRecipes shaped = (ShapedRecipes)recipe;
                            for (ItemStack in : shaped.field_77574_d) {
                                if (!StackUtil.doesEitherStackMatch(StackUtil.asNonNull(in), target)) continue;
                                return true;
                            }
                            break block6;
                        }
                        if (!(recipe instanceof ShapelessRecipes)) break block7;
                        ShapelessRecipes shapeless = (ShapelessRecipes)recipe;
                        for (ItemStack in : shapeless.field_77579_b) {
                            if (!StackUtil.doesEitherStackMatch(StackUtil.asNonNull(in), target)) continue;
                            return true;
                        }
                        break block6;
                    }
                    if (!(recipe instanceof ShapedOreRecipe)) break block8;
                    ShapedOreRecipe ore = (ShapedOreRecipe)recipe;
                    for (Object in : ore.getInput()) {
                        if (!GuideCraftingRecipes.matches(target, in)) continue;
                        return true;
                    }
                    break block6;
                }
                if (!(recipe instanceof ShapelessOreRecipe)) break block9;
                ShapelessOreRecipe ore = (ShapelessOreRecipe)recipe;
                for (Object in : ore.getInput()) {
                    if (!GuideCraftingRecipes.matches(target, in)) continue;
                    return true;
                }
                break block6;
            }
            if (!(recipe instanceof IRecipeViewable)) break block6;
            IRecipeViewable viewable = (IRecipeViewable)recipe;
            for (ChangingItemStack changing : viewable.getRecipeInputs()) {
                if (!changing.matches(target)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean matches(@Nonnull ItemStack target, @Nullable Object in) {
        if (in instanceof ItemStack) {
            return StackUtil.doesEitherStackMatch((ItemStack)in, target);
        }
        if (in instanceof List) {
            for (Object obj : (List)in) {
                if (!(obj instanceof ItemStack) || !StackUtil.doesEitherStackMatch((ItemStack)obj, target)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<GuidePartFactory> getRecipes(@Nonnull ItemStack target) {
        ArrayList<GuidePartFactory> list = new ArrayList<GuidePartFactory>();
        for (IRecipe recipe : CraftingManager.func_77594_a().func_77592_b()) {
            GuidePartFactory factory;
            if (recipe instanceof IRecipeViewable) {
                ChangingItemStack changing = ((IRecipeViewable)recipe).getRecipeOutputs();
                if (!changing.matches(target) || (factory = GuideCraftingFactory.getFactory(recipe)) == null) continue;
                list.add(factory);
                continue;
            }
            ItemStack out = StackUtil.asNonNull(recipe.func_77571_b());
            if (!OreDictionary.itemMatches((ItemStack)target, (ItemStack)out, (boolean)false) && !OreDictionary.itemMatches((ItemStack)out, (ItemStack)target, (boolean)false) || (factory = GuideCraftingFactory.getFactory(recipe)) == null) continue;
            list.add(factory);
        }
        return list;
    }
}

