/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.parts.recipe;

import buildcraft.api.core.BCLog;
import buildcraft.lib.client.guide.GuiGuide;
import buildcraft.lib.client.guide.parts.GuidePartFactory;
import buildcraft.lib.client.guide.parts.recipe.GuideCrafting;
import buildcraft.lib.client.guide.parts.recipe.GuideCraftingFactoryDirect;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.misc.data.NonNullMatrix;
import buildcraft.lib.recipe.ChangingItemStack;
import buildcraft.lib.recipe.IRecipeViewable;
import java.lang.reflect.Field;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class GuideCraftingFactory
implements GuidePartFactory {
    private static final Field SHAPED_ORE_RECIPE___WIDTH;
    private static final Field SHAPED_ORE_RECIPE___HEIGHT;
    private final NonNullMatrix<ItemStack> input;
    @Nonnull
    private final ItemStack output;
    private final int hash;

    public GuideCraftingFactory(ItemStack[][] input, ItemStack output) {
        this.input = new NonNullMatrix<ItemStack>(input, StackUtil.EMPTY);
        this.output = StackUtil.asNonNull(output);
        NBTTagList hashNbt = new NBTTagList();
        for (ItemStack stack : this.input) {
            hashNbt.func_74742_a((NBTBase)stack.serializeNBT());
        }
        this.hash = hashNbt.hashCode();
    }

    public static GuidePartFactory create(@Nonnull ItemStack stack) {
        for (IRecipe recipe : CraftingManager.func_77594_a().func_77592_b()) {
            if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)StackUtil.asNonNull(recipe.func_77571_b()), (boolean)false)) continue;
            GuidePartFactory val = GuideCraftingFactory.getFactory(recipe);
            if (val != null) {
                return val;
            }
            BCLog.logger.warn("[lib.guide.crafting] Found a matching recipe, but of an unknown " + recipe.getClass() + " for " + stack.func_82833_r());
        }
        return null;
    }

    public static GuidePartFactory getFactory(IRecipe recipe) {
        GuideCraftingFactory val = null;
        if (recipe instanceof ShapedRecipes) {
            ShapedRecipes shaped = (ShapedRecipes)recipe;
            ItemStack[] input = shaped.field_77574_d;
            ItemStack[][] dimInput = new ItemStack[shaped.field_77576_b][shaped.field_77577_c];
            for (int x = 0; x < dimInput.length; ++x) {
                for (int y = 0; y < dimInput[x].length; ++y) {
                    dimInput[x][y] = input[x + y * dimInput.length].func_77946_l();
                }
            }
            val = new GuideCraftingFactory(dimInput, recipe.func_77571_b());
        } else if (recipe instanceof ShapedOreRecipe) {
            Object[] input = ((ShapedOreRecipe)recipe).getInput();
            ItemStack[][] dimInput = GuideCraftingFactory.getStackSizeArray(recipe);
            for (int x = 0; x < dimInput.length; ++x) {
                for (int y = 0; y < dimInput[x].length; ++y) {
                    dimInput[x][y] = GuideCraftingFactory.oreConvert(input[x + y * dimInput.length]);
                }
            }
            val = new GuideCraftingFactory(dimInput, recipe.func_77571_b());
        } else if (recipe instanceof ShapelessOreRecipe) {
            NonNullList input = ((ShapelessOreRecipe)recipe).getInput();
            ItemStack[][] dimInput = GuideCraftingFactory.getStackSizeArray(recipe);
            for (int x = 0; x < dimInput.length; ++x) {
                for (int y = 0; y < dimInput[x].length; ++y) {
                    int index = x + y * dimInput.length;
                    if (index >= input.size()) continue;
                    dimInput[x][y] = GuideCraftingFactory.oreConvert(input.get(index));
                }
            }
            val = new GuideCraftingFactory(dimInput, recipe.func_77571_b());
        } else if (recipe instanceof ShapelessRecipes) {
            List input = ((ShapelessRecipes)recipe).field_77579_b;
            ItemStack[][] dimInput = GuideCraftingFactory.getStackSizeArray(recipe);
            for (int x = 0; x < dimInput.length; ++x) {
                for (int y = 0; y < dimInput[x].length; ++y) {
                    int index = x + y * dimInput.length;
                    if (index >= input.size()) continue;
                    dimInput[x][y] = ((ItemStack)input.get(index)).func_77946_l();
                }
            }
            val = new GuideCraftingFactory(dimInput, recipe.func_77571_b());
        } else {
            if (recipe instanceof IRecipeViewable) {
                IRecipeViewable viewableRecipe = (IRecipeViewable)recipe;
                ChangingItemStack[] input = viewableRecipe.getRecipeInputs();
                ChangingItemStack output = viewableRecipe.getRecipeOutputs();
                ChangingItemStack[][] inputGrid = new ChangingItemStack[][]{input};
                if (recipe instanceof IRecipeViewable.IViewableGrid) {
                    IRecipeViewable.IViewableGrid recipeGrid = (IRecipeViewable.IViewableGrid)recipe;
                    int width = recipeGrid.getRecipeWidth();
                    int height = recipeGrid.getRecipeHeight();
                    inputGrid = new ChangingItemStack[width][height];
                    int x = 0;
                    int y = 0;
                    ChangingItemStack[] changingItemStackArray = input;
                    int n = changingItemStackArray.length;
                    for (int i = 0; i < n; ++i) {
                        ChangingItemStack anInput;
                        inputGrid[x][y] = anInput = changingItemStackArray[i];
                        if (++x < width) continue;
                        x = 0;
                        ++y;
                    }
                }
                return new GuideCraftingFactoryDirect(inputGrid, output);
            }
            BCLog.logger.warn("[lib.guide.crafting] Found an unknown recipe " + recipe.getClass());
        }
        return val;
    }

    private static ItemStack[][] getStackSizeArray(IRecipe recipe) {
        if (recipe instanceof ShapedRecipes) {
            return new ItemStack[((ShapedRecipes)recipe).field_77576_b][((ShapedRecipes)recipe).field_77577_c];
        }
        if (recipe instanceof ShapedOreRecipe) {
            int width = 3;
            int height = 3;
            try {
                width = SHAPED_ORE_RECIPE___WIDTH.getInt(recipe);
                height = SHAPED_ORE_RECIPE___HEIGHT.getInt(recipe);
            }
            catch (Throwable t) {
                BCLog.logger.error("Could not access the required shaped ore recipe fields!", t);
            }
            return new ItemStack[width][height];
        }
        return new ItemStack[3][3];
    }

    @Nonnull
    private static ItemStack oreConvert(Object object) {
        if (object == null) {
            return StackUtil.EMPTY;
        }
        if (object instanceof ItemStack) {
            return ((ItemStack)object).func_77946_l();
        }
        if (object instanceof String) {
            NonNullList stacks = OreDictionary.getOres((String)((String)object));
            object = stacks;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (list.isEmpty()) {
                return StackUtil.EMPTY;
            }
            Object first = list.get(0);
            if (first == null) {
                return StackUtil.EMPTY;
            }
            if (first instanceof ItemStack) {
                ItemStack best = (ItemStack)first;
                for (Object obj : list) {
                    ItemStack stack;
                    if (!(obj instanceof ItemStack) || Item.func_150891_b((Item)(stack = (ItemStack)obj).func_77973_b()) >= Item.func_150891_b((Item)best.func_77973_b())) continue;
                    best = stack;
                }
                return best.func_77946_l();
            }
            BCLog.logger.warn("Found a list with unknown contents! " + first.getClass());
        }
        BCLog.logger.warn("Found an ore with an unknown " + object.getClass());
        return StackUtil.EMPTY;
    }

    public static GuidePartFactory create(Item output) {
        return GuideCraftingFactory.create(new ItemStack(output));
    }

    @Override
    public GuideCrafting createNew(GuiGuide gui) {
        return new GuideCrafting(gui, this.input, this.output);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        GuideCraftingFactory other = (GuideCraftingFactory)obj;
        if (this.hash != other.hash) {
            return false;
        }
        if (this.input.getWidth() != other.input.getWidth() || this.input.getHeight() != other.input.getHeight()) {
            return false;
        }
        for (int i = 0; i < this.input.size(); ++i) {
            ItemStack stackOther;
            ItemStack stackThis = this.input.get(i);
            if (ItemStack.func_77989_b((ItemStack)stackThis, (ItemStack)(stackOther = other.input.get(i)))) continue;
            return false;
        }
        return ItemStack.func_77989_b((ItemStack)this.output, (ItemStack)other.output);
    }

    static {
        try {
            SHAPED_ORE_RECIPE___WIDTH = ShapedOreRecipe.class.getDeclaredField("width");
            SHAPED_ORE_RECIPE___WIDTH.setAccessible(true);
            SHAPED_ORE_RECIPE___HEIGHT = ShapedOreRecipe.class.getDeclaredField("height");
            SHAPED_ORE_RECIPE___HEIGHT.setAccessible(true);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not find the width field!", t);
        }
    }
}

