/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.parts.recipe;

import buildcraft.api.recipes.AssemblyRecipe;
import buildcraft.api.recipes.IAssemblyRecipeProvider;
import buildcraft.lib.client.guide.parts.GuidePartFactory;
import buildcraft.lib.client.guide.parts.recipe.GuideAssemblyFactory;
import buildcraft.lib.client.guide.parts.recipe.IStackRecipes;
import buildcraft.lib.misc.ArrayUtil;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.recipe.AssemblyRecipeRegistry;
import buildcraft.lib.recipe.ChangingItemStack;
import buildcraft.lib.recipe.ChangingObject;
import buildcraft.lib.recipe.IRecipeViewable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public enum GuideAssemblyRecipes implements IStackRecipes
{
    INSTANCE;


    @Override
    public List<GuidePartFactory> getUsages(@Nonnull ItemStack stack) {
        ArrayList<GuidePartFactory> usages = new ArrayList<GuidePartFactory>();
        for (AssemblyRecipe recipe : AssemblyRecipeRegistry.INSTANCE.getAllRecipes()) {
            if (!recipe.requiredStacks.stream().anyMatch(definition -> definition.filter.matches(stack))) continue;
            usages.add(this.getFactory(recipe));
        }
        for (IAssemblyRecipeProvider adv : AssemblyRecipeRegistry.INSTANCE.getAllRecipeProviders()) {
            IRecipeViewable.IRecipePowered view;
            ChangingItemStack[] in;
            if (!(adv instanceof IRecipeViewable.IRecipePowered) || !ArrayUtil.testForAny(in = (view = (IRecipeViewable.IRecipePowered)((Object)adv)).getRecipeInputs(), c -> c.matches(stack))) continue;
            ChangingItemStack out = view.getRecipeOutputs();
            usages.add(new GuideAssemblyFactory(in, out, view.getMjCost()));
        }
        return usages;
    }

    @Override
    public List<GuidePartFactory> getRecipes(@Nonnull ItemStack stack) {
        ArrayList<GuidePartFactory> recipes = new ArrayList<GuidePartFactory>();
        for (AssemblyRecipe recipe : AssemblyRecipeRegistry.INSTANCE.getAllRecipes()) {
            if (!StackUtil.isCraftingEquivalent(recipe.output, stack, false)) continue;
            recipes.add(this.getFactory(recipe));
        }
        for (IAssemblyRecipeProvider adv : AssemblyRecipeRegistry.INSTANCE.getAllRecipeProviders()) {
            IRecipeViewable.IRecipePowered view;
            ChangingItemStack out;
            if (!(adv instanceof IRecipeViewable.IRecipePowered) || !(out = (view = (IRecipeViewable.IRecipePowered)((Object)adv)).getRecipeOutputs()).matches(stack)) continue;
            ChangingItemStack[] in = view.getRecipeInputs();
            recipes.add(new GuideAssemblyFactory(in, out, view.getMjCost()));
        }
        return recipes;
    }

    private GuideAssemblyFactory getFactory(AssemblyRecipe recipe) {
        ChangingItemStack[] stacks = (ChangingItemStack[])recipe.requiredStacks.stream().map(definition -> {
            NonNullList items = definition.filter.getExamples().stream().map(ItemStack::func_77946_l).collect(StackUtil.nonNullListCollector());
            items.forEach(stack -> stack.func_190920_e(definition.count));
            return items;
        }).map(ChangingItemStack::new).toArray(ChangingItemStack[]::new);
        return new GuideAssemblyFactory(stacks, ChangingItemStack.create(recipe.output), new ChangingObject<Long>(new Long[]{recipe.requiredMicroJoules}));
    }
}

