/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.parts.recipe;

import buildcraft.lib.client.guide.GuiGuide;
import buildcraft.lib.client.guide.parts.GuidePart;
import buildcraft.lib.client.guide.parts.GuidePartItem;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.recipe.ChangingItemStack;
import buildcraft.lib.recipe.ChangingObject;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;

public class GuideAssembly
extends GuidePartItem {
    public static final GuiIcon INPUT_LIST = new GuiIcon(GuiGuide.ICONS_2, 119, 108, 98, 54);
    public static final GuiRectangle[] ITEM_POSITION = new GuiRectangle[6];
    public static final GuiRectangle OUT_POSITION = new GuiRectangle(77, 19, 16, 16);
    public static final GuiRectangle MJ_POSITION = new GuiRectangle(50, 4, 6, 46);
    public static final GuiRectangle OFFSET = new GuiRectangle((GuiGuide.PAGE_LEFT_TEXT.width - GuideAssembly.INPUT_LIST.width) / 2, 0, GuideAssembly.INPUT_LIST.width, GuideAssembly.INPUT_LIST.height);
    public static final int PIXEL_HEIGHT = 60;
    private final ChangingItemStack[] input;
    private final ChangingItemStack output;
    private final ChangingObject<Long> mjCost;

    GuideAssembly(GuiGuide gui, ChangingItemStack[] input, ChangingItemStack output, ChangingObject<Long> mjCost) {
        super(gui);
        this.input = input;
        this.output = output;
        this.mjCost = mjCost;
    }

    @Override
    public GuidePart.PagePosition renderIntoArea(int x, int y, int width, int height, GuidePart.PagePosition current, int index) {
        if (current.pixel + 60 > height) {
            current = current.newPage();
        }
        x += GuideAssembly.OFFSET.x;
        y += GuideAssembly.OFFSET.y + current.pixel;
        if (current.page == index) {
            INPUT_LIST.drawAt(x, y);
            GlStateManager.func_179091_B();
            RenderHelper.func_74520_c();
            for (int i = 0; i < this.input.length; ++i) {
                GuiRectangle rect = ITEM_POSITION[i];
                ItemStack stack = (ItemStack)this.input[i].get();
                this.drawItemStack(stack, x + rect.x, y + rect.y);
            }
            this.drawItemStack((ItemStack)this.output.get(), x + GuideAssembly.OUT_POSITION.x, y + GuideAssembly.OUT_POSITION.y);
            if (MJ_POSITION.offset(x, y).contains(this.gui.mouse)) {
                this.gui.tooltip.add(LocaleUtil.localizeMj(this.mjCost.get()));
            }
            RenderHelper.func_74518_a();
            GlStateManager.func_179101_C();
        }
        current = current.nextLine(60, height);
        return current;
    }

    @Override
    public GuidePart.PagePosition handleMouseClick(int x, int y, int width, int height, GuidePart.PagePosition current, int index, int mouseX, int mouseY) {
        if (current.pixel + 60 > height) {
            current = current.newPage();
        }
        x += GuideAssembly.OFFSET.x;
        y += GuideAssembly.OFFSET.y + current.pixel;
        if (current.page == index) {
            for (int i = 0; i < this.input.length; ++i) {
                GuiRectangle rect = ITEM_POSITION[i];
                ItemStack stack = (ItemStack)this.input[i].get();
                this.testClickItemStack(stack, x + rect.x, y + rect.y);
            }
            this.testClickItemStack((ItemStack)this.output.get(), x + GuideAssembly.OUT_POSITION.x, y + GuideAssembly.OUT_POSITION.y);
        }
        current = current.nextLine(60, height);
        return current;
    }

    static {
        for (int x = 0; x < 2; ++x) {
            for (int y = 0; y < 3; ++y) {
                GuideAssembly.ITEM_POSITION[x + y * 2] = new GuiRectangle(1 + x * 18, 1 + y * 18, 16, 16);
            }
        }
    }
}

