/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.parts;

import buildcraft.api.core.BCLog;
import buildcraft.lib.client.guide.GuiGuide;
import buildcraft.lib.client.guide.GuideManager;
import buildcraft.lib.client.guide.PageEntry;
import buildcraft.lib.client.guide.PageLine;
import buildcraft.lib.client.guide.TypeOrder;
import buildcraft.lib.client.guide.font.IFontRenderer;
import buildcraft.lib.client.guide.loader.XmlPageLoader;
import buildcraft.lib.client.guide.node.NodePageLine;
import buildcraft.lib.client.guide.parts.GuideChapter;
import buildcraft.lib.client.guide.parts.GuideChapterWithin;
import buildcraft.lib.client.guide.parts.GuidePageBase;
import buildcraft.lib.client.guide.parts.GuidePageFactory;
import buildcraft.lib.client.guide.parts.GuidePart;
import buildcraft.lib.client.guide.parts.GuideText;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.GuiStack;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.misc.LocaleUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class GuidePageContents
extends GuidePageBase {
    private static final int ORDER_OFFSET_X = -50;
    private static final int ORDER_OFFSET_Y = 14;
    private final Map<GuidePart, PageEntry> pageEntries = new HashMap<GuidePart, PageEntry>();
    private NodePageLine parentNode;

    public GuidePageContents(GuiGuide gui) {
        super(gui);
        this.loadMainGui();
    }

    public void loadMainGui() {
        this.parentNode = new NodePageLine(null, null);
        TypeOrder order = GuiGuide.SORTING_TYPES[this.gui.sortingOrderIndex];
        for (PageEntry entry : GuideManager.INSTANCE.getAllEntries()) {
            Object line2;
            String[] ordered = entry.typeTags.getOrdered(order);
            NodePageLine node = this.parentNode;
            int indent = 1;
            for (Object line2 : ordered) {
                String translated = TextFormatting.UNDERLINE + I18n.func_135052_a((String)line2, (Object[])new Object[0]);
                boolean notFound = true;
                for (NodePageLine childNode : node.getChildren()) {
                    if (!(childNode.part instanceof GuideChapter) || !translated.equals(((GuideChapter)childNode.part).chapter.text)) continue;
                    node = childNode;
                    notFound = false;
                    break;
                }
                if (notFound) {
                    node = node.addChild(new GuideChapterWithin(this.gui, indent, translated));
                }
                ++indent;
            }
            String translatedTitle = I18n.func_135052_a((String)entry.title, (Object[])new Object[0]);
            ItemStack stack = entry.getItemStack();
            GuiStack icon = null;
            if (stack != null) {
                icon = new GuiStack(stack);
            }
            line2 = new PageLine(icon, icon, indent, translatedTitle, true);
            GuideText text = new GuideText(this.gui, (PageLine)line2);
            node.addChild(text);
            this.pageEntries.put(text, entry);
        }
        this.parentNode.sortChildrenRecursively();
    }

    @Override
    public void setFontRenderer(IFontRenderer fontRenderer) {
        super.setFontRenderer(fontRenderer);
        this.parentNode.setFontRenderer(fontRenderer);
    }

    @Override
    public List<GuideChapter> getChapters() {
        ArrayList<GuideChapter> list = new ArrayList<GuideChapter>();
        for (GuidePart part : this.parentNode.iterateNonNullLines()) {
            if (!(part instanceof GuideChapter) || ((GuideChapter)part).chapter.indent != 1) continue;
            list.add((GuideChapter)part);
        }
        return list;
    }

    @Override
    public String getTitle() {
        return null;
    }

    @Override
    protected void renderPage(int x, int y, int width, int height, int index) {
        IFontRenderer f = this.getFontRenderer();
        if (index == 0) {
            String text = "BuildCraft";
            float scale = 3.0f;
            int fWidth = (int)((float)f.getStringWidth(text) * scale);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            f.drawString(text, (int)((float)(x + (width - fWidth) / 2) / scale), (int)((float)(y + height / 2 - 62) / scale), 0);
            GlStateManager.func_179121_F();
            text = "v7.99.7";
            fWidth = f.getStringWidth(text);
            f.drawString(text, x + (width - fWidth) / 2, y + height / 2 - 36, 0);
            scale = 1.5f;
            text = LocaleUtil.localize("options.title");
            fWidth = (int)((float)f.getStringWidth(text) * scale);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            f.drawString(text, (int)((float)(x + (width - fWidth) / 2) / scale), (int)((float)(y + height / 2 - 4) / scale), 0);
            GlStateManager.func_179121_F();
            text = XmlPageLoader.SHOW_LORE ? "Show Lore [x]" : "Show Lore [ ]";
            fWidth = f.getStringWidth(text);
            f.drawString(text, x + (width - fWidth) / 2, y + height / 2 + 12, 0);
            text = XmlPageLoader.SHOW_HINTS ? "Show Hints [x]" : "Show Hints [ ]";
            fWidth = f.getStringWidth(text);
            f.drawString(text, x + (width - fWidth) / 2, y + height / 2 + 26, 0);
        } else if (index == 1) {
            int _height = GuideManager.loadedMods.size() + 1;
            if (GuideManager.loadedOther.size() > 0) {
                ++_height;
                _height += GuideManager.loadedOther.size();
            }
            int perLineHeight = f.getFontHeight("Ly") + 3;
            int _y = y + (height - (_height *= perLineHeight)) / 2;
            this.drawCenteredText(TextFormatting.BOLD + "Loaded Mods:", x, _y, width);
            _y += perLineHeight;
            for (String text : GuideManager.loadedMods) {
                this.drawCenteredText(text, x, _y, width);
                _y += perLineHeight;
            }
            if (GuideManager.loadedOther.size() > 0) {
                this.drawCenteredText(TextFormatting.BOLD + "Loaded Resource Packs:", x, _y, width);
                _y += perLineHeight;
                for (String text : GuideManager.loadedOther) {
                    this.drawCenteredText(text, x, _y, width);
                    _y += perLineHeight;
                }
            }
        }
        GuidePart.PagePosition pos = new GuidePart.PagePosition(2, 0);
        for (GuidePart part : this.parentNode.iterateNonNullLines()) {
            pos = part.renderIntoArea(x, y, width, height, pos, index);
        }
        if (this.numPages == -1) {
            this.numPages = pos.page + 1;
        }
        super.renderPage(x, y, width, height, index);
        if (index % 2 == 0) {
            int oX = x + -50;
            int oY = y + 14;
            int i = 0;
            for (GuiIcon icon : GuiGuide.ORDERS) {
                if (this.gui.sortingOrderIndex == i) {
                    icon = icon.offset(0, 14);
                }
                icon.drawAt(oX, oY);
                oY += 14;
                ++i;
            }
        }
    }

    private void drawCenteredText(String text, int x, int y, int width) {
        IFontRenderer f = this.getFontRenderer();
        int fWidth = f.getStringWidth(text);
        f.drawString(text, x + (width - fWidth) / 2, y, 0);
    }

    private void drawScaledCenteredText(float scale, String text, int x, int y, int width) {
        IFontRenderer f = this.getFontRenderer();
        int fWidth = (int)((float)f.getStringWidth(text) * scale);
        if (scale != 1.0f) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        }
        f.drawString(text, (int)((float)(x + (width - fWidth) / 2) / scale), (int)((float)y / scale), 0);
        if (scale != 1.0f) {
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void handleMouseClick(int x, int y, int width, int height, int mouseX, int mouseY, int mouseButton, int index, boolean isEditing) {
        GuidePart part;
        GuiRectangle rect;
        super.handleMouseClick(x, y, width, height, mouseX, mouseY, mouseButton, index, isEditing);
        if (index % 2 == 0) {
            int oX = x + -50;
            int oY = y + 14;
            for (int i = 0; i < GuiGuide.ORDERS.length; ++i) {
                rect = new GuiRectangle(oX, oY, 14, 14);
                if (rect.contains(this.gui.mouse)) {
                    this.gui.sortingOrderIndex = i;
                    this.loadMainGui();
                    this.gui.refreshChapters();
                    this.parentNode.setFontRenderer(this.getFontRenderer());
                    return;
                }
                oY += 14;
            }
        }
        if (mouseButton == 0 && index == 0) {
            String text;
            IFontRenderer f = this.getFontRenderer();
            int fWidth = f.getStringWidth(text = XmlPageLoader.SHOW_LORE ? "Show Lore [x]" : "Show Lore [ ]");
            rect = new GuiRectangle(x + (width - fWidth) / 2, y + height / 2 + 12, fWidth, f.getFontHeight(text));
            if (rect.contains(mouseX, mouseY)) {
                XmlPageLoader.SHOW_LORE = !XmlPageLoader.SHOW_LORE;
            }
            if ((rect = new GuiRectangle(x + (width - (fWidth = f.getStringWidth(text = XmlPageLoader.SHOW_HINTS ? "Show Hints [x]" : "Show Hints [ ]"))) / 2, y + height / 2 + 26, fWidth, f.getFontHeight(text))).contains(mouseX, mouseY)) {
                boolean bl = XmlPageLoader.SHOW_HINTS = !XmlPageLoader.SHOW_HINTS;
            }
        }
        if ((part = this.getClicked(this.parentNode.iterateNonNullLines(), x, y, width, height, mouseX, mouseY, index - 2)) != null) {
            PageEntry entry = this.pageEntries.get(part);
            if (entry != null) {
                GuidePageFactory factory = GuideManager.INSTANCE.getFactoryFor(entry);
                if (factory != null) {
                    this.gui.openPage(factory.createNew(this.gui));
                } else {
                    BCLog.logger.warn("Somehow encountered a null link factory! (line = " + part + ", link = " + entry + ")");
                }
            } else {
                BCLog.logger.warn("Somehow encountered a null link! (line = " + part + ")");
            }
        }
    }
}

