/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.font;

import buildcraft.lib.client.guide.font.IFontRenderer;
import buildcraft.lib.client.sprite.DynamicTextureBC;
import buildcraft.lib.misc.RenderUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;

public class GuideFont
implements IFontRenderer {
    private final DynamicTextureBC tex = new DynamicTextureBC(512, 512);
    private final BufferedImage img;
    private final Graphics2D g2d;
    private final Font font;

    public GuideFont(Font font) {
        this.font = font;
        this.img = new BufferedImage(512, 512, 2);
        this.g2d = this.img.createGraphics();
    }

    @Override
    public int getStringWidth(String text) {
        FontMetrics metrics = this.g2d.getFontMetrics(this.font);
        Rectangle2D rect = metrics.getStringBounds(text, this.g2d);
        return (int)rect.getWidth();
    }

    @Override
    public int getFontHeight(String text) {
        FontMetrics metrics = this.g2d.getFontMetrics(this.font);
        Rectangle2D rect = metrics.getStringBounds(text, this.g2d);
        return (int)rect.getHeight();
    }

    @Override
    public int drawString(String text, int x, int y, int shade, float scale) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution res = new ScaledResolution(mc);
        double scaleFactor = (double)mc.field_71443_c / res.func_78327_c();
        this.g2d.setColor(new Color(0, 0, 0, 255));
        this.g2d.fillRect(0, 0, 512, 512);
        this.g2d.setColor(new Color(0xFFFFFF));
        Font f2 = this.font.deriveFont(this.font.getSize2D() * scale * (float)scaleFactor);
        FontMetrics metrics = this.g2d.getFontMetrics(f2);
        this.g2d.setFont(f2);
        Rectangle2D rect = metrics.getStringBounds(text, this.g2d);
        int font_height = (int)rect.getHeight();
        this.g2d.drawString(text, 0, font_height);
        for (int _x = 0; _x < 512; ++_x) {
            for (int _y = 0; _y < font_height; ++_y) {
                int rgb = this.img.getRGB(_x, _y);
                if ((rgb & 0xFF) == 0) {
                    rgb = 0;
                }
                this.tex.setColor(_x, _y, rgb);
            }
        }
        GlStateManager.func_179141_d();
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)(1.0 / scaleFactor), (double)(1.0 / scaleFactor), (double)1.0);
        if ((shade & 0xFF000000) == 0) {
            shade |= 0xFF000000;
        }
        RenderUtil.setGLColorFromIntPlusAlpha(shade);
        this.tex.draw((int)((double)x * scaleFactor), (int)((double)y * scaleFactor - (double)metrics.getDescent()), 0.0f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179126_j();
        return this.g2d.getFontMetrics().stringWidth(text);
    }
}

