/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.data;

import buildcraft.api.core.BCLog;
import buildcraft.lib.client.guide.ETypeTag;
import buildcraft.lib.client.guide.TypeOrder;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.StringUtils;

public class JsonTypeTags {
    public static final JsonTypeTags EMPTY = new JsonTypeTags("", "", "", "");
    public final String mod;
    public final String type;
    @SerializedName(value="sub_mod")
    public final String subMod;
    @SerializedName(value="sub_type")
    public final String subType;

    public JsonTypeTags(String mod, String subMod, String type, String subType) {
        this.mod = mod;
        this.subMod = subMod;
        this.type = type;
        this.subType = subType;
    }

    public String[] getOrdered(TypeOrder typeOrder) {
        String[] strings = new String[typeOrder.tags.size()];
        for (int i = 0; i < strings.length; ++i) {
            ETypeTag tag = (ETypeTag)((Object)typeOrder.tags.get(i));
            strings[i] = this.getTyped(tag);
        }
        return strings;
    }

    private String getTyped(ETypeTag tag) {
        String typed;
        if (tag == ETypeTag.MOD) {
            typed = this.mod;
        } else if (tag == ETypeTag.SUB_MOD) {
            typed = this.subMod;
        } else if (tag == ETypeTag.TYPE) {
            typed = this.type;
        } else if (tag == ETypeTag.SUB_TYPE) {
            typed = this.subType;
        } else {
            throw new IllegalStateException("Don't know the type " + (Object)((Object)tag));
        }
        return tag.preText + typed;
    }

    public JsonTypeTags inheritMissingTags(JsonTypeTags parent) {
        String m = JsonTypeTags.firstNonEmpty(this.mod, parent.mod, "unknown");
        String sm = JsonTypeTags.firstNonEmpty(this.subMod, parent.subMod);
        String t = JsonTypeTags.firstNonEmpty(this.type, parent.type, "unknown");
        String st = JsonTypeTags.firstNonEmpty(this.subType, parent.subType, "unknown");
        return new JsonTypeTags(m, sm, t, st);
    }

    private static String firstNonEmpty(String ... strings) {
        String string;
        String current = null;
        String[] stringArray = strings;
        int n = stringArray.length;
        for (int i = 0; i < n && StringUtils.func_151246_b((String)(current = (string = stringArray[i]))); ++i) {
        }
        return current;
    }

    public void printContents(int indent) {
        StringBuilder f = new StringBuilder();
        while (indent > 0) {
            f.append("  ");
            --indent;
        }
        BCLog.logger.info(f + "mod = " + this.mod + ",");
        BCLog.logger.info(f + "sub_mod = " + this.subMod + ",");
        BCLog.logger.info(f + "type = " + this.type + ",");
        BCLog.logger.info(f + "sub_type = " + this.subType);
    }

    public Map<String, String> createMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("mod", this.mod);
        map.put("sub_mod", this.subMod);
        map.put("type", this.type);
        map.put("sub_type", this.subType);
        return map;
    }
}

