/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide;

import buildcraft.api.core.BCLog;
import buildcraft.lib.client.guide.data.JsonEntry;
import buildcraft.lib.client.guide.data.JsonTypeTags;
import buildcraft.lib.client.guide.loader.MarkdownPageLoader;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StringUtils;

public class PageEntry {
    public final String title;
    public final String page;
    public final JsonTypeTags typeTags;
    private final ItemStack stack;
    private final boolean containsMeta;
    private final boolean containsNbt;

    public PageEntry(JsonEntry entry) {
        this.title = entry.title;
        this.page = entry.page;
        this.typeTags = entry.typeTags;
        if (StringUtils.func_151246_b((String)entry.itemStack)) {
            this.stack = null;
            this.containsMeta = false;
            this.containsNbt = false;
        } else if (entry.itemStack.startsWith("(") && entry.itemStack.endsWith(")")) {
            String inner = entry.itemStack.substring(1, entry.itemStack.length() - 1);
            Item item = Item.func_111206_d((String)inner);
            if (item != null) {
                this.stack = new ItemStack(item);
            } else {
                BCLog.logger.warn("[lib.markdown] " + inner + " was not a valid item!");
                this.stack = null;
            }
            this.containsMeta = false;
            this.containsNbt = false;
        } else if (entry.itemStack.startsWith("{") && entry.itemStack.endsWith("}")) {
            String inner = entry.itemStack.substring(1, entry.itemStack.length() - 1);
            String[] split = inner.split(",");
            this.stack = MarkdownPageLoader.loadComplexItemStack(inner);
            this.containsMeta = split.length >= 3;
            this.containsNbt = split.length >= 4;
        } else {
            this.stack = null;
            this.containsMeta = false;
            this.containsNbt = false;
        }
    }

    public boolean stackMatches(ItemStack test) {
        if (this.stack == null || test == null) {
            return false;
        }
        if (this.stack.func_77973_b() != test.func_77973_b()) {
            return false;
        }
        if (this.containsMeta && this.stack.func_77960_j() != test.func_77960_j()) {
            return false;
        }
        return !this.containsNbt || ItemStack.func_77970_a((ItemStack)this.stack, (ItemStack)test);
    }

    public ItemStack getItemStack() {
        return this.stack == null ? null : this.stack.func_77946_l();
    }

    public String toString() {
        return "PageEntry [title=" + this.title + ", page=" + this.page + "]";
    }
}

