/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide;

import buildcraft.api.BCModules;
import buildcraft.api.core.BCDebugging;
import buildcraft.api.core.BCLog;
import buildcraft.lib.client.guide.PageEntry;
import buildcraft.lib.client.guide.data.JsonContents;
import buildcraft.lib.client.guide.data.JsonEntry;
import buildcraft.lib.client.guide.loader.IPageLoader;
import buildcraft.lib.client.guide.loader.MarkdownPageLoader;
import buildcraft.lib.client.guide.loader.XmlPageLoader;
import buildcraft.lib.client.guide.parts.GuidePageFactory;
import buildcraft.lib.client.guide.parts.GuidePageStandInRecipes;
import buildcraft.lib.misc.LocaleUtil;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.Language;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public enum GuideManager implements IResourceManagerReloadListener
{
    INSTANCE;

    public static final List<String> loadedDomains;
    public static final List<String> loadedMods;
    public static final List<String> loadedOther;
    private static final String DEFAULT_LANG = "en_us";
    private static final Map<String, IPageLoader> PAGE_LOADERS;
    private final List<PageEntry> entries = new ArrayList<PageEntry>();
    private final Map<String, GuidePageFactory> pages = new HashMap<String, GuidePageFactory>();
    private final Map<ItemStack, GuidePageFactory> generatedPages = new HashMap<ItemStack, GuidePageFactory>();
    public static final boolean DEBUG;

    public void func_110549_a(IResourceManager resourceManager) {
        String langCode;
        int maxModuleCount;
        Stopwatch watch = Stopwatch.createStarted();
        this.entries.clear();
        loadedDomains.clear();
        loadedMods.clear();
        loadedOther.clear();
        List<JsonEntry> loaded = GuideManager.loadAll(resourceManager);
        for (JsonEntry jsonEntry : loaded) {
            this.entries.add(new PageEntry(jsonEntry));
        }
        Collections.sort(loadedDomains);
        EnumSet<BCModules> modules = EnumSet.noneOf(BCModules.class);
        for (BCModules module : BCModules.VALUES) {
            if (!loadedDomains.remove(module.getModId())) continue;
            modules.add(module);
        }
        int n = modules.size();
        if (n == (maxModuleCount = BCModules.VALUES.length)) {
            loadedMods.add("BuildCraft (+Compat)");
        } else if (n == maxModuleCount - 1 && !modules.contains((Object)BCModules.COMPAT)) {
            loadedMods.add("BuildCraft");
        } else if (n > 2) {
            loadedMods.add("BuildCraft (\u00a7o" + (n - 2) + " modules\u00a7r)");
        } else if (n == 2) {
            loadedMods.add("BuildCraft (Core)");
        } else {
            loadedMods.add("BuildCraft (Lib)");
        }
        for (String domain : loadedDomains) {
            ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get(domain);
            if (mod != null) {
                loadedMods.add(mod.getName());
                continue;
            }
            loadedOther.add(LocaleUtil.localize(domain + ".compat.buildcraft.guide.domain_name"));
        }
        this.pages.clear();
        Language currentLanguage = Minecraft.func_71410_x().func_135016_M().func_135041_c();
        if (currentLanguage == null) {
            BCLog.logger.warn("Current language was null!");
            langCode = DEFAULT_LANG;
        } else {
            langCode = currentLanguage.func_135034_a();
        }
        this.loadLangInternal(resourceManager, DEFAULT_LANG);
        if (!DEFAULT_LANG.equals(langCode)) {
            this.loadLangInternal(resourceManager, langCode);
        }
        watch.stop();
        long time = watch.elapsed(TimeUnit.MILLISECONDS);
        int p = this.entries.size();
        int a = this.pages.size();
        int e = p - a;
        BCLog.logger.info("[lib.guide] Loaded " + p + " possible and " + a + " actual guide pages (" + e + " not found) in " + time + "ms.");
    }

    private static List<JsonEntry> loadAll(IResourceManager resourceManager) {
        ArrayList<JsonEntry> allEntries = new ArrayList<JsonEntry>();
        for (String domain : resourceManager.func_135055_a()) {
            JsonContents contents = GuideManager.loadContents(resourceManager, domain);
            if (contents == null) continue;
            loadedDomains.add(domain);
            contents = contents.inheritMissingTags();
            for (JsonEntry entry : contents.contents) {
                allEntries.add(entry);
            }
        }
        return allEntries;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JsonContents loadContents(IResourceManager resourceManager, String domain) {
        ResourceLocation location = new ResourceLocation(domain, "compat/buildcraft/guide/contents.json");
        try (InputStream is = resourceManager.func_110536_a(location).func_110527_b();){
            if (is != null) {
                InputStreamReader isr = new InputStreamReader(is);
                JsonContents jsonContents2 = (JsonContents)new Gson().fromJson((Reader)isr, JsonContents.class);
                return jsonContents2;
            }
            JsonContents jsonContents = null;
            return jsonContents;
        }
        catch (FileNotFoundException fnfe) {
            if (!DEBUG) return null;
            BCLog.logger.warn("[lib.guide.loader] Looks like there is no guide contents page for " + location + ", skipping.");
            return null;
        }
        catch (IOException io) {
            if (DEBUG) {
                BCLog.logger.warn("[lib.guide.loader] Failed to load the contents file for " + domain + "!", (Throwable)io);
                return null;
            }
            BCLog.logger.warn("[lib.guide.loader] Failed to load the contents file for " + domain + ": " + io.getMessage());
            return null;
        }
    }

    private void loadLangInternal(IResourceManager resourceManager, String lang) {
        for (PageEntry data : this.entries) {
            String page = data.page.replaceAll("<lang>", lang);
            String ending = page.substring(page.lastIndexOf(46) + 1);
            IPageLoader loader = PAGE_LOADERS.get(ending);
            if (loader == null) {
                BCLog.logger.warn("[lib.guide.loader] Unable to load guide page '" + page + "', as we don't know how to load it! (Known file type endings are " + PAGE_LOADERS.keySet() + ")");
                continue;
            }
            try {
                InputStream stream = resourceManager.func_110536_a(new ResourceLocation(page)).func_110527_b();
                Throwable throwable = null;
                try {
                    GuidePageFactory factory = loader.loadPage(stream, data);
                    this.pages.put(data.page, factory);
                    if (!DEBUG) continue;
                    BCLog.logger.info("[lib.guide.loader] Loaded page '" + page + "'.");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            catch (FileNotFoundException fnfe) {
                BCLog.logger.warn("[lib.guide.loader] Unable to load guide page '" + page + "' because we couldn't find it in any resource pack!");
            }
            catch (IOException io) {
                io.printStackTrace();
            }
        }
    }

    public ImmutableList<PageEntry> getAllEntries() {
        return ImmutableList.copyOf(this.entries);
    }

    public GuidePageFactory getFactoryFor(PageEntry entry) {
        return this.pages.get(entry.page);
    }

    public PageEntry getEntryFor(@Nonnull ItemStack stack) {
        for (PageEntry entry : this.entries) {
            if (!entry.stackMatches(stack)) continue;
            return entry;
        }
        return null;
    }

    @Nonnull
    public GuidePageFactory getPageFor(@Nonnull ItemStack stack) {
        GuidePageFactory factory;
        PageEntry entry = this.getEntryFor(stack);
        if (entry != null && (factory = this.getFactoryFor(entry)) != null) {
            return factory;
        }
        return this.generatedPages.computeIfAbsent(stack, GuidePageStandInRecipes::createFactory);
    }

    static {
        loadedDomains = new ArrayList<String>();
        loadedMods = new ArrayList<String>();
        loadedOther = new ArrayList<String>();
        PAGE_LOADERS = new HashMap<String, IPageLoader>();
        DEBUG = BCDebugging.shouldDebugLog("lib.guide.loader");
        PAGE_LOADERS.put("md", MarkdownPageLoader.INSTANCE);
        PAGE_LOADERS.put("xml", XmlPageLoader.INSTANCE);
    }
}

