/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.chunkload;

import buildcraft.api.core.BCLog;
import buildcraft.lib.BCLib;
import buildcraft.lib.BCLibConfig;
import buildcraft.lib.chunkload.IChunkLoadingTile;
import buildcraft.lib.misc.NBTUtilBC;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class ChunkLoaderManager {
    private static final Map<IChunkLoadingTile, ForgeChunkManager.Ticket> TICKETS = new WeakHashMap<IChunkLoadingTile, ForgeChunkManager.Ticket>();

    public static <T extends TileEntity> void loadChunksForTile(@Nonnull T tile) {
        if (TICKETS.containsKey(tile)) {
            ChunkLoaderManager.updateChunksFor(tile);
            return;
        }
        ForgeChunkManager.Ticket ticket = ForgeChunkManager.requestTicket((Object)BCLib.INSTANCE, (World)tile.func_145831_w(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (ticket == null) {
            BCLog.logger.warn("Chunkloading failed, most likely the limit was reached");
            return;
        }
        if (!ChunkLoaderManager.canLoadFor((IChunkLoadingTile)tile)) {
            return;
        }
        ticket.getModData().func_74782_a("location", (NBTBase)NBTUtilBC.writeBlockPos(tile.func_174877_v()));
        for (ChunkPos chunkPos : ChunkLoaderManager.getChunksToLoad(tile)) {
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)chunkPos);
        }
        TICKETS.put((IChunkLoadingTile)tile, ticket);
    }

    public static void releaseChunksFor(@Nonnull IChunkLoadingTile tile) {
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)TICKETS.get(tile));
        TICKETS.remove(tile);
    }

    public static <T extends TileEntity> void updateChunksFor(@Nonnull T tile) {
        if (!TICKETS.containsKey(tile)) {
            ChunkLoaderManager.loadChunksForTile(tile);
        }
        ForgeChunkManager.Ticket ticket = TICKETS.get(tile);
        Collection<ChunkPos> chunks = ChunkLoaderManager.getChunksToLoad(tile);
        for (ChunkPos pos : ticket.getChunkList()) {
            if (chunks.contains(pos)) continue;
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)pos);
        }
        for (ChunkPos pos : chunks) {
            if (ticket.getChunkList().contains((Object)pos)) continue;
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)pos);
        }
    }

    private static <T extends TileEntity> Collection<ChunkPos> getChunksToLoad(@Nonnull T tile) {
        ChunkPos pos;
        Collection<ChunkPos> chunks = ((IChunkLoadingTile)tile).getChunksToLoad();
        if (chunks == null) {
            chunks = new ArrayList<ChunkPos>();
        }
        if (!chunks.contains(pos = new ChunkPos(tile.func_174877_v()))) {
            chunks.add(pos);
        }
        return chunks;
    }

    public static <T extends TileEntity> void rebindTickets(List<ForgeChunkManager.Ticket> tickets, World world) {
        if (BCLibConfig.chunkLoadingLevel != BCLibConfig.ChunkLoaderLevel.NONE) {
            for (ForgeChunkManager.Ticket ticket : tickets) {
                TileEntity tile = world.func_175625_s(NBTUtilBC.readBlockPos(ticket.getModData().func_74781_a("location")));
                if (tile == null || !(tile instanceof IChunkLoadingTile) || !ChunkLoaderManager.canLoadFor((IChunkLoadingTile)tile)) continue;
                for (ChunkPos chunkPos : ChunkLoaderManager.getChunksToLoad(tile)) {
                    ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)chunkPos);
                }
                TICKETS.put((IChunkLoadingTile)tile, ticket);
            }
        }
    }

    private static boolean canLoadFor(@Nonnull IChunkLoadingTile tile) {
        return tile.getLoadType() != null && BCLibConfig.chunkLoadingLevel != BCLibConfig.ChunkLoaderLevel.NONE && (BCLibConfig.chunkLoadingLevel != BCLibConfig.ChunkLoaderLevel.STRICT_TILES || tile.getLoadType() != IChunkLoadingTile.LoadType.SOFT);
    }
}

