/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.block;

import buildcraft.api.blocks.ICustomRotationHandler;
import buildcraft.api.properties.BuildCraftProperties;
import buildcraft.lib.block.BlockBCTile_Neptune;
import buildcraft.lib.block.VanillaRotationHandlers;
import buildcraft.lib.misc.BlockUtil;
import buildcraft.lib.tile.TileMarker;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockMarkerBase
extends BlockBCTile_Neptune
implements ICustomRotationHandler {
    private static final Map<EnumFacing, AxisAlignedBB> BOUNDING_BOXES = new EnumMap<EnumFacing, AxisAlignedBB>(EnumFacing.class);

    public BlockMarkerBase(Material material, String id) {
        super(material, id);
        this.func_149711_c(0.25f);
        IBlockState defaultState = this.func_176223_P();
        defaultState = defaultState.func_177226_a(BuildCraftProperties.BLOCK_FACING_6, (Comparable)EnumFacing.UP);
        defaultState = defaultState.func_177226_a(BuildCraftProperties.ACTIVE, (Comparable)Boolean.valueOf(false));
        this.func_180632_j(defaultState);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BuildCraftProperties.BLOCK_FACING_6, BuildCraftProperties.ACTIVE});
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(BuildCraftProperties.BLOCK_FACING_6)).func_176745_a();
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(BuildCraftProperties.BLOCK_FACING_6, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = BlockUtil.getTileEntityForGetActualState(world, pos);
        if (tile instanceof TileMarker) {
            TileMarker marker = (TileMarker)tile;
            state = state.func_177226_a(BuildCraftProperties.ACTIVE, (Comparable)Boolean.valueOf(marker.isActiveForRender()));
        }
        return state;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return null;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOXES.get(state.func_177229_b(BuildCraftProperties.BLOCK_FACING_6));
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = this.func_176223_P();
        state = state.func_177226_a(BuildCraftProperties.BLOCK_FACING_6, (Comparable)facing);
        return state;
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return world.isSideSolid(pos.func_177972_a(side.func_176734_d()), side);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (state.func_177230_c() != this) {
            return;
        }
        EnumFacing sideOn = (EnumFacing)state.func_177229_b(BuildCraftProperties.BLOCK_FACING_6);
        if (!this.func_176198_a(world, pos, sideOn)) {
            world.func_175655_b(pos, true);
        }
    }

    @Override
    public EnumActionResult attemptRotation(World world, BlockPos pos, IBlockState state, EnumFacing sideWrenched) {
        if (state.func_177230_c() instanceof BlockMarkerBase) {
            IProperty<EnumFacing> prop = BuildCraftProperties.BLOCK_FACING_6;
            return VanillaRotationHandlers.rotateEnumFacing(world, pos, state, prop, VanillaRotationHandlers.ROTATE_FACING);
        }
        return EnumActionResult.PASS;
    }

    static {
        double halfWidth = 0.1;
        double h = 0.65;
        double nw = 0.5 - halfWidth;
        double pw = 0.5 + halfWidth;
        double ih = 1.0 - h;
        BOUNDING_BOXES.put(EnumFacing.DOWN, new AxisAlignedBB(nw, ih, nw, pw, 1.0, pw));
        BOUNDING_BOXES.put(EnumFacing.UP, new AxisAlignedBB(nw, 0.0, nw, pw, h, pw));
        BOUNDING_BOXES.put(EnumFacing.SOUTH, new AxisAlignedBB(nw, nw, 0.0, pw, pw, h));
        BOUNDING_BOXES.put(EnumFacing.NORTH, new AxisAlignedBB(nw, nw, ih, pw, pw, 1.0));
        BOUNDING_BOXES.put(EnumFacing.EAST, new AxisAlignedBB(0.0, nw, nw, h, pw, pw));
        BOUNDING_BOXES.put(EnumFacing.WEST, new AxisAlignedBB(ih, nw, nw, 1.0, pw, pw));
    }
}

