/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib;

import buildcraft.lib.BCLibConfig;
import buildcraft.lib.BCLibSprites;
import buildcraft.lib.block.BlockBCBase_Neptune;
import buildcraft.lib.client.guide.GuiGuide;
import buildcraft.lib.client.guide.GuideManager;
import buildcraft.lib.client.reload.LibConfigChangeListener;
import buildcraft.lib.client.render.DetachedRenderer;
import buildcraft.lib.client.render.MarkerRenderer;
import buildcraft.lib.debug.DebugRenderHelper;
import buildcraft.lib.fluid.BCFluid;
import buildcraft.lib.fluid.FluidManager;
import buildcraft.lib.item.IItemBuildCraft;
import buildcraft.lib.item.ItemManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BCLibProxy
implements IGuiHandler {
    @SidedProxy(modId="buildcraftlib")
    private static BCLibProxy proxy;

    public static BCLibProxy getProxy() {
        return proxy;
    }

    public void postRegisterItem(IItemBuildCraft item) {
    }

    public void postRegisterBlock(BlockBCBase_Neptune block) {
    }

    public void postRegisterFluid(BCFluid fluid) {
    }

    void fmlPreInit() {
    }

    void fmlInit() {
    }

    void fmlPostInit() {
    }

    public World getClientWorld() {
        return null;
    }

    public EntityPlayer getClientPlayer() {
        return null;
    }

    public EntityPlayer getPlayerForContext(MessageContext ctx) {
        return ctx.getServerHandler().field_147369_b;
    }

    public void addScheduledTask(World world, Runnable task) {
        if (world instanceof WorldServer) {
            WorldServer server = (WorldServer)world;
            server.func_152344_a(task);
        }
    }

    public <T extends TileEntity> T getServerTile(T tile) {
        return tile;
    }

    public InputStream getStreamForIdentifier(ResourceLocation identifier) throws IOException {
        return null;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    @SideOnly(value=Side.SERVER)
    public static class ServerProxy
    extends BCLibProxy {
    }

    @SideOnly(value=Side.CLIENT)
    public static class ClientProxy
    extends BCLibProxy {
        @Override
        public void postRegisterItem(IItemBuildCraft item) {
            item.postRegisterClient();
        }

        @Override
        public void postRegisterFluid(BCFluid fluid) {
            FluidManager.postRegisterFluid(fluid);
        }

        @Override
        void fmlPreInit() {
            super.fmlPreInit();
            DetachedRenderer.INSTANCE.addRenderer(DetachedRenderer.RenderMatrixType.FROM_WORLD_ORIGIN, MarkerRenderer.INSTANCE);
            DetachedRenderer.INSTANCE.addRenderer(DetachedRenderer.RenderMatrixType.FROM_WORLD_ORIGIN, DebugRenderHelper.INSTANCE);
            BCLibSprites.fmlPreInitClient();
            BCLibConfig.configChangeListeners.add(LibConfigChangeListener.INSTANCE);
        }

        @Override
        void fmlInit() {
            super.fmlInit();
            IResourceManager manager = Minecraft.func_71410_x().func_110442_L();
            IReloadableResourceManager reloadable = (IReloadableResourceManager)manager;
            reloadable.func_110542_a((IResourceManagerReloadListener)GuideManager.INSTANCE);
            ItemManager.fmlInitClient();
        }

        @Override
        void fmlPostInit() {
            super.fmlPostInit();
        }

        @Override
        public World getClientWorld() {
            return Minecraft.func_71410_x().field_71441_e;
        }

        @Override
        public EntityPlayer getClientPlayer() {
            return Minecraft.func_71410_x().field_71439_g;
        }

        @Override
        public EntityPlayer getPlayerForContext(MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                return super.getPlayerForContext(ctx);
            }
            return this.getClientPlayer();
        }

        @Override
        public void addScheduledTask(World world, Runnable task) {
            if (world instanceof WorldClient) {
                Minecraft.func_71410_x().func_152344_a(task);
            } else {
                super.addScheduledTask(world, task);
            }
        }

        @Override
        public <T extends TileEntity> T getServerTile(T tile) {
            if (tile != null && tile.func_145830_o()) {
                World world = tile.func_145831_w();
                if (world.field_72995_K && Minecraft.func_71410_x().func_71356_B()) {
                    WorldServer server = DimensionManager.getWorld((int)world.field_73011_w.getDimension());
                    if (server == null) {
                        return tile;
                    }
                    TileEntity atServer = server.func_175625_s(tile.func_174877_v());
                    if (atServer == null) {
                        return tile;
                    }
                    if (atServer.getClass() == tile.getClass()) {
                        return (T)atServer;
                    }
                }
            }
            return tile;
        }

        @Override
        public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
            if (id == 0) {
                return new GuiGuide();
            }
            return null;
        }

        @Override
        public InputStream getStreamForIdentifier(ResourceLocation identifier) throws IOException {
            IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(identifier);
            if (resource == null) {
                throw new FileNotFoundException(identifier.toString());
            }
            return resource.func_110527_b();
        }
    }
}

