/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib;

import buildcraft.lib.BCLib;
import buildcraft.lib.client.model.ModelHolderRegistry;
import buildcraft.lib.client.reload.ReloadManager;
import buildcraft.lib.client.render.DetachedRenderer;
import buildcraft.lib.client.render.fluid.FluidRenderer;
import buildcraft.lib.client.render.laser.LaserRenderer_BC8;
import buildcraft.lib.client.sprite.SpriteHolderRegistry;
import buildcraft.lib.debug.BCAdvDebugging;
import buildcraft.lib.marker.MarkerCache;
import buildcraft.lib.misc.FakePlayerProvider;
import buildcraft.lib.misc.MessageUtil;
import buildcraft.lib.misc.data.ModelVariableData;
import buildcraft.lib.net.cache.BuildCraftObjectCaches;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum BCLibEventDist {
    INSTANCE;


    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)entity;
            MessageUtil.doDelayed(() -> MarkerCache.onPlayerJoinWorld(playerMP));
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        MarkerCache.onWorldUnload(event.getWorld());
        if (event.getWorld() instanceof WorldServer) {
            FakePlayerProvider.INSTANCE.unloadWorld((WorldServer)event.getWorld());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onConnectToServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        BuildCraftObjectCaches.onClientJoinServer();
        if (!BCLib.DEV) {
            Runnable r = () -> {
                String ver;
                try {
                    Thread.sleep(4000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if ("7.99.7".startsWith("${")) {
                    ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get("buildcraftlib");
                    if (mod == null) {
                        ver = "[UNKNOWN-MANUAL-BUILD]";
                    } else {
                        ver = mod.getDisplayVersion();
                        if (ver.startsWith("${")) {
                            ver = "[UNKNOWN_MANUAL_BUILD]";
                        }
                    }
                } else {
                    ver = "7.99.7";
                }
                TextComponentString componentVersion = new TextComponentString(ver);
                Style styleVersion = new Style();
                styleVersion.func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "7.99.7"));
                componentVersion.func_150255_a(styleVersion);
                String githubIssuesUrl = "https://github.com/BuildCraft/BuildCraft/issues";
                TextComponentString componentGithubLink = new TextComponentString("here");
                Style styleGithubLink = new Style();
                styleGithubLink.func_150228_d(Boolean.TRUE);
                styleGithubLink.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, githubIssuesUrl));
                componentGithubLink.func_150255_a(styleGithubLink);
                TextComponentString textWarn = new TextComponentString("WARNING: BuildCraft ");
                textWarn.func_150257_a((ITextComponent)componentVersion);
                textWarn.func_150258_a(" is in ALPHA!");
                TextComponentString textReport = new TextComponentString("  Report bugs you find ");
                textReport.func_150257_a((ITextComponent)componentGithubLink);
                TextComponentString textDesc = new TextComponentString("  and include the version ");
                textDesc.func_150257_a((ITextComponent)componentVersion);
                textDesc.func_150258_a(" in the description");
                ITextComponent[] lines = new ITextComponent[]{textWarn, textReport, textDesc};
                GuiNewChat chat = Minecraft.func_71410_x().field_71456_v.func_146158_b();
                for (ITextComponent line : lines) {
                    chat.func_146227_a(line);
                }
            };
            new Thread(r).start();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void textureStitchPre(TextureStitchEvent.Pre event) {
        ReloadManager.INSTANCE.preReloadResources();
        TextureMap map = event.getMap();
        SpriteHolderRegistry.onTextureStitchPre(map);
        ModelHolderRegistry.onTextureStitchPre(map);
        FluidRenderer.onTextureStitchPre(map);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void textureStitchPost(TextureStitchEvent.Post event) {
        TextureMap map = event.getMap();
        SpriteHolderRegistry.onTextureStitchPost();
        FluidRenderer.onTextureStitchPost(map);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void modelBake(ModelBakeEvent event) {
        SpriteHolderRegistry.exportTextureMap();
        LaserRenderer_BC8.clearModels();
        ModelHolderRegistry.onModelBake();
        ModelVariableData.onModelBake();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void renderWorldLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        float partialTicks = event.getPartialTicks();
        DetachedRenderer.INSTANCE.renderWorldLastEvent((EntityPlayer)player, partialTicks);
    }

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            BCAdvDebugging.INSTANCE.onServerPostTick();
            MessageUtil.postTick();
        }
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            BuildCraftObjectCaches.onClientTick();
            MessageUtil.postTick();
        }
    }
}

