/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib;

import buildcraft.api.BCModules;
import buildcraft.api.core.BCLog;
import buildcraft.lib.BCLibEventDist;
import buildcraft.lib.BCLibItems;
import buildcraft.lib.BCLibProxy;
import buildcraft.lib.BCLibRecipes;
import buildcraft.lib.BCLibRegistries;
import buildcraft.lib.block.VanillaPaintHandlers;
import buildcraft.lib.block.VanillaRotationHandlers;
import buildcraft.lib.chunkload.ChunkLoaderManager;
import buildcraft.lib.expression.ExpressionDebugManager;
import buildcraft.lib.item.ItemManager;
import buildcraft.lib.list.VanillaListHandlers;
import buildcraft.lib.marker.MarkerCache;
import buildcraft.lib.net.MessageContainer;
import buildcraft.lib.net.MessageManager;
import buildcraft.lib.net.MessageMarker;
import buildcraft.lib.net.MessageUpdateTile;
import buildcraft.lib.net.cache.BuildCraftObjectCaches;
import buildcraft.lib.net.cache.MessageObjectCacheReply;
import buildcraft.lib.net.cache.MessageObjectCacheReq;
import buildcraft.lib.particle.MessageParticleVanilla;
import buildcraft.lib.registry.MigrationManager;
import buildcraft.lib.registry.TagManager;
import java.util.function.Consumer;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;

@Mod(modid="buildcraftlib", name="BuildCraft Lib", version="7.99.7", acceptedMinecraftVersions="[1.11.2]", dependencies="required-after:forge@[13.20.1.2386,)")
public class BCLib {
    public static final String MODID = "buildcraftlib";
    public static final String VERSION = "7.99.7";
    public static final String MC_VERSION = "1.11.2";
    public static final String GIT_COMMIT_HASH = "${git_commit_hash}";
    public static final String GIT_BRANCH = "${git_branch}";
    public static final boolean DEV = "7.99.7".startsWith("$") || Boolean.getBoolean("buildcraft.dev");
    @Mod.Instance(value="buildcraftlib")
    public static BCLib INSTANCE;

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent evt) {
        BCLog.logger.info("");
        BCLog.logger.info("Starting BuildCraft 7.99.7");
        BCLog.logger.info("Copyright (c) the BuildCraft team, 2011-2017");
        BCLog.logger.info("http://www.mod-buildcraft.com");
        BCLog.logger.info("");
        ExpressionDebugManager.logger = arg_0 -> ((Logger)BCLog.logger).info(arg_0);
        BCModules.fmlPreInit();
        BCLibRegistries.fmlPreInit();
        BCLibProxy.getProxy().fmlPreInit();
        BCLibItems.fmlPreInit();
        BuildCraftObjectCaches.fmlPreInit();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)INSTANCE, (IGuiHandler)BCLibProxy.getProxy());
        MessageManager.addMessageType(MessageUpdateTile.class, MessageUpdateTile.HANDLER, Side.CLIENT, Side.SERVER);
        MessageManager.addMessageType(MessageContainer.class, MessageContainer.HANDLER, Side.CLIENT, Side.SERVER);
        MessageManager.addMessageType(MessageMarker.class, MessageMarker.HANDLER, Side.CLIENT);
        MessageManager.addMessageType(MessageParticleVanilla.class, MessageParticleVanilla.HANDLER, Side.CLIENT);
        MessageManager.addMessageType(MessageObjectCacheReq.class, MessageObjectCacheReq.HANDLER, Side.SERVER);
        MessageManager.addMessageType(MessageObjectCacheReply.class, MessageObjectCacheReply.HANDLER, Side.CLIENT);
        MinecraftForge.EVENT_BUS.register(BCLibEventDist.class);
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)INSTANCE, ChunkLoaderManager::rebindTickets);
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent evt) {
        BCLibProxy.getProxy().fmlInit();
        BCLibRegistries.fmlInit();
        VanillaListHandlers.fmlInit();
        VanillaPaintHandlers.fmlInit();
        VanillaRotationHandlers.fmlInit();
        ItemManager.fmlInit();
        BCLibRecipes.fmlInit();
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent evt) {
        BCLibProxy.getProxy().fmlPostInit();
        BuildCraftObjectCaches.fmlPostInit();
        MessageManager.fmlPostInit();
        VanillaListHandlers.fmlPostInit();
        MarkerCache.postInit();
    }

    @Mod.EventHandler
    public static void missingMappings(FMLMissingMappingsEvent evt) {
        MigrationManager.INSTANCE.missingMappingEvent(evt);
    }

    private static TagManager.TagEntry registerTag(String id) {
        return TagManager.registerTag(id);
    }

    private static void startBatch() {
        TagManager.startBatch();
    }

    private static void endBatch(Consumer<TagManager.TagEntry> consumer) {
        TagManager.endBatch(consumer);
    }

    static {
        BCLib.startBatch();
        BCLib.registerTag("item.guide").reg("guide").locale("guide").model("guide").tab("vanilla.misc");
        BCLib.registerTag("item.guide.note").reg("guide_note").locale("guide_note").model("guide_note").tab("vanilla.misc");
        BCLib.registerTag("item.debugger").reg("debugger").locale("debugger").model("debugger").tab("vanilla.misc");
        BCLib.endBatch(TagManager.prependTags("buildcraftlib:", TagManager.EnumTagType.REGISTRY_NAME, TagManager.EnumTagType.MODEL_LOCATION));
    }
}

