/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.util;

import buildcraft.factory.util.WorkbenchCrafting;
import buildcraft.lib.misc.CraftingUtil;
import buildcraft.lib.misc.InventoryUtil;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.tile.item.ItemHandlerSimple;
import java.util.List;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface IAutoCraft {
    public ItemHandlerSimple getInvBlueprint();

    public ItemHandlerSimple getInvMaterials();

    public ItemHandlerSimple getInvResult();

    public WorkbenchCrafting getWorkbenchCrafting();

    public IRecipe getCurrentRecipe();

    public void setCurrentRecipe(IRecipe var1);

    default public void updateRecipe() {
        ItemStack old = this.getOutput();
        IRecipe newRecipe = CraftingUtil.findMatchingRecipe(this.getWorkbenchCrafting(), this.getWorldForAutoCrafting());
        this.setCurrentRecipe(newRecipe);
        if (newRecipe == null || StackUtil.canMerge(old, this.getOutput())) {
            this.setRequirements(null);
        }
        if (this.getRequirements() == null && this.getCurrentRecipe() != null) {
            this.setRequirements(StackUtil.mergeSameItems(this.getInvBlueprint().stacks));
        }
    }

    public World getWorldForAutoCrafting();

    public BlockPos getPosForAutoCrafting();

    public void setRequirements(List<ItemStack> var1);

    public List<ItemStack> getRequirements();

    default public void craft() {
        ItemStack out = this.getCurrentRecipe().func_77572_b((InventoryCrafting)this.getWorkbenchCrafting());
        InventoryUtil.drop(this.getWorldForAutoCrafting(), this.getPosForAutoCrafting(), this.insertInInventory(this.getInvResult(), out));
        for (ItemStack stack : this.getCurrentRecipe().func_179532_b((InventoryCrafting)this.getWorkbenchCrafting())) {
            InventoryUtil.addToBestAcceptor(this.getWorldForAutoCrafting(), this.getPosForAutoCrafting(), null, stack);
        }
        block1: for (ItemStack input : this.getRequirements()) {
            ItemStack toExtract = input.func_77946_l();
            for (int i = 0; i < this.getInvMaterials().getSlots(); ++i) {
                if (!StackUtil.canMerge(toExtract, this.getInvMaterials().getStackInSlot(i))) continue;
                ItemStack extracted = this.getInvMaterials().extractItem(i, toExtract.func_190916_E(), false);
                if (extracted.func_190916_E() == toExtract.func_190916_E()) continue block1;
                toExtract.func_190920_e(toExtract.func_190916_E() - extracted.func_190916_E());
            }
        }
    }

    default public ItemStack insertInInventory(ItemHandlerSimple handler, ItemStack stack) {
        ItemStack leftOver = stack;
        for (int i = 0; i < handler.getSlots() && !(leftOver = handler.insertItem(i, leftOver, false)).func_190926_b(); ++i) {
        }
        return leftOver;
    }

    default public boolean hasMaterials() {
        return this.getCurrentRecipe() != null && this.getCurrentRecipe().func_77569_a((InventoryCrafting)this.getWorkbenchCrafting(), this.getWorldForAutoCrafting()) && this.getRequirements() != null && StackUtil.containsAll(this.getRequirements(), StackUtil.mergeSameItems(this.getInvMaterials().stacks));
    }

    default public boolean canWork() {
        return this.getCurrentRecipe() != null && this.hasMaterials() && this.getInvResult().insert(this.getOutput(), true, true).func_190926_b();
    }

    default public ItemStack getOutput() {
        return this.getCurrentRecipe() == null ? ItemStack.field_190927_a : this.getCurrentRecipe().func_77572_b((InventoryCrafting)this.getWorkbenchCrafting());
    }
}

