/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.tile;

import buildcraft.api.core.BCLog;
import buildcraft.api.core.EnumPipePart;
import buildcraft.api.mj.IMjReceiver;
import buildcraft.core.BCCoreBlocks;
import buildcraft.energy.BCEnergyFluids;
import buildcraft.energy.tile.TileSpringOil;
import buildcraft.factory.BCFactoryBlocks;
import buildcraft.factory.tile.TileMiner;
import buildcraft.lib.fluid.Tank;
import buildcraft.lib.misc.BlockUtil;
import buildcraft.lib.misc.CapUtil;
import buildcraft.lib.misc.FluidUtilBC;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.VecUtil;
import buildcraft.lib.mj.MjRedstoneBatteryReceiver;
import buildcraft.lib.net.PacketBufferBC;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MinMaxPriorityQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class TilePump
extends TileMiner {
    private final Tank tank = new Tank("tank", 16000, this);
    private boolean queueBuilt = false;
    private final Map<BlockPos, List<BlockPos>> paths = new HashMap<BlockPos, List<BlockPos>>();
    private BlockPos fluidConnection;
    private final MinMaxPriorityQueue<BlockPos> queue = MinMaxPriorityQueue.orderedBy(BlockUtil.uniqueBlockPosComparator(Comparator.comparing(blockPos -> this.paths.get(blockPos).size()))).create();
    private Fluid queueFluid;
    @Nullable
    private BlockPos oilSpringPos;

    public TilePump() {
        this.tank.setCanFill(false);
        this.tankManager.add(this.tank);
        this.caps.addCapabilityInstance(CapUtil.CAP_FLUIDS, this.tank, EnumPipePart.VALUES);
    }

    @Override
    protected IMjReceiver createMjReceiver() {
        return new MjRedstoneBatteryReceiver(this.battery);
    }

    private void buildQueue() {
        this.field_145850_b.field_72984_F.func_76320_a("prepare");
        this.queue.clear();
        this.paths.clear();
        this.queueFluid = null;
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        ArrayList<BlockPos> nextPosesToCheck = new ArrayList<BlockPos>();
        BlockPos posToCheck = this.field_174879_c.func_177977_b();
        while (posToCheck.func_177956_o() > 0) {
            if (BlockUtil.getFluidWithFlowing(this.field_145850_b, posToCheck) != null) {
                this.queueFluid = BlockUtil.getFluidWithFlowing(this.field_145850_b, posToCheck);
                nextPosesToCheck.add(posToCheck);
                this.paths.put(posToCheck, Collections.singletonList(posToCheck));
                checked.add(posToCheck);
                if (BlockUtil.getFluid(this.field_145850_b, posToCheck) != null) {
                    this.queue.add((Object)posToCheck);
                }
                this.fluidConnection = posToCheck;
                break;
            }
            if (!this.field_145850_b.func_175623_d(posToCheck) && this.field_145850_b.func_180495_p(posToCheck).func_177230_c() != BCFactoryBlocks.tube) break;
            posToCheck = posToCheck.func_177977_b();
        }
        if (nextPosesToCheck.isEmpty()) {
            this.field_145850_b.field_72984_F.func_76319_b();
            return;
        }
        this.field_145850_b.field_72984_F.func_76318_c("build");
        while (!nextPosesToCheck.isEmpty()) {
            ArrayList nextPosesToCheckCopy = new ArrayList(nextPosesToCheck);
            nextPosesToCheck.clear();
            for (BlockPos posToCheck2 : nextPosesToCheckCopy) {
                for (EnumFacing side : new EnumFacing[]{EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST}) {
                    BlockPos offsetPos = posToCheck2.func_177972_a(side);
                    if ((offsetPos.func_177958_n() - this.field_174879_c.func_177958_n()) * (offsetPos.func_177958_n() - this.field_174879_c.func_177958_n()) + (offsetPos.func_177952_p() - this.field_174879_c.func_177952_p()) * (offsetPos.func_177952_p() - this.field_174879_c.func_177952_p()) > 4096 || !checked.add(offsetPos) || !FluidUtilBC.areFluidsEqual(BlockUtil.getFluidWithFlowing(this.field_145850_b, offsetPos), this.queueFluid)) continue;
                    ImmutableList.Builder pathBuilder = new ImmutableList.Builder();
                    pathBuilder.addAll((Iterable)this.paths.get(posToCheck2));
                    pathBuilder.add((Object)offsetPos);
                    this.paths.put(offsetPos, (List<BlockPos>)pathBuilder.build());
                    if (BlockUtil.getFluid(this.field_145850_b, offsetPos) != null) {
                        this.queue.add((Object)offsetPos);
                    }
                    nextPosesToCheck.add(offsetPos);
                }
            }
        }
        this.field_145850_b.field_72984_F.func_76318_c("oil_spring_search");
        if (FluidUtilBC.areFluidsEqual(this.queueFluid, BCEnergyFluids.crudeOil[0])) {
            ArrayList<BlockPos> springPositions = new ArrayList<BlockPos>();
            BlockPos center = VecUtil.replaceValue((Vec3i)this.func_174877_v(), EnumFacing.Axis.Y, 0);
            for (BlockPos spring : BlockPos.func_177980_a((BlockPos)center.func_177982_a(-10, 0, -10), (BlockPos)center.func_177982_a(10, 0, 10))) {
                if (this.field_145850_b.func_180495_p(spring).func_177230_c() != BCCoreBlocks.spring) continue;
                BCLog.logger.info("Found block at " + spring);
                TileEntity tile = this.field_145850_b.func_175625_s(spring);
                if (!(tile instanceof TileSpringOil)) continue;
                springPositions.add(spring);
                BCLog.logger.info("Found a spring tile at " + spring);
            }
            switch (springPositions.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    this.oilSpringPos = (BlockPos)springPositions.get(0);
                    break;
                }
                default: {
                    springPositions.sort(Comparator.comparingDouble(arg_0 -> ((BlockPos)this.field_174879_c).func_177951_i(arg_0)));
                    this.oilSpringPos = (BlockPos)springPositions.get(0);
                }
            }
        }
        this.field_145850_b.field_72984_F.func_76319_b();
    }

    private boolean canDrain(BlockPos blockPos) {
        Fluid fluid = BlockUtil.getFluid(this.field_145850_b, blockPos);
        return this.tank.isEmpty() ? fluid != null : FluidUtilBC.areFluidsEqual(fluid, this.tank.getFluidType());
    }

    private void nextPos() {
        while (!this.queue.isEmpty()) {
            BlockPos blockPos = this.currentPos = this.queueFluid == null || !FluidUtilBC.areFluidsEqual(this.queueFluid, FluidRegistry.WATER) ? (BlockPos)this.queue.pollLast() : (BlockPos)this.queue.pollFirst();
            if (!this.canDrain(this.currentPos)) continue;
            this.updateLength();
            return;
        }
        this.currentPos = null;
        this.updateLength();
    }

    @Override
    protected BlockPos getTargetPos() {
        if (this.currentPos != null && this.fluidConnection != null) {
            return this.currentPos.func_177956_o() > this.fluidConnection.func_177956_o() ? this.fluidConnection : this.currentPos;
        }
        return this.currentPos;
    }

    @Override
    protected void initCurrentPos() {
        if (this.currentPos == null) {
            this.nextPos();
        }
    }

    @Override
    public void func_73660_a() {
        if (!this.queueBuilt && !this.field_145850_b.field_72995_K) {
            this.buildQueue();
            this.queueBuilt = true;
        }
        super.func_73660_a();
        FluidUtilBC.pushFluidAround((IBlockAccess)this.field_145850_b, this.field_174879_c, this.tank);
    }

    @Override
    public void mine() {
        boolean prevResult = true;
        while (prevResult) {
            block5: {
                block8: {
                    block6: {
                        TileEntity tile;
                        FluidStack drain;
                        block7: {
                            prevResult = false;
                            if (this.tank.isFull()) {
                                return;
                            }
                            long target = 10000000L;
                            if (this.currentPos == null || !this.paths.containsKey(this.currentPos)) break block5;
                            this.progress = (int)((long)this.progress + this.battery.extractPower(0L, target - (long)this.progress));
                            if ((long)this.progress < target) continue;
                            drain = BlockUtil.drainBlock(this.field_145850_b, this.currentPos, false);
                            if (drain == null || !this.paths.get(this.currentPos).stream().allMatch(blockPos -> BlockUtil.getFluidWithFlowing(this.field_145850_b, blockPos) != null) || !this.canDrain(this.currentPos)) break block6;
                            this.tank.fillInternal(drain, true);
                            this.progress = 0;
                            if (drain.getFluid() != FluidRegistry.WATER) break block7;
                            if (Arrays.stream(EnumFacing.field_176754_o).map(arg_0 -> ((BlockPos)this.currentPos).func_177972_a(arg_0)).map(p -> BlockUtil.getFluid(this.field_145850_b, p)).filter(f -> FluidUtilBC.areFluidsEqual(f, FluidRegistry.WATER)).count() >= 2L) break block8;
                        }
                        BlockUtil.drainBlock(this.field_145850_b, this.currentPos, true);
                        if (FluidUtilBC.areFluidsEqual(drain.getFluid(), BCEnergyFluids.crudeOil[0]) && this.oilSpringPos != null && (tile = this.field_145850_b.func_175625_s(this.oilSpringPos)) instanceof TileSpringOil) {
                            ((TileSpringOil)tile).onPumpOil(this, this.currentPos);
                        }
                        this.nextPos();
                        break block8;
                    }
                    this.buildQueue();
                    this.nextPos();
                }
                prevResult = true;
                continue;
            }
            this.buildQueue();
            this.nextPos();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.oilSpringPos = NBTUtilBC.readBlockPos(nbt.func_74781_a("oilSpringPos"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.oilSpringPos != null) {
            nbt.func_74782_a("oilSpringPos", (NBTBase)NBTUtilBC.writeBlockPos(this.oilSpringPos));
        }
        return nbt;
    }

    @Override
    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (side == Side.SERVER) {
            if (id == NET_RENDER_DATA) {
                this.writePayload(NET_LED_STATUS, buffer, side);
            } else if (id == NET_LED_STATUS) {
                this.tank.writeToBuffer(buffer);
            }
        }
    }

    @Override
    public void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(id, buffer, side, ctx);
        if (side == Side.CLIENT) {
            if (id == NET_RENDER_DATA) {
                this.readPayload(NET_LED_STATUS, buffer, side, ctx);
            } else if (id == NET_LED_STATUS) {
                this.tank.readFromBuffer(buffer);
            }
        }
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        super.getDebugInfo(left, right, side);
        left.add("fluid = " + this.tank.getDebugString());
        left.add("queue size = " + this.queue.size());
    }

    @Override
    protected long getBatteryCapacity() {
        return 50000000L;
    }
}

