/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.tile;

import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.core.EnumPipePart;
import buildcraft.api.mj.IMjReceiver;
import buildcraft.factory.BCFactoryBlocks;
import buildcraft.factory.tile.TileMiner;
import buildcraft.lib.inventory.AutomaticProvidingTransactor;
import buildcraft.lib.misc.BlockUtil;
import buildcraft.lib.misc.CapUtil;
import buildcraft.lib.misc.InventoryUtil;
import buildcraft.lib.mj.MjBatteryReceiver;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileMiningWell
extends TileMiner {
    public TileMiningWell() {
        this.caps.addCapabilityInstance(CapUtil.CAP_ITEM_TRANSACTOR, AutomaticProvidingTransactor.INSTANCE, EnumPipePart.VALUES);
    }

    @Override
    protected void mine() {
        if (this.currentPos != null && this.canBreak()) {
            long target = BlockUtil.computeBlockBreakPower(this.field_145850_b, this.currentPos);
            this.progress = (int)((long)this.progress + this.battery.extractPower(0L, target - (long)this.progress));
            if ((long)this.progress >= target) {
                this.progress = 0;
                FakePlayer fakePlayer = BuildCraftAPI.fakePlayerProvider.getFakePlayer((WorldServer)this.field_145850_b, this.getOwner(), this.field_174879_c);
                BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(this.field_145850_b, this.currentPos, this.field_145850_b.func_180495_p(this.currentPos), (EntityPlayer)fakePlayer);
                MinecraftForge.EVENT_BUS.post((Event)breakEvent);
                if (!breakEvent.isCanceled()) {
                    NonNullList<ItemStack> stacks = BlockUtil.getItemStackFromBlock((WorldServer)this.field_145850_b, this.currentPos, this.getOwner());
                    if (stacks != null) {
                        for (ItemStack stack : stacks) {
                            InventoryUtil.addToBestAcceptor(this.field_145850_b, this.field_174879_c, null, stack);
                        }
                    }
                    this.field_145850_b.func_175715_c(this.currentPos.hashCode(), this.currentPos, -1);
                    this.field_145850_b.func_175655_b(this.currentPos, false);
                }
                this.nextPos();
                this.updateLength();
            } else if (!this.field_145850_b.func_175623_d(this.currentPos)) {
                this.field_145850_b.func_175715_c(this.currentPos.hashCode(), this.currentPos, (int)((long)(this.progress * 9) / target));
            }
        } else {
            this.nextPos();
            this.updateLength();
        }
    }

    private boolean canBreak() {
        return !this.field_145850_b.func_175623_d(this.currentPos) && !BlockUtil.isUnbreakableBlock(this.field_145850_b, this.currentPos, this.getOwner());
    }

    private void nextPos() {
        this.currentPos = this.field_174879_c.func_177977_b();
        while (this.currentPos.func_177956_o() >= 0) {
            if (this.canBreak()) {
                this.updateLength();
                return;
            }
            if (!this.field_145850_b.func_175623_d(this.currentPos) && this.field_145850_b.func_180495_p(this.currentPos).func_177230_c() != BCFactoryBlocks.tube) break;
            this.currentPos = this.currentPos.func_177977_b();
        }
        this.updateLength();
        this.currentPos = null;
    }

    @Override
    protected void initCurrentPos() {
        if (this.currentPos == null) {
            this.nextPos();
        }
    }

    @Override
    public void func_145843_s() {
        if (this.currentPos != null) {
            this.field_145850_b.func_175715_c(this.currentPos.hashCode(), this.currentPos, -1);
        }
        super.func_145843_s();
    }

    @Override
    protected IMjReceiver createMjReceiver() {
        return new MjBatteryReceiver(this.battery);
    }
}

