/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.tile;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.mj.IMjReceiver;
import buildcraft.api.mj.MjBattery;
import buildcraft.api.mj.MjCapabilityHelper;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.api.tiles.TilesAPI;
import buildcraft.factory.BCFactoryBlocks;
import buildcraft.lib.migrate.BCVersion;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.data.IdAllocator;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.tile.TileBC_Neptune;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileMiner
extends TileBC_Neptune
implements ITickable,
IDebuggable {
    public static final IdAllocator IDS = TileBC_Neptune.IDS.makeChild("miner");
    public static final int NET_LED_STATUS = IDS.allocId("LED_STATUS");
    public static final int NET_WANTED_Y = IDS.allocId("WANTED_Y");
    protected int progress = 0;
    protected BlockPos currentPos = null;
    private int wantedLength = 0;
    private double currentLength = 0.0;
    private double lastLength = 0.0;
    private int offset;
    protected boolean isComplete = false;
    protected final MjBattery battery = new MjBattery(this.getBatteryCapacity());

    public TileMiner() {
        this.caps.addProvider(new MjCapabilityHelper(this.createMjReceiver()));
        this.caps.addCapabilityInstance(TilesAPI.CAP_HAS_WORK, () -> !this.isComplete, EnumPipePart.VALUES);
    }

    protected abstract void initCurrentPos();

    protected abstract void mine();

    protected abstract IMjReceiver createMjReceiver();

    @Override
    public IdAllocator getIdAllocator() {
        return IDS;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.lastLength = this.currentLength;
            this.currentLength = Math.abs((double)this.wantedLength - this.currentLength) <= 0.01 ? (double)this.wantedLength : (this.currentLength += ((double)this.wantedLength - this.currentLength) / 7.0);
            return;
        }
        this.battery.tick(this.func_145831_w(), this.func_174877_v());
        if (this.field_145850_b.func_82737_E() % 10L == (long)this.offset) {
            this.sendNetworkUpdate(NET_LED_STATUS);
        }
        this.initCurrentPos();
        this.mine();
    }

    public void onLoad() {
        super.onLoad();
        this.offset = this.field_145850_b.field_73012_v.nextInt(10);
    }

    public void func_145843_s() {
        BlockPos blockPos;
        super.func_145843_s();
        for (int y = this.field_174879_c.func_177956_o() - 1; y > 0 && this.field_145850_b.func_180495_p(blockPos = new BlockPos(this.field_174879_c.func_177958_n(), y, this.field_174879_c.func_177952_p())).func_177230_c() == BCFactoryBlocks.tube; --y) {
            this.field_145850_b.func_175698_g(blockPos);
        }
    }

    protected void updateLength() {
        int newY = this.getTargetPos() != null ? this.getTargetPos().func_177956_o() : this.field_174879_c.func_177956_o();
        int newLength = this.field_174879_c.func_177956_o() - newY;
        if (newLength != this.wantedLength) {
            BlockPos blockPos;
            int y;
            for (y = this.field_174879_c.func_177956_o() - 1; y > 0 && this.field_145850_b.func_180495_p(blockPos = new BlockPos(this.field_174879_c.func_177958_n(), y, this.field_174879_c.func_177952_p())).func_177230_c() == BCFactoryBlocks.tube; --y) {
                this.field_145850_b.func_175698_g(blockPos);
            }
            for (y = this.field_174879_c.func_177956_o() - 1; y > newY; --y) {
                blockPos = new BlockPos(this.field_174879_c.func_177958_n(), y, this.field_174879_c.func_177952_p());
                this.field_145850_b.func_175656_a(blockPos, BCFactoryBlocks.tube.func_176223_P());
            }
            if (this.wantedLength == 0) {
                this.sendNetworkUpdate(NET_RENDER_DATA);
            }
            this.wantedLength = newLength;
            this.currentLength = this.wantedLength;
            this.sendNetworkUpdate(NET_WANTED_Y);
        }
    }

    protected BlockPos getTargetPos() {
        return this.currentPos;
    }

    public double getLength(float partialTicks) {
        if (partialTicks <= 0.0f) {
            return this.lastLength;
        }
        if (partialTicks >= 1.0f) {
            return this.currentLength;
        }
        return this.lastLength * (double)(1.0f - partialTicks) + this.currentLength * (double)partialTicks;
    }

    public boolean isComplete() {
        return this.field_145850_b.field_72995_K ? this.isComplete : this.currentPos == null;
    }

    @Override
    protected void migrateOldNBT(int version, NBTTagCompound nbt) {
        super.migrateOldNBT(version, nbt);
        if (version == BCVersion.BEFORE_RECORDS.dataVersion || version == BCVersion.v7_2_0_pre_12.dataVersion) {
            NBTTagCompound oldBattery = nbt.func_74775_l("battery");
            int energy = oldBattery.func_74762_e("energy");
            this.battery.extractPower(0L, Integer.MAX_VALUE);
            this.battery.addPower(energy * 100, false);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.currentPos != null) {
            nbt.func_74782_a("currentPos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.currentPos));
        }
        nbt.func_74768_a("wantedLength", this.wantedLength);
        nbt.func_74768_a("progress", this.progress);
        nbt.func_74782_a("mj_battery", (NBTBase)this.battery.serializeNBT());
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("currentPos")) {
            this.currentPos = NBTUtil.func_186861_c((NBTTagCompound)nbt.func_74775_l("currentPos"));
        }
        this.wantedLength = nbt.func_74762_e("wantedLength");
        this.progress = nbt.func_74762_e("progress");
        this.battery.deserializeNBT(nbt.func_74775_l("mj_battery"));
    }

    @Override
    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (side == Side.SERVER) {
            if (id == NET_RENDER_DATA) {
                this.writePayload(NET_LED_STATUS, buffer, side);
                buffer.writeInt(this.wantedLength);
            } else if (id == NET_LED_STATUS) {
                buffer.writeBoolean(this.isComplete());
                this.battery.writeToBuffer((ByteBuf)buffer);
            } else if (id == NET_WANTED_Y) {
                buffer.writeInt(this.wantedLength);
            }
        }
    }

    @Override
    public void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(id, buffer, side, ctx);
        if (side == Side.CLIENT) {
            if (id == NET_RENDER_DATA) {
                this.readPayload(NET_LED_STATUS, buffer, side, ctx);
                this.wantedLength = buffer.readInt();
                this.currentLength = this.lastLength = (double)this.wantedLength;
            } else if (id == NET_LED_STATUS) {
                this.isComplete = buffer.readBoolean();
                this.battery.readFromBuffer((ByteBuf)buffer);
            } else if (id == NET_WANTED_Y) {
                this.wantedLength = buffer.readInt();
            }
        }
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add("battery = " + this.battery.getDebugString());
        left.add("current = " + this.currentPos);
        left.add("wantedLength = " + this.wantedLength);
        left.add("currentLength = " + this.currentLength);
        left.add("lastLength = " + this.lastLength);
        left.add("isComplete = " + this.isComplete());
        left.add("progress = " + LocaleUtil.localizeMj(this.progress));
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return Double.MAX_VALUE;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasFastRenderer() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public float getPercentFilledForRender() {
        float val = (float)this.battery.getStored() / (float)this.battery.getCapacity();
        return val < 0.0f ? 0.0f : (val > 1.0f ? 1.0f : val);
    }

    protected long getBatteryCapacity() {
        return 500000000L;
    }
}

