/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.tile;

import buildcraft.api.core.BCLog;
import buildcraft.api.core.EnumPipePart;
import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.recipes.IRefineryRecipeManager;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.factory.BCFactoryBlocks;
import buildcraft.factory.block.BlockHeatExchange;
import buildcraft.factory.tile.TileHeatExchangeEnd;
import buildcraft.lib.block.BlockBCBase_Neptune;
import buildcraft.lib.fluid.FluidSmoother;
import buildcraft.lib.fluid.Tank;
import buildcraft.lib.misc.BoundingBoxUtil;
import buildcraft.lib.misc.CapUtil;
import buildcraft.lib.misc.FluidUtilBC;
import buildcraft.lib.misc.MathUtil;
import buildcraft.lib.misc.VecUtil;
import buildcraft.lib.misc.data.IdAllocator;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.tile.TileBC_Neptune;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileHeatExchangeStart
extends TileBC_Neptune
implements ITickable,
IDebuggable {
    public static final IdAllocator IDS = TileBC_Neptune.IDS.makeChild("HeatExchangeStart");
    public static final int NET_TANK_HEATABLE_IN = IDS.allocId("TANK_HEATABLE_IN");
    public static final int NET_TANK_COOLABLE_OUT = IDS.allocId("TANK_COOLABLE_OUT");
    public static final int NET_STATE = IDS.allocId("STATE");
    private static final int[] FLUID_MULT = new int[]{10, 16, 20};
    private final Tank tankHeatableIn = new Tank("heatable_in", 2000, this, this::isHeatant);
    private final Tank tankCoolableOut = new Tank("coolable_out", 2000, this);
    public final FluidSmoother smoothedHeatableIn;
    public final FluidSmoother smoothedCoolableOut;
    private TileHeatExchangeEnd tileEnd;
    private int middles;
    private int progress = 0;
    private EnumProgressState progressState = EnumProgressState.OFF;
    private EnumProgressState lastSentState = EnumProgressState.OFF;
    private int heatProvided = 0;
    private int coolingProvided = 0;
    private int progressLast = 0;

    @Override
    public IdAllocator getIdAllocator() {
        return IDS;
    }

    public TileHeatExchangeStart() {
        this.tankManager.addAll(this.tankHeatableIn, this.tankCoolableOut);
        this.tankCoolableOut.setCanFill(false);
        this.caps.addCapabilityInstance(CapUtil.CAP_FLUIDS, this.tankHeatableIn, EnumPipePart.DOWN);
        this.caps.addCapability(CapUtil.CAP_FLUIDS, this::getTankForSide, EnumPipePart.HORIZONTALS);
        this.smoothedHeatableIn = this.createFluidSmoother(this.tankHeatableIn, NET_TANK_HEATABLE_IN);
        this.smoothedCoolableOut = this.createFluidSmoother(this.tankCoolableOut, NET_TANK_COOLABLE_OUT);
    }

    private FluidSmoother createFluidSmoother(Tank tank, int netId) {
        return new FluidSmoother(w -> this.createAndSendMessage(netId, w), tank);
    }

    private boolean isHeatant(FluidStack fluid) {
        return BuildcraftRecipeRegistry.refineryRecipes.getHeatableRegistry().getRecipeForInput(fluid) != null;
    }

    private IFluidHandler getTankForSide(EnumFacing side) {
        IBlockState state = this.getCurrentStateForBlock(BCFactoryBlocks.heatExchangeStart);
        if (state == null) {
            return null;
        }
        EnumFacing thisFacing = (EnumFacing)state.func_177229_b(BlockBCBase_Neptune.PROP_FACING);
        if (side != thisFacing.func_176734_d()) {
            return null;
        }
        return this.tankCoolableOut;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("coolingProvided", this.coolingProvided);
        nbt.func_74768_a("heatProvided", this.heatProvided);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.coolingProvided = nbt.func_74762_e("coolingProvided");
        this.heatProvided = nbt.func_74762_e("heatProvided");
    }

    @Override
    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (side == Side.SERVER) {
            if (id == NET_RENDER_DATA) {
                this.writePayload(NET_TANK_HEATABLE_IN, buffer, side);
                this.writePayload(NET_TANK_COOLABLE_OUT, buffer, side);
                this.writePayload(NET_STATE, buffer, side);
                buffer.writeInt(this.progress);
            } else if (id == NET_TANK_HEATABLE_IN) {
                this.smoothedHeatableIn.writeInit(buffer);
            } else if (id == NET_TANK_COOLABLE_OUT) {
                this.smoothedCoolableOut.writeInit(buffer);
            } else if (id == NET_STATE) {
                buffer.writeEnumValue(this.progressState);
            }
        }
    }

    @Override
    public void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(id, buffer, side, ctx);
        if (side == Side.CLIENT) {
            if (id == NET_RENDER_DATA) {
                this.readPayload(NET_TANK_HEATABLE_IN, buffer, side, ctx);
                this.readPayload(NET_TANK_COOLABLE_OUT, buffer, side, ctx);
                this.readPayload(NET_STATE, buffer, side, ctx);
                this.progress = buffer.readInt();
                this.smoothedHeatableIn.resetSmoothing(this.func_145831_w());
                this.smoothedCoolableOut.resetSmoothing(this.func_145831_w());
            } else if (id == NET_TANK_HEATABLE_IN) {
                this.smoothedHeatableIn.handleMessage(this.func_145831_w(), buffer);
            } else if (id == NET_TANK_COOLABLE_OUT) {
                this.smoothedCoolableOut.handleMessage(this.func_145831_w(), buffer);
            } else if (id == NET_STATE) {
                this.progressState = buffer.func_179257_a(EnumProgressState.class);
            }
        }
    }

    public void func_73660_a() {
        this.smoothedHeatableIn.tick(this.func_145831_w());
        this.smoothedCoolableOut.tick(this.func_145831_w());
        this.findEnd();
        this.updateProgress();
        if (this.field_145850_b.field_72995_K) {
            this.spawnParticles();
            return;
        }
        if (this.tileEnd != null) {
            this.craft();
        } else if (this.progressState != EnumProgressState.OFF) {
            this.progressState = EnumProgressState.STOPPING;
        }
        this.output();
        if (this.progressState != this.lastSentState) {
            this.lastSentState = this.progressState;
            this.sendNetworkUpdate(NET_STATE);
        }
    }

    private void updateProgress() {
        this.progressLast = this.progress--;
        switch (this.progressState) {
            case STOPPING: {
                if (this.progress <= 0) {
                    this.progress = 0;
                    this.progressState = EnumProgressState.OFF;
                }
                return;
            }
            case PREPARING: 
            case RUNNING: {
                int lag = 120;
                ++this.progress;
                if (this.progress >= lag) {
                    this.progress = lag;
                    this.progressState = EnumProgressState.RUNNING;
                }
                return;
            }
        }
    }

    private void findEnd() {
        this.tileEnd = null;
        IBlockState state = this.getCurrentStateForBlock(BCFactoryBlocks.heatExchangeStart);
        if (state == null) {
            return;
        }
        BlockHeatExchange block = (BlockHeatExchange)state.func_177230_c();
        EnumFacing facing = (EnumFacing)state.func_177229_b(BlockBCBase_Neptune.PROP_FACING);
        this.middles = 0;
        BlockPos search = this.func_174877_v();
        for (int i = 0; i <= 3 && (state = this.getLocalState(search = search.func_177972_a(facing))).func_177230_c() == BCFactoryBlocks.heatExchangeMiddle; ++i) {
            block = BCFactoryBlocks.heatExchangeMiddle;
            if (block.part.getAxis(state) != facing.func_176740_k()) {
                return;
            }
            ++this.middles;
        }
        if (this.middles == 0) {
            return;
        }
        if (state.func_177230_c() != BCFactoryBlocks.heatExchangeEnd) {
            return;
        }
        if (state.func_177229_b(BlockBCBase_Neptune.PROP_FACING) != facing.func_176734_d()) {
            return;
        }
        TileEntity tile = this.getLocalTile(search);
        if (tile instanceof TileHeatExchangeEnd) {
            this.tileEnd = (TileHeatExchangeEnd)tile;
        }
    }

    private void craft() {
        Tank c_in = this.tileEnd.tankCoolableIn;
        Tank c_out = this.tankCoolableOut;
        Tank h_in = this.tankHeatableIn;
        Tank h_out = this.tileEnd.tankHeatableOut;
        IRefineryRecipeManager reg = BuildcraftRecipeRegistry.refineryRecipes;
        IRefineryRecipeManager.ICoolableRecipe c_recipe = reg.getCoolableRegistry().getRecipeForInput(c_in.getFluid());
        IRefineryRecipeManager.IHeatableRecipe h_recipe = reg.getHeatableRegistry().getRecipeForInput(h_in.getFluid());
        if (h_recipe == null || c_recipe == null) {
            this.progressState = EnumProgressState.STOPPING;
            return;
        }
        if (c_recipe.heatFrom() <= h_recipe.heatFrom()) {
            BCLog.logger.warn("Invalid heat values!");
            this.progressState = EnumProgressState.STOPPING;
            return;
        }
        int c_diff = c_recipe.heatFrom() - c_recipe.heatTo();
        int h_diff = h_recipe.heatTo() - h_recipe.heatFrom();
        if (h_diff < 1 || c_diff < 1) {
            throw new IllegalStateException("Invalid recipe " + c_recipe + ", " + h_recipe);
        }
        int mult = FLUID_MULT[this.middles - 1];
        boolean needs_c = this.heatProvided <= 0;
        boolean needs_h = this.coolingProvided <= 0;
        FluidStack c_in_f = TileHeatExchangeStart.setAmount(c_recipe.in(), mult);
        FluidStack c_out_f = TileHeatExchangeStart.setAmount(c_recipe.out(), mult);
        FluidStack h_in_f = TileHeatExchangeStart.setAmount(h_recipe.in(), mult);
        FluidStack h_out_f = TileHeatExchangeStart.setAmount(h_recipe.out(), mult);
        if (TileHeatExchangeStart.canFill(c_out, c_out_f) && TileHeatExchangeStart.canFill(h_out, h_out_f) && TileHeatExchangeStart.canDrain(c_in, c_in_f) && TileHeatExchangeStart.canDrain(h_in, h_in_f)) {
            if (this.progressState == EnumProgressState.OFF) {
                this.progressState = EnumProgressState.PREPARING;
            } else if (this.progressState == EnumProgressState.RUNNING) {
                --this.heatProvided;
                --this.coolingProvided;
                if (needs_c) {
                    this.heatProvided += c_diff;
                    TileHeatExchangeStart.fill(c_out, c_out_f);
                    TileHeatExchangeStart.drain(c_in, c_in_f);
                }
                if (needs_h) {
                    this.coolingProvided += h_diff;
                    TileHeatExchangeStart.fill(h_out, h_out_f);
                    TileHeatExchangeStart.drain(h_in, h_in_f);
                }
            }
        } else {
            this.progressState = EnumProgressState.STOPPING;
        }
    }

    private void spawnParticles() {
        if (this.progressState == EnumProgressState.RUNNING) {
            EnumFacing dir;
            IBlockState state;
            TileHeatExchangeEnd end = this.tileEnd;
            if (end == null) {
                return;
            }
            Vec3d from = VecUtil.convertCenter((Vec3i)this.func_174877_v());
            FluidStack c_in_f = end.smoothedCoolableIn.getFluidForRender();
            if (c_in_f != null && c_in_f.getFluid() == FluidRegistry.LAVA && (state = this.getCurrentStateForBlock(BCFactoryBlocks.heatExchangeStart)) != null) {
                dir = (EnumFacing)state.func_177229_b(BlockBCBase_Neptune.PROP_FACING);
                this.spewForth(from, dir.func_176734_d(), EnumParticleTypes.SMOKE_LARGE);
            }
            FluidStack h_in_f = this.smoothedHeatableIn.getFluidForRender();
            from = VecUtil.convertCenter((Vec3i)this.tileEnd.func_174877_v());
            if (h_in_f != null && h_in_f.getFluid() == FluidRegistry.WATER) {
                dir = EnumFacing.UP;
                this.spewForth(from, dir, EnumParticleTypes.CLOUD);
            }
        }
    }

    private void spewForth(Vec3d from, EnumFacing dir, EnumParticleTypes particle) {
        Vec3d vecDir = new Vec3d(dir.func_176730_m());
        from = from.func_178787_e(VecUtil.scale(vecDir, 0.5));
        double x = from.field_72450_a;
        double y = from.field_72448_b;
        double z = from.field_72449_c;
        Vec3d motion = VecUtil.scale(vecDir, 0.4);
        int particleCount = Minecraft.func_71410_x().field_71474_y.field_74362_aa;
        World w = this.func_145831_w();
        if (particleCount == 2 || w == null) {
            return;
        }
        particleCount = particleCount == 0 ? 5 : 2;
        for (int i = 0; i < particleCount; ++i) {
            double dx = motion.field_72450_a + (Math.random() - 0.5) * 0.1;
            double dy = motion.field_72448_b + (Math.random() - 0.5) * 0.1;
            double dz = motion.field_72449_c + (Math.random() - 0.5) * 0.1;
            double interp = (double)i / (double)particleCount;
            w.func_175688_a(particle, x -= dx * interp, y -= dy * interp, z -= dz * interp, dx, dy, dz, new int[0]);
        }
    }

    private void output() {
        IFluidHandler thisOut = this.getFluidAutoOutputTarget();
        FluidUtilBC.move(this.tankCoolableOut, thisOut, 1000);
        if (this.tileEnd != null) {
            IFluidHandler endOut = this.tileEnd.getFluidAutoOutputTarget();
            FluidUtilBC.move(this.tileEnd.tankHeatableOut, endOut, 1000);
        }
    }

    private static FluidStack setAmount(FluidStack fluid, int mult) {
        if (fluid == null) {
            return null;
        }
        return new FluidStack(fluid, mult);
    }

    private static boolean canFill(Tank t, FluidStack fluid) {
        return fluid == null || t.fillInternal(fluid, false) == fluid.amount;
    }

    private static boolean canDrain(Tank t, FluidStack fluid) {
        FluidStack f2 = t.drainInternal(fluid, false);
        return f2 != null && f2.amount == fluid.amount;
    }

    private static void fill(Tank t, FluidStack fluid) {
        if (fluid == null) {
            return;
        }
        int a = t.fillInternal(fluid, true);
        if (a != fluid.amount) {
            String err = "Buggy transition! Failed to fill " + fluid.getFluid();
            throw new IllegalStateException(err + " x " + fluid.amount + " into " + t);
        }
    }

    private static void drain(Tank t, FluidStack fluid) {
        FluidStack f2 = t.drainInternal(fluid, true);
        if (f2 == null || f2.amount != fluid.amount) {
            String err = "Buggy transition! Failed to drain " + fluid.getFluid();
            throw new IllegalStateException(err + " x " + fluid.amount + " from " + t);
        }
    }

    @Nullable
    private IFluidHandler getFluidAutoOutputTarget() {
        IBlockState state = this.getCurrentStateForBlock(BCFactoryBlocks.heatExchangeStart);
        if (state == null) {
            return null;
        }
        EnumFacing facing = (EnumFacing)state.func_177229_b(BlockBCBase_Neptune.PROP_FACING);
        TileEntity tile = this.getNeighbourTile(facing.func_176734_d());
        if (tile == null) {
            return null;
        }
        return (IFluidHandler)tile.getCapability(CapUtil.CAP_FLUIDS, facing);
    }

    public TileHeatExchangeEnd getOtherTile() {
        return this.tileEnd;
    }

    public double getProgress(float partialTicks) {
        return MathUtil.interp(partialTicks, this.progressLast, this.progress) / 120.0;
    }

    public EnumProgressState getProgressState() {
        return this.progressState;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        TileHeatExchangeEnd end = this.tileEnd;
        if (end == null) {
            return super.getRenderBoundingBox();
        }
        return BoundingBoxUtil.makeFrom(this.func_174877_v(), end.func_174877_v());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add("progress = " + this.progress);
        left.add("state = " + (Object)((Object)this.progressState));
        left.add("has_end = " + (this.tileEnd != null));
        left.add("heatProvided = " + this.heatProvided);
        left.add("coolingProvided = " + this.coolingProvided);
        if (this.func_145830_o() && this.field_145850_b.field_72995_K) {
            left.add("");
            left.add("coolable:");
            this.smoothedCoolableOut.getDebugInfo(left, right, side);
            left.add("");
            left.add("heatable:");
            this.smoothedHeatableIn.getDebugInfo(left, right, side);
        } else {
            left.add("heatable_in = " + this.tankHeatableIn.getDebugString());
            left.add("coolable_out = " + this.tankCoolableOut.getDebugString());
        }
    }

    public static enum EnumProgressState {
        OFF,
        PREPARING,
        RUNNING,
        STOPPING;

    }
}

