/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.tile;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.factory.BCFactoryBlocks;
import buildcraft.lib.block.BlockBCBase_Neptune;
import buildcraft.lib.fluid.FluidSmoother;
import buildcraft.lib.fluid.Tank;
import buildcraft.lib.misc.CapUtil;
import buildcraft.lib.misc.data.IdAllocator;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.tile.TileBC_Neptune;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileHeatExchangeEnd
extends TileBC_Neptune
implements IDebuggable,
ITickable {
    public static final IdAllocator IDS = TileBC_Neptune.IDS.makeChild("HeatExchangeEnd");
    public static final int NET_TANK_HEATABLE_OUT = IDS.allocId("TANK_HEATABLE_OUT");
    public static final int NET_TANK_COOLABLE_IN = IDS.allocId("TANK_COOLABLE_IN");
    final Tank tankHeatableOut = new Tank("heatable_out", 2000, this);
    final Tank tankCoolableIn = new Tank("coolable_in", 2000, this, this::isCoolant);
    public final FluidSmoother smoothedHeatableOut;
    public final FluidSmoother smoothedCoolableIn;

    @Override
    public IdAllocator getIdAllocator() {
        return IDS;
    }

    public TileHeatExchangeEnd() {
        this.tankManager.addAll(this.tankHeatableOut, this.tankCoolableIn);
        this.tankHeatableOut.setCanFill(false);
        this.caps.addCapabilityInstance(CapUtil.CAP_FLUIDS, this.tankHeatableOut, EnumPipePart.UP);
        this.caps.addCapability(CapUtil.CAP_FLUIDS, this::getTankForSide, EnumPipePart.HORIZONTALS);
        this.smoothedHeatableOut = this.createFluidSmoother(this.tankHeatableOut, NET_TANK_HEATABLE_OUT);
        this.smoothedCoolableIn = this.createFluidSmoother(this.tankCoolableIn, NET_TANK_COOLABLE_IN);
    }

    private FluidSmoother createFluidSmoother(Tank tank, int netId) {
        return new FluidSmoother(w -> this.createAndSendMessage(netId, w), tank);
    }

    private boolean isCoolant(FluidStack fluid) {
        return BuildcraftRecipeRegistry.refineryRecipes.getCoolableRegistry().getRecipeForInput(fluid) != null;
    }

    private IFluidHandler getTankForSide(EnumFacing side) {
        IBlockState state = this.getCurrentStateForBlock(BCFactoryBlocks.heatExchangeEnd);
        if (state == null) {
            return null;
        }
        EnumFacing thisFacing = (EnumFacing)state.func_177229_b(BlockBCBase_Neptune.PROP_FACING);
        if (side != thisFacing.func_176734_d()) {
            return null;
        }
        return this.tankCoolableIn;
    }

    @Override
    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (side == Side.SERVER) {
            if (id == NET_RENDER_DATA) {
                this.writePayload(NET_TANK_COOLABLE_IN, buffer, side);
                this.writePayload(NET_TANK_HEATABLE_OUT, buffer, side);
            } else if (id == NET_TANK_COOLABLE_IN) {
                this.smoothedCoolableIn.writeInit(buffer);
            } else if (id == NET_TANK_HEATABLE_OUT) {
                this.smoothedHeatableOut.writeInit(buffer);
            }
        }
    }

    @Override
    public void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(id, buffer, side, ctx);
        if (side == Side.CLIENT) {
            if (id == NET_RENDER_DATA) {
                this.readPayload(NET_TANK_COOLABLE_IN, buffer, side, ctx);
                this.readPayload(NET_TANK_HEATABLE_OUT, buffer, side, ctx);
                this.smoothedHeatableOut.resetSmoothing(this.func_145831_w());
                this.smoothedCoolableIn.resetSmoothing(this.func_145831_w());
            } else if (id == NET_TANK_COOLABLE_IN) {
                this.smoothedCoolableIn.handleMessage(this.func_145831_w(), buffer);
            } else if (id == NET_TANK_HEATABLE_OUT) {
                this.smoothedHeatableOut.handleMessage(this.func_145831_w(), buffer);
            }
        }
    }

    public void func_73660_a() {
        this.smoothedCoolableIn.tick(this.func_145831_w());
        this.smoothedHeatableOut.tick(this.func_145831_w());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        if (this.func_145830_o() && this.field_145850_b.field_72995_K) {
            left.add("coolable:");
            this.smoothedCoolableIn.getDebugInfo(left, right, side);
            left.add("");
            left.add("heatable:");
            this.smoothedHeatableOut.getDebugInfo(left, right, side);
        } else {
            left.add("heatable_out = " + this.tankHeatableOut.getDebugString());
            left.add("coolable_in = " + this.tankCoolableIn.getDebugString());
        }
    }

    @Nullable
    public IFluidHandler getFluidAutoOutputTarget() {
        TileEntity tile = this.getNeighbourTile(EnumFacing.UP);
        if (tile == null) {
            return null;
        }
        return (IFluidHandler)tile.getCapability(CapUtil.CAP_FLUIDS, EnumFacing.DOWN);
    }
}

