/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.tile;

import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.core.EnumPipePart;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.factory.BCFactoryBlocks;
import buildcraft.factory.block.BlockFloodGate;
import buildcraft.lib.fluid.Tank;
import buildcraft.lib.misc.BlockUtil;
import buildcraft.lib.misc.CapUtil;
import buildcraft.lib.misc.FluidUtilBC;
import buildcraft.lib.misc.MessageUtil;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.tile.TileBC_Neptune;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileFloodGate
extends TileBC_Neptune
implements ITickable,
IDebuggable {
    private static final int[] REBUILD_DELAYS = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384};
    private final Tank tank = new Tank("tank", 2000, this);
    public final EnumMap<EnumFacing, Boolean> openSides = new EnumMap(EnumFacing.class);
    public final Queue<BlockPos> queue = new PriorityQueue<BlockPos>(Comparator.comparingInt(blockPos -> (blockPos.func_177958_n() - this.field_174879_c.func_177958_n()) * (blockPos.func_177958_n() - this.field_174879_c.func_177958_n()) + (blockPos.func_177956_o() - this.field_174879_c.func_177956_o()) * (blockPos.func_177956_o() - this.field_174879_c.func_177956_o()) + (blockPos.func_177952_p() - this.field_174879_c.func_177952_p()) * (blockPos.func_177952_p() - this.field_174879_c.func_177952_p())));
    private final Map<BlockPos, List<BlockPos>> paths = new HashMap<BlockPos, List<BlockPos>>();
    private int delayIndex = 0;
    private int tick = 0;

    public TileFloodGate() {
        this.caps.addCapabilityInstance(CapUtil.CAP_FLUIDS, this.tank, EnumPipePart.VALUES);
        this.tankManager.add(this.tank);
        Arrays.stream(EnumFacing.field_82609_l).forEach(side -> this.openSides.put((EnumFacing)side, BlockFloodGate.CONNECTED_MAP.containsKey(side)));
    }

    private int getCurrentDelay() {
        return REBUILD_DELAYS[this.delayIndex];
    }

    private void buildQueue() {
        this.field_145850_b.field_72984_F.func_76320_a("prepare");
        this.queue.clear();
        this.paths.clear();
        if (this.tank.isEmpty()) {
            this.field_145850_b.field_72984_F.func_76319_b();
            return;
        }
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        ArrayList<BlockPos> nextPosesToCheck = new ArrayList<BlockPos>();
        this.openSides.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).map(arg_0 -> ((BlockPos)this.field_174879_c).func_177972_a(arg_0)).forEach(nextPosesToCheck::add);
        this.field_145850_b.field_72984_F.func_76318_c("build");
        block0: while (!nextPosesToCheck.isEmpty()) {
            ArrayList nextPosesToCheckCopy = new ArrayList(nextPosesToCheck);
            nextPosesToCheck.clear();
            for (BlockPos posToCheck : nextPosesToCheckCopy) {
                for (EnumFacing side : new EnumFacing[]{EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST}) {
                    BlockPos offsetPos = posToCheck.func_177972_a(side);
                    if ((offsetPos.func_177958_n() - this.field_174879_c.func_177958_n()) * (offsetPos.func_177958_n() - this.field_174879_c.func_177958_n()) + (offsetPos.func_177952_p() - this.field_174879_c.func_177952_p()) * (offsetPos.func_177952_p() - this.field_174879_c.func_177952_p()) > 4096 || !this.openSides.get(side).booleanValue() && (side == EnumFacing.NORTH && offsetPos.func_177952_p() >= this.field_174879_c.func_177952_p() || side == EnumFacing.SOUTH && offsetPos.func_177952_p() <= this.field_174879_c.func_177952_p() || side == EnumFacing.WEST && offsetPos.func_177958_n() >= this.field_174879_c.func_177958_n() || side == EnumFacing.EAST && offsetPos.func_177958_n() <= this.field_174879_c.func_177958_n()) || checked.contains(offsetPos)) continue;
                    if (this.canSearch(offsetPos)) {
                        ImmutableList.Builder pathBuilder = new ImmutableList.Builder();
                        if (this.paths.containsKey(posToCheck)) {
                            pathBuilder.addAll((Iterable)this.paths.get(posToCheck));
                        }
                        pathBuilder.add((Object)offsetPos);
                        this.paths.put(offsetPos, (List<BlockPos>)pathBuilder.build());
                        if (this.canFill(offsetPos)) {
                            if (this.openSides.get(EnumFacing.DOWN).booleanValue() || Math.abs(offsetPos.func_177956_o() - this.field_174879_c.func_177956_o()) < Math.abs(offsetPos.func_177958_n() - this.field_174879_c.func_177958_n()) || Math.abs(offsetPos.func_177956_o() - this.field_174879_c.func_177956_o()) < Math.abs(offsetPos.func_177952_p() - this.field_174879_c.func_177952_p())) {
                                this.queue.add(offsetPos);
                            }
                            if (this.queue.size() >= 4096) break block0;
                        }
                        nextPosesToCheck.add(offsetPos);
                    }
                    checked.add(offsetPos);
                }
            }
        }
        this.field_145850_b.field_72984_F.func_76319_b();
    }

    private boolean canFill(BlockPos offsetPos) {
        if (this.field_145850_b.func_175623_d(offsetPos)) {
            return true;
        }
        Fluid fluid = BlockUtil.getFluidWithFlowing(this.field_145850_b, offsetPos);
        return fluid != null && Objects.equals(fluid.getName(), this.tank.getFluidType().getName()) && BlockUtil.getFluid(this.field_145850_b, offsetPos) == null;
    }

    private boolean canSearch(BlockPos offsetPos) {
        if (this.canFill(offsetPos)) {
            return true;
        }
        Fluid fluid = BlockUtil.getFluid(this.field_145850_b, offsetPos);
        return fluid != null && Objects.equals(fluid.getName(), this.tank.getFluidType().getName());
    }

    public void func_73660_a() {
        FluidStack fluid;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        FluidUtilBC.pullFluidAround((IBlockAccess)this.field_145850_b, this.field_174879_c, this.tank);
        ++this.tick;
        if (this.tick % 16 == 0 && !this.tank.isEmpty() && !this.queue.isEmpty() && (fluid = this.tank.drain(1000, false)) != null && fluid.amount >= 1000) {
            BlockPos currentPos = this.queue.poll();
            if (this.paths.get(currentPos).stream().allMatch(this::canSearch) && this.canFill(currentPos)) {
                if (FluidUtil.tryPlaceFluid((EntityPlayer)BuildCraftAPI.fakePlayerProvider.getFakePlayer((WorldServer)this.field_145850_b, this.getOwner(), currentPos), (World)this.field_145850_b, (BlockPos)currentPos, (IFluidHandler)this.tank, (FluidStack)fluid)) {
                    for (EnumFacing side : EnumFacing.field_82609_l) {
                        this.field_145850_b.func_175685_c(currentPos.func_177972_a(side), (Block)BCFactoryBlocks.floodGate, false);
                    }
                    this.delayIndex = 0;
                }
            } else {
                this.buildQueue();
            }
        }
        if (this.queue.isEmpty() && this.tick % this.getCurrentDelay() == 0) {
            this.delayIndex = Math.min(this.delayIndex + 1, REBUILD_DELAYS.length - 1);
            this.buildQueue();
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("openSides", (NBTBase)NBTUtilBC.writeBooleanList(this.openSides.values().stream()));
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        Boolean[] blockedSidesArray = (Boolean[])NBTUtilBC.readBooleanList(nbt.func_74781_a("openSides")).toArray(Boolean[]::new);
        for (int i = 0; i < blockedSidesArray.length; ++i) {
            this.openSides.put(EnumFacing.func_82600_a((int)i), blockedSidesArray[i]);
        }
    }

    @Override
    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (side == Side.SERVER && id == NET_RENDER_DATA) {
            MessageUtil.writeBooleanArray(buffer, Booleans.toArray(this.openSides.values()));
        }
    }

    @Override
    public void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(id, buffer, side, ctx);
        if (side == Side.CLIENT && id == NET_RENDER_DATA) {
            boolean[] old = Booleans.toArray(this.openSides.values());
            boolean[] blockedSidesArray = MessageUtil.readBooleanArray((PacketBuffer)buffer, this.openSides.values().size());
            for (int i = 0; i < blockedSidesArray.length; ++i) {
                this.openSides.put(EnumFacing.func_82600_a((int)i), blockedSidesArray[i]);
            }
            if (!Arrays.equals(old, Booleans.toArray(this.openSides.values()))) {
                this.redrawBlock();
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add("fluid = " + this.tank.getDebugString());
        left.add("open sides = " + this.openSides.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).map(Enum::name).collect(Collectors.joining(", ")));
        left.add("delay = " + this.getCurrentDelay());
        left.add("tick = " + this.tick);
        left.add("queue size = " + this.queue.size());
    }
}

