/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.tile;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.mj.MjBattery;
import buildcraft.api.mj.MjCapabilityHelper;
import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.recipes.IRefineryRecipeManager;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.core.BCCoreConfig;
import buildcraft.factory.BCFactoryBlocks;
import buildcraft.lib.block.BlockBCBase_Neptune;
import buildcraft.lib.expression.DefaultContexts;
import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.node.value.NodeVariableBoolean;
import buildcraft.lib.expression.node.value.NodeVariableLong;
import buildcraft.lib.expression.node.value.NodeVariableString;
import buildcraft.lib.fluid.FluidSmoother;
import buildcraft.lib.fluid.Tank;
import buildcraft.lib.misc.CapUtil;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.data.AverageLong;
import buildcraft.lib.misc.data.IdAllocator;
import buildcraft.lib.misc.data.ModelVariableData;
import buildcraft.lib.mj.MjBatteryReceiver;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.tile.TileBC_Neptune;
import java.io.IOException;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileDistiller_BC8
extends TileBC_Neptune
implements ITickable,
IDebuggable {
    public static final FunctionContext MODEL_FUNC_CTX;
    private static final NodeVariableString MODEL_FACING;
    private static final NodeVariableBoolean MODEL_ACTIVE;
    private static final NodeVariableLong MODEL_POWER_AVG;
    private static final NodeVariableLong MODEL_POWER_MAX;
    public static final IdAllocator IDS;
    public static final int NET_TANK_IN;
    public static final int NET_TANK_OUT_GAS;
    public static final int NET_TANK_OUT_LIQUID;
    public static final long MAX_MJ_PER_TICK = 6000000L;
    private final Tank tankIn = new Tank("in", 4000, this){

        @Override
        public int fill(FluidStack resource, boolean doFill) {
            IRefineryRecipeManager manager = BuildcraftRecipeRegistry.refineryRecipes;
            IRefineryRecipeManager.IDistillationRecipe recipe = manager.getDistillationRegistry().getRecipeForInput(resource);
            if (recipe == null) {
                return 0;
            }
            int amount = this.getFluidAmount() + resource.amount;
            amount = Math.min(amount, this.getCapacity());
            if ((amount = resource.amount - amount % recipe.in().amount) <= 0) {
                return 0;
            }
            return super.fill(new FluidStack(resource, amount), doFill);
        }
    };
    private final Tank tankOutGas = new Tank("out_gas", 4000, this);
    private final Tank tankOutLiquid = new Tank("out_liquid", 4000, this);
    private final MjBattery mjBattery = new MjBattery(1024000000L);
    public final FluidSmoother smoothedTankIn;
    public final FluidSmoother smoothedTankOutGas;
    public final FluidSmoother smoothedTankOutLiquid;
    public final ModelVariableData clientModelData = new ModelVariableData();
    private IRefineryRecipeManager.IDistillationRecipe currentRecipe;
    private long distillPower = 0L;
    private boolean isActive = false;
    private final AverageLong powerAvg = new AverageLong(100);
    private final SafeTimeTracker updateTracker = new SafeTimeTracker(BCCoreConfig.networkUpdateRate, 2L);
    private boolean changedSinceNetUpdate = true;
    private long powerAvgClient;

    public TileDistiller_BC8() {
        this.tankIn.setCanDrain(false);
        this.tankOutGas.setCanFill(false);
        this.tankOutLiquid.setCanFill(false);
        this.tankManager.add(this.tankIn);
        this.tankManager.add(this.tankOutGas);
        this.tankManager.add(this.tankOutLiquid);
        this.smoothedTankIn = new FluidSmoother(this.createSender(NET_TANK_IN), this.tankIn);
        this.smoothedTankOutGas = new FluidSmoother(this.createSender(NET_TANK_OUT_GAS), this.tankOutGas);
        this.smoothedTankOutLiquid = new FluidSmoother(this.createSender(NET_TANK_OUT_LIQUID), this.tankOutLiquid);
        this.caps.addCapabilityInstance(CapUtil.CAP_FLUIDS, this.tankIn, EnumPipePart.HORIZONTALS);
        this.caps.addCapabilityInstance(CapUtil.CAP_FLUIDS, this.tankOutGas, EnumPipePart.UP);
        this.caps.addCapabilityInstance(CapUtil.CAP_FLUIDS, this.tankOutLiquid, EnumPipePart.DOWN);
        this.caps.addProvider(new MjCapabilityHelper(new MjBatteryReceiver(this.mjBattery)));
    }

    private FluidSmoother.IFluidDataSender createSender(int netId) {
        return writer -> this.createAndSendMessage(netId, writer);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("tanks", (NBTBase)this.tankManager.serializeNBT());
        nbt.func_74782_a("mjBattery", (NBTBase)this.mjBattery.serializeNBT());
        nbt.func_74772_a("distillPower", this.distillPower);
        this.powerAvg.writeToNbt(nbt, "powerAvg");
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tankManager.deserializeNBT(nbt.func_74775_l("tanks"));
        this.mjBattery.deserializeNBT(nbt.func_74775_l("mjBattery"));
        this.distillPower = nbt.func_74763_f("distillPower");
        this.powerAvg.readFromNbt(nbt, "powerAvg");
    }

    @Override
    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (side == Side.SERVER) {
            if (id == NET_RENDER_DATA) {
                this.writePayload(NET_TANK_IN, buffer, side);
                this.writePayload(NET_TANK_OUT_GAS, buffer, side);
                this.writePayload(NET_TANK_OUT_LIQUID, buffer, side);
                buffer.writeBoolean(this.isActive);
                this.powerAvgClient = this.powerAvg.getAverageLong();
                long div = 500000L;
                this.powerAvgClient = Math.round((double)this.powerAvgClient / 500000.0) * 500000L;
                buffer.writeLong(this.powerAvgClient);
            } else if (id == NET_TANK_IN) {
                this.smoothedTankIn.writeInit(buffer);
            } else if (id == NET_TANK_OUT_GAS) {
                this.smoothedTankOutGas.writeInit(buffer);
            } else if (id == NET_TANK_OUT_LIQUID) {
                this.smoothedTankOutLiquid.writeInit(buffer);
            }
        }
    }

    @Override
    public void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(id, buffer, side, ctx);
        if (side == Side.CLIENT) {
            if (id == NET_RENDER_DATA) {
                this.readPayload(NET_TANK_IN, buffer, side, ctx);
                this.readPayload(NET_TANK_OUT_GAS, buffer, side, ctx);
                this.readPayload(NET_TANK_OUT_LIQUID, buffer, side, ctx);
                this.smoothedTankIn.resetSmoothing(this.func_145831_w());
                this.smoothedTankOutGas.resetSmoothing(this.func_145831_w());
                this.smoothedTankOutLiquid.resetSmoothing(this.func_145831_w());
                this.isActive = buffer.readBoolean();
                this.powerAvgClient = buffer.readLong();
            } else if (id == NET_TANK_IN) {
                this.smoothedTankIn.handleMessage(this.func_145831_w(), buffer);
            } else if (id == NET_TANK_OUT_GAS) {
                this.smoothedTankOutGas.handleMessage(this.func_145831_w(), buffer);
            } else if (id == NET_TANK_OUT_LIQUID) {
                this.smoothedTankOutLiquid.handleMessage(this.func_145831_w(), buffer);
            }
        }
    }

    public static void setClientModelVariablesForItem() {
        DefaultContexts.RENDER_PARTIAL_TICKS.value = 1.0;
        TileDistiller_BC8.MODEL_ACTIVE.value = false;
        TileDistiller_BC8.MODEL_POWER_AVG.value = 0L;
        TileDistiller_BC8.MODEL_POWER_MAX.value = 6L;
        TileDistiller_BC8.MODEL_FACING.value = "west";
    }

    public void setClientModelVariables(float partialTicks) {
        DefaultContexts.RENDER_PARTIAL_TICKS.value = partialTicks;
        TileDistiller_BC8.MODEL_ACTIVE.value = this.isActive;
        TileDistiller_BC8.MODEL_POWER_AVG.value = this.powerAvgClient / 1000000L;
        TileDistiller_BC8.MODEL_POWER_MAX.value = 6L;
        TileDistiller_BC8.MODEL_FACING.value = "west";
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() == BCFactoryBlocks.distiller) {
            TileDistiller_BC8.MODEL_FACING.value = ((EnumFacing)state.func_177229_b(BlockBCBase_Neptune.PROP_FACING)).func_176610_l();
        }
    }

    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void func_73660_a() {
        this.smoothedTankIn.tick(this.func_145831_w());
        this.smoothedTankOutGas.tick(this.func_145831_w());
        this.smoothedTankOutLiquid.tick(this.func_145831_w());
        if (this.field_145850_b.field_72995_K) {
            this.setClientModelVariables(1.0f);
            this.clientModelData.tick();
            return;
        }
        this.powerAvg.tick();
        this.changedSinceNetUpdate |= this.powerAvgClient != this.powerAvg.getAverageLong();
        this.currentRecipe = BuildcraftRecipeRegistry.refineryRecipes.getDistillationRegistry().getRecipeForInput(this.tankIn.getFluid());
        if (this.currentRecipe == null) {
            this.mjBattery.addPowerChecking(this.distillPower, false);
            this.distillPower = 0L;
            this.isActive = false;
        } else {
            boolean canFillGas;
            FluidStack reqIn = this.currentRecipe.in();
            FluidStack outLiquid = this.currentRecipe.outLiquid();
            FluidStack outGas = this.currentRecipe.outGas();
            FluidStack potentialIn = this.tankIn.drainInternal(reqIn, false);
            boolean canExtract = reqIn.isFluidStackIdentical(potentialIn);
            boolean canFillLiquid = this.tankOutLiquid.fillInternal(outLiquid, false) == outLiquid.amount;
            boolean bl = canFillGas = this.tankOutGas.fillInternal(outGas, false) == outGas.amount;
            if (canExtract && canFillLiquid && canFillGas) {
                long max = 6000000L;
                max *= this.mjBattery.getStored() + max;
                max /= this.mjBattery.getCapacity() / 2L;
                max = Math.min(max, 6000000L);
                long powerReq = this.currentRecipe.powerRequired();
                long power = this.mjBattery.extractPower(0L, max);
                this.powerAvg.push(max);
                this.distillPower += power;
                boolean bl2 = this.isActive = power > 0L;
                if (this.distillPower >= powerReq) {
                    this.isActive = true;
                    this.distillPower -= powerReq;
                    this.tankIn.drainInternal(reqIn, true);
                    this.tankOutGas.fillInternal(outGas, true);
                    this.tankOutLiquid.fillInternal(outLiquid, true);
                }
            } else {
                this.mjBattery.addPowerChecking(this.distillPower, false);
                this.distillPower = 0L;
                this.isActive = false;
            }
        }
        if (this.changedSinceNetUpdate && this.updateTracker.markTimeIfDelay(this.field_145850_b)) {
            this.powerAvgClient = this.powerAvg.getAverageLong();
            this.sendNetworkUpdate(NET_RENDER_DATA);
            this.changedSinceNetUpdate = false;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add("In = " + this.tankIn.getDebugString());
        left.add("OutGas = " + this.tankOutGas.getDebugString());
        left.add("OutLiquid = " + this.tankOutLiquid.getDebugString());
        left.add("Battery = " + this.mjBattery.getDebugString());
        left.add("Progress = " + MjAPI.formatMj(this.distillPower));
        left.add("Rate = " + LocaleUtil.localizeMjFlow(this.powerAvgClient));
        left.add("CurrRecipe = " + this.currentRecipe);
        if (this.field_145850_b.field_72995_K) {
            this.setClientModelVariables(1.0f);
            left.add("Model Variables:");
            left.add("  facing = " + TileDistiller_BC8.MODEL_FACING.value);
            left.add("  active = " + TileDistiller_BC8.MODEL_ACTIVE.value);
            left.add("  power_average = " + TileDistiller_BC8.MODEL_POWER_AVG.value);
            left.add("  power_max = " + TileDistiller_BC8.MODEL_POWER_MAX.value);
            left.add("Current Model Variables:");
            this.clientModelData.refresh();
            this.clientModelData.addDebugInfo(left);
        }
    }

    static {
        IDS = TileBC_Neptune.IDS.makeChild("Distiller");
        NET_TANK_IN = IDS.allocId("TANK_IN");
        NET_TANK_OUT_GAS = IDS.allocId("TANK_OUT_GAS");
        NET_TANK_OUT_LIQUID = IDS.allocId("TANK_OUT_LIQUID");
        MODEL_FUNC_CTX = DefaultContexts.createWithAll();
        MODEL_FACING = MODEL_FUNC_CTX.putVariableString("facing");
        MODEL_POWER_AVG = MODEL_FUNC_CTX.putVariableLong("power_average");
        MODEL_POWER_MAX = MODEL_FUNC_CTX.putVariableLong("power_max");
        MODEL_ACTIVE = MODEL_FUNC_CTX.putVariableBoolean("active");
    }
}

