/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.tile;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.api.tiles.TilesAPI;
import buildcraft.factory.util.IAutoCraft;
import buildcraft.factory.util.WorkbenchCrafting;
import buildcraft.lib.delta.DeltaInt;
import buildcraft.lib.delta.DeltaManager;
import buildcraft.lib.tile.TileBC_Neptune;
import buildcraft.lib.tile.item.ItemHandlerManager;
import buildcraft.lib.tile.item.ItemHandlerSimple;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class TileAutoWorkbenchBase
extends TileBC_Neptune
implements ITickable,
IDebuggable,
IAutoCraft {
    public final ItemHandlerSimple invBlueprint;
    public final ItemHandlerSimple invMaterials;
    public final ItemHandlerSimple invResult;
    public final ItemHandlerSimple invOverflow;
    private final WorkbenchCrafting crafting;
    private int progress;
    public IRecipe currentRecipe;
    private List<ItemStack> requirements;
    public final DeltaInt deltaProgress;

    public TileAutoWorkbenchBase(int width, int height) {
        this.invResult = this.itemManager.addInvHandler("result", 1, ItemHandlerManager.EnumAccess.EXTRACT, EnumPipePart.VALUES);
        this.progress = -1;
        this.requirements = null;
        this.deltaProgress = this.deltaManager.addDelta("progress", DeltaManager.EnumNetworkVisibility.GUI_ONLY);
        int slots = width * height;
        this.invBlueprint = this.itemManager.addInvHandler("blueprint", slots, ItemHandlerManager.EnumAccess.PHANTOM, new EnumPipePart[0]);
        this.invMaterials = this.itemManager.addInvHandler("materials", slots, ItemHandlerManager.EnumAccess.INSERT, EnumPipePart.VALUES);
        this.invOverflow = this.itemManager.addInvHandler("overflow", slots, ItemHandlerManager.EnumAccess.EXTRACT, EnumPipePart.VALUES);
        this.crafting = new WorkbenchCrafting(width, height, this.invBlueprint);
        this.caps.addCapabilityInstance(TilesAPI.CAP_HAS_WORK, () -> this.progress >= 0, EnumPipePart.VALUES);
    }

    public void func_73660_a() {
        this.deltaManager.tick();
        this.updateRecipe();
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.canWork()) {
            if (this.progress == 0) {
                this.deltaProgress.addDelta(0L, 200L, 1);
                this.deltaProgress.addDelta(200L, 205L, -1);
            }
            if (this.progress < 200) {
                ++this.progress;
                return;
            }
            if (this.invOverflow.getStackInSlot(1).func_190926_b()) {
                this.craft();
                this.progress = 0;
            }
        } else if (this.progress != -1) {
            this.progress = -1;
            this.deltaProgress.setValue(0);
        }
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add("recipe = " + this.currentRecipe);
    }

    @Override
    public ItemHandlerSimple getInvBlueprint() {
        return this.invBlueprint;
    }

    @Override
    public ItemHandlerSimple getInvMaterials() {
        return this.invMaterials;
    }

    @Override
    public ItemHandlerSimple getInvResult() {
        return this.invResult;
    }

    @Override
    public WorkbenchCrafting getWorkbenchCrafting() {
        return this.crafting;
    }

    @Override
    public IRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    @Override
    public void setCurrentRecipe(IRecipe recipe) {
        this.currentRecipe = recipe;
    }

    @Override
    public void setRequirements(List<ItemStack> stacks) {
        this.requirements = stacks;
    }

    @Override
    public List<ItemStack> getRequirements() {
        return this.requirements;
    }

    @Override
    public World getWorldForAutoCrafting() {
        return this.func_145831_w();
    }

    @Override
    public BlockPos getPosForAutoCrafting() {
        return this.func_174877_v();
    }
}

