/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.client.render;

import buildcraft.factory.tile.TileTank;
import buildcraft.lib.client.render.fluid.FluidRenderer;
import buildcraft.lib.client.render.fluid.FluidSpriteType;
import buildcraft.lib.fluid.FluidSmoother;
import buildcraft.lib.fluid.Tank;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fluids.FluidStack;

public class RenderTank
extends TileEntitySpecialRenderer<TileTank> {
    private static final Vec3d MIN = new Vec3d(0.13, 0.01, 0.13);
    private static final Vec3d MAX = new Vec3d(0.86, 0.99, 0.86);
    private static final Vec3d MIN_CONNECTED = new Vec3d(0.13, 0.0, 0.13);
    private static final Vec3d MAX_CONNECTED = new Vec3d(0.86, 0.99999, 0.86);

    public void renderTileEntityAt(TileTank tile, double x, double y, double z, float partialTicks, int destroyStage) {
        FluidSmoother.FluidStackInterp forRender = tile.getFluidForRender(partialTicks);
        if (forRender == null) {
            return;
        }
        Minecraft.func_71410_x().field_71424_I.func_76320_a("bc");
        Minecraft.func_71410_x().field_71424_I.func_76320_a("tank");
        RenderHelper.func_74518_a();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        VertexBuffer vb = Tessellator.func_178181_a().func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        vb.func_178969_c(x, y, z);
        boolean[] sideRender = new boolean[]{true, true, true, true, true, true};
        boolean connectedUp = RenderTank.isFullyConnected(tile, EnumFacing.UP);
        boolean connectedDown = RenderTank.isFullyConnected(tile, EnumFacing.DOWN);
        sideRender[EnumFacing.DOWN.ordinal()] = !connectedDown;
        sideRender[EnumFacing.UP.ordinal()] = !connectedUp;
        Vec3d min = connectedDown ? MIN_CONNECTED : MIN;
        Vec3d max = connectedUp ? MAX_CONNECTED : MAX;
        FluidStack fluid = forRender.fluid;
        int blocklight = fluid.getFluid().getLuminosity(fluid);
        int combinedLight = tile.func_145831_w().func_175626_b(tile.func_174877_v(), blocklight);
        FluidRenderer.vertex.lighti(combinedLight);
        FluidRenderer.renderFluid(FluidSpriteType.STILL, fluid, forRender.amount, tile.tank.getCapacity(), min, max, vb, sideRender);
        vb.func_178969_c(0.0, 0.0, 0.0);
        Tessellator.func_178181_a().func_78381_a();
        RenderHelper.func_74519_b();
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
    }

    private static boolean isFullyConnected(TileTank thisTank, EnumFacing face) {
        BlockPos pos = thisTank.func_174877_v().func_177972_a(face);
        TileEntity oTile = thisTank.func_145831_w().func_175625_s(pos);
        if (oTile instanceof TileTank) {
            TileTank oTank = (TileTank)oTile;
            Tank t = oTank.tank;
            FluidStack fluid = t.getFluid();
            if (t.getFluidAmount() <= 0 || fluid == null) {
                return false;
            }
            if (!fluid.isFluidEqual(thisTank.tank.getFluid())) {
                return false;
            }
            if (fluid.getFluid().isGaseous(fluid)) {
                face = face.func_176734_d();
            }
            return t.getFluidAmount() >= t.getCapacity() || face == EnumFacing.UP;
        }
        return false;
    }
}

