/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.client.render;

import buildcraft.api.properties.BuildCraftProperties;
import buildcraft.factory.BCFactoryBlocks;
import buildcraft.factory.client.render.RenderTube;
import buildcraft.factory.tile.TileMiningWell;
import buildcraft.lib.client.render.laser.LaserData_BC8;
import buildcraft.lib.client.render.tile.RenderPartCube;
import buildcraft.lib.client.sprite.ISprite;
import buildcraft.lib.client.sprite.SpriteHolderRegistry;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.animation.FastTESR;

public class RenderMiningWell
extends FastTESR<TileMiningWell> {
    private static final int[] COLOUR_POWER = new int[16];
    private static final int COLOUR_STATUS_ON = -8921737;
    private static final int COLOUR_STATUS_OFF = -14741477;
    private static final int BLOCK_LIGHT_STATUS_ON = 15;
    private static final int BLOCK_LIGHT_STATUS_OFF = 0;
    private static final double POWER = 0.15625;
    private static final double STATUS = 0.28125;
    private static final double Y = 0.34375;
    private static final RenderPartCube LED_POWER;
    private static final RenderPartCube LED_STATUS;
    private static final LaserData_BC8.LaserType TUBE_LASER;
    private final RenderTube tubeRenderer = new RenderTube(TUBE_LASER);

    public static void textureStitchPost() {
        LED_POWER.setWhiteTex();
        LED_STATUS.setWhiteTex();
    }

    public void renderTileEntityFast(@Nonnull TileMiningWell tile, double x, double y, double z, float partialTicks, int destroyStage, @Nonnull VertexBuffer buffer) {
        double ledX;
        double ledZ;
        int dZ;
        int dX;
        Minecraft.func_71410_x().field_71424_I.func_76320_a("bc");
        Minecraft.func_71410_x().field_71424_I.func_76320_a("miner");
        buffer.func_178969_c(x, y, z);
        EnumFacing facing = EnumFacing.NORTH;
        IBlockState state = tile.func_145831_w().func_180495_p(tile.func_174877_v());
        if (state.func_177230_c() == BCFactoryBlocks.miningWell) {
            facing = (EnumFacing)state.func_177229_b(BuildCraftProperties.BLOCK_FACING);
        }
        if (facing.func_176740_k() == EnumFacing.Axis.X) {
            dX = 0;
            dZ = facing.func_176743_c().func_179524_a();
            ledZ = 0.5;
            ledX = facing == EnumFacing.EAST ? 0.9875 : 0.0125;
        } else {
            dX = -facing.func_176743_c().func_179524_a();
            dZ = 0;
            ledX = 0.5;
            ledZ = facing == EnumFacing.SOUTH ? 0.9875 : 0.0125;
        }
        RenderMiningWell.LED_POWER.center.positiond(ledX + (double)dX * 0.15625, 0.34375, ledZ + (double)dZ * 0.15625);
        float percentFilled = tile.getPercentFilledForRender();
        int colourIndex = (int)(percentFilled * (float)(COLOUR_POWER.length - 1));
        RenderMiningWell.LED_POWER.center.colouri(COLOUR_POWER[colourIndex]);
        RenderMiningWell.LED_POWER.center.lightf((double)percentFilled > 0.01 ? 1.0f : 0.0f, 0.0f);
        LED_POWER.render(buffer);
        RenderMiningWell.LED_STATUS.center.positiond(ledX + (double)dX * 0.28125, 0.34375, ledZ + (double)dZ * 0.28125);
        boolean complete = tile.isComplete();
        RenderMiningWell.LED_STATUS.center.colouri(complete ? -14741477 : -8921737);
        RenderMiningWell.LED_STATUS.center.lighti(complete ? 0 : 15, 0);
        LED_STATUS.render(buffer);
        this.tubeRenderer.renderTileEntityFast(tile, x, y, z, partialTicks, destroyStage, buffer);
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
    }

    public boolean isGlobalRenderer(TileMiningWell tile) {
        return true;
    }

    static {
        for (int i = 0; i < COLOUR_POWER.length; ++i) {
            int colour;
            int c = i * 64 / COLOUR_POWER.length;
            int r = i * 224 / COLOUR_POWER.length + 31;
            RenderMiningWell.COLOUR_POWER[i] = colour = -16777216 + (c << 16) + (c << 8) + r;
        }
        LED_POWER = new RenderPartCube();
        LED_STATUS = new RenderPartCube();
        SpriteHolderRegistry.SpriteHolder spriteTubeMiddle = SpriteHolderRegistry.getHolder("buildcraftfactory:blocks/mining_well/tube");
        LaserData_BC8.LaserRow cap = new LaserData_BC8.LaserRow((ISprite)spriteTubeMiddle, 0, 8, 8, 16, new LaserData_BC8.LaserSide[0]);
        LaserData_BC8.LaserRow middle = new LaserData_BC8.LaserRow((ISprite)spriteTubeMiddle, 0, 0, 16, 8, new LaserData_BC8.LaserSide[0]);
        LaserData_BC8.LaserRow[] middles = new LaserData_BC8.LaserRow[]{middle};
        TUBE_LASER = new LaserData_BC8.LaserType(cap, middle, middles, null, cap);
    }
}

