/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.block;

import buildcraft.api.transport.pipe.ICustomPipeConnection;
import buildcraft.factory.tile.TileHeatExchangeEnd;
import buildcraft.factory.tile.TileHeatExchangeStart;
import buildcraft.lib.block.BlockBCBase_Neptune;
import buildcraft.lib.block.BlockBCTile_Neptune;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockHeatExchange
extends BlockBCTile_Neptune
implements ICustomPipeConnection {
    public static final IProperty<EnumFacing.Axis> PROP_AXIS = PropertyEnum.func_177706_a((String)"axis", EnumFacing.Axis.class, (Enum[])new EnumFacing.Axis[]{EnumFacing.Axis.X, EnumFacing.Axis.Z});
    public static final IProperty<Boolean> PROP_CONNECTED = PropertyBool.func_177716_a((String)"connected");
    public static final IProperty<Boolean> PROP_CONNECTED_Y = PropertyBool.func_177716_a((String)"connected_y");
    public static final IProperty<Boolean> PROP_CONNECTED_POS = PropertyBool.func_177716_a((String)"connected_pos");
    public static final IProperty<Boolean> PROP_CONNECTED_NEG = PropertyBool.func_177716_a((String)"connected_neg");
    private static Part currentInitPart = null;
    public final Part part;

    public BlockHeatExchange(Material material, String id, Part part) {
        super(material, BlockHeatExchange.setCurrentPart(id, part));
        currentInitPart = null;
        this.part = part;
    }

    private static String setCurrentPart(String id, Part part) {
        currentInitPart = part;
        return id;
    }

    @Override
    protected void addProperties(List<IProperty<?>> properties) {
        currentInitPart.addProperties(properties);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return this.part.getMeta(state);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.part.getState(this.func_176223_P(), meta);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.part.getActualState(state, world, pos);
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.part.getPlacement(this.func_176223_P(), placer.func_174811_aO());
    }

    public TileEntity func_149915_a(World world, int meta) {
        switch (this.part) {
            case START: {
                return new TileHeatExchangeStart();
            }
            case MIDDLE: {
                return null;
            }
            case END: {
                return new TileHeatExchangeEnd();
            }
        }
        throw new IllegalStateException("Unknown part " + (Object)((Object)this.part));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public float getExtension(World world, BlockPos pos, EnumFacing face, IBlockState state) {
        return 0.0f;
    }

    public static enum Part {
        START,
        END,
        MIDDLE{

            @Override
            int getMeta(IBlockState state) {
                EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b(PROP_AXIS);
                return axis == EnumFacing.Axis.X ? 0 : 1;
            }

            @Override
            IBlockState getState(IBlockState defaultState, int meta) {
                return defaultState.func_177226_a(PROP_AXIS, (Comparable)((meta & 1) == 0 ? EnumFacing.Axis.X : EnumFacing.Axis.Z));
            }

            @Override
            IBlockState getPlacement(IBlockState state, EnumFacing playerFacing) {
                return state.func_177226_a(PROP_AXIS, (Comparable)playerFacing.func_176746_e().func_176740_k());
            }

            @Override
            public EnumFacing.Axis getAxis(IBlockState state) {
                return (EnumFacing.Axis)state.func_177229_b(PROP_AXIS);
            }

            @Override
            void addProperties(List<IProperty<?>> properties) {
                properties.add(PROP_AXIS);
                properties.add(PROP_CONNECTED_NEG);
                properties.add(PROP_CONNECTED_POS);
            }

            @Override
            IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
                EnumFacing.Axis axis = this.getAxis(state);
                EnumFacing facePos = EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.POSITIVE, (EnumFacing.Axis)axis);
                state = state.func_177226_a(PROP_CONNECTED_POS, (Comparable)Boolean.valueOf(1.doesNeighbourConnect(world, pos, facePos)));
                EnumFacing faceNeg = EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.NEGATIVE, (EnumFacing.Axis)axis);
                state = state.func_177226_a(PROP_CONNECTED_NEG, (Comparable)Boolean.valueOf(1.doesNeighbourConnect(world, pos, faceNeg)));
                return state;
            }

            @Override
            boolean doesConnect(IBlockState state, EnumFacing from) {
                return from.func_176740_k() == state.func_177229_b(PROP_AXIS);
            }
        };


        int getMeta(IBlockState state) {
            EnumFacing face = (EnumFacing)state.func_177229_b(BlockBCBase_Neptune.PROP_FACING);
            return face.func_176736_b();
        }

        IBlockState getState(IBlockState defaultState, int meta) {
            return defaultState.func_177226_a(BlockBCBase_Neptune.PROP_FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)));
        }

        IBlockState getPlacement(IBlockState state, EnumFacing playerFacing) {
            EnumFacing face = playerFacing;
            if (this == END) {
                face = face.func_176734_d();
            }
            return state.func_177226_a(BlockBCBase_Neptune.PROP_FACING, (Comparable)face.func_176746_e());
        }

        public EnumFacing.Axis getAxis(IBlockState state) {
            return ((EnumFacing)state.func_177229_b(BlockBCBase_Neptune.PROP_FACING)).func_176740_k();
        }

        void addProperties(List<IProperty<?>> properties) {
            properties.add(BlockBCBase_Neptune.PROP_FACING);
            properties.add(PROP_CONNECTED);
            properties.add(PROP_CONNECTED_Y);
        }

        IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
            EnumFacing facing = (EnumFacing)state.func_177229_b(BlockBCBase_Neptune.PROP_FACING);
            boolean connected = Part.doesNeighbourConnect(world, pos, facing);
            state = state.func_177226_a(PROP_CONNECTED, (Comparable)Boolean.valueOf(connected));
            state = state.func_177226_a(PROP_CONNECTED_Y, (Comparable)Boolean.FALSE);
            return state;
        }

        boolean doesConnect(IBlockState state, EnumFacing from) {
            EnumFacing thisFacing = (EnumFacing)state.func_177229_b(BlockBCBase_Neptune.PROP_FACING);
            return from == thisFacing;
        }

        static boolean doesNeighbourConnect(IBlockAccess world, BlockPos thisPos, EnumFacing dir) {
            IBlockState offset = world.func_180495_p(thisPos.func_177972_a(dir));
            Block block = offset.func_177230_c();
            if (block instanceof BlockHeatExchange) {
                Part part = ((BlockHeatExchange)block).part;
                return part.doesConnect(offset, dir.func_176734_d());
            }
            return false;
        }
    }
}

