/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.block;

import buildcraft.api.properties.BuildCraftProperties;
import buildcraft.api.tools.IToolWrench;
import buildcraft.factory.tile.TileFloodGate;
import buildcraft.lib.block.BlockBCTile_Neptune;
import buildcraft.lib.misc.BlockUtil;
import buildcraft.lib.tile.TileBC_Neptune;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFloodGate
extends BlockBCTile_Neptune {
    public static final Map<EnumFacing, IProperty<Boolean>> CONNECTED_MAP = new HashMap<EnumFacing, IProperty<Boolean>>(BuildCraftProperties.CONNECTED_MAP);

    public BlockFloodGate(Material material, String id) {
        super(material, id);
    }

    @Override
    protected void addProperties(List<IProperty<?>> properties) {
        super.addProperties(properties);
        properties.addAll(CONNECTED_MAP.values());
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileFloodGate();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = BlockUtil.getTileEntityForGetActualState(world, pos);
        if (tile instanceof TileFloodGate) {
            for (EnumFacing side : CONNECTED_MAP.keySet()) {
                state = state.func_177226_a(CONNECTED_MAP.get(side), (Comparable)((TileFloodGate)tile).openSides.get(side));
            }
        }
        return state;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_77973_b() instanceof IToolWrench) {
            TileEntity tile;
            if (!world.field_72995_K && side != EnumFacing.UP && (tile = world.func_175625_s(pos)) instanceof TileFloodGate && CONNECTED_MAP.containsKey(side)) {
                ((TileFloodGate)tile).openSides.put(side, ((TileFloodGate)tile).openSides.get(side) == false);
                ((TileFloodGate)tile).queue.clear();
                ((TileFloodGate)tile).sendNetworkUpdate(TileBC_Neptune.NET_RENDER_DATA);
                return true;
            }
            return false;
        }
        return super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    static {
        CONNECTED_MAP.remove(EnumFacing.UP);
    }
}

