/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.client.gui;

import buildcraft.energy.container.ContainerEngineStone_BC8;
import buildcraft.energy.tile.TileEngineStone_BC8;
import buildcraft.lib.engine.TileEngineBase_BC8;
import buildcraft.lib.gui.GuiBC8;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.help.DummyHelpElement;
import buildcraft.lib.gui.help.ElementHelpInfo;
import buildcraft.lib.gui.ledger.LedgerEngine;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.gui.pos.IGuiArea;
import buildcraft.lib.misc.LocaleUtil;
import net.minecraft.util.ResourceLocation;

public class GuiEngineStone_BC8
extends GuiBC8<ContainerEngineStone_BC8> {
    private static final ResourceLocation TEXTURE_BASE = new ResourceLocation("buildcraftenergy:textures/gui/steam_engine_gui.png");
    private static final int SIZE_X = 176;
    private static final int SIZE_Y = 166;
    private static final GuiIcon ICON_GUI = new GuiIcon(TEXTURE_BASE, 0, 0, 176, 166);
    private final IGuiArea flameRect;
    private final IGuiArea fuelSlotRect;
    private final ElementHelpInfo helpFlame;
    private final ElementHelpInfo helpFuel;

    public GuiEngineStone_BC8(ContainerEngineStone_BC8 container) {
        super(container);
        this.flameRect = new GuiRectangle(81, 25, 14, 14).offset(this.rootElement);
        this.fuelSlotRect = new GuiRectangle(78, 39, 20, 20).offset(this.rootElement);
        this.field_146999_f = 176;
        this.field_147000_g = 166;
        this.ledgersRight.ledgers.add(new LedgerEngine(this.ledgersRight, (TileEngineBase_BC8)container.tile));
        this.helpFlame = new ElementHelpInfo("buildcraft.help.stone_engine.flame.title", -225, "buildcraft.help.stone_engine.flame");
        this.helpFuel = new ElementHelpInfo("buildcraft.help.stone_engine.fuel.title", -5622989, "buildcraft.help.stone_engine.fuel");
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiElements.add(new DummyHelpElement(this.flameRect.expand(2), this.helpFlame));
        this.guiElements.add(new DummyHelpElement(this.fuelSlotRect, this.helpFuel));
    }

    @Override
    protected void drawBackgroundLayer(float partialTicks) {
        ICON_GUI.drawAt(this.rootElement);
        double amount = ((TileEngineStone_BC8)((ContainerEngineStone_BC8)this.container).tile).deltaFuelLeft.getDynamic(partialTicks) / 100.0;
        if (amount > 0.0) {
            int flameHeight = (int)Math.ceil(amount * (double)this.flameRect.getHeight());
            this.func_73729_b(this.flameRect.getX(), this.flameRect.getY() + this.flameRect.getHeight() - flameHeight, 176, 14 - flameHeight, 14, flameHeight + 2);
        }
    }

    @Override
    protected void drawForegroundLayer() {
        String str = LocaleUtil.localize("tile.engineStone.name");
        int strWidth = this.field_146289_q.func_78256_a(str);
        this.field_146289_q.func_78276_b(str, this.rootElement.getCenterX() - strWidth / 2, this.rootElement.getY() + 6, 0x404040);
        this.field_146289_q.func_78276_b(LocaleUtil.localize("gui.inventory"), this.rootElement.getX() + 8, this.rootElement.getY() + 166 - 96, 0x404040);
    }
}

