/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.api.enums.EnumEngineType;
import buildcraft.api.enums.EnumPowerStage;
import buildcraft.energy.BCEnergyFluids;
import buildcraft.energy.tile.TileEngineIron_BC8;
import buildcraft.energy.tile.TileEngineStone_BC8;
import buildcraft.lib.client.model.ModelHolderVariable;
import buildcraft.lib.client.model.ModelItemSimple;
import buildcraft.lib.client.model.MutableQuad;
import buildcraft.lib.engine.TileEngineBase_BC8;
import buildcraft.lib.expression.DefaultContexts;
import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.node.value.NodeVariableDouble;
import buildcraft.lib.expression.node.value.NodeVariableString;
import buildcraft.lib.fluid.BCFluid;
import buildcraft.lib.misc.data.ModelVariableData;
import java.util.ArrayList;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelFluid;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BCEnergyModels {
    private static final NodeVariableDouble ENGINE_PROGRESS;
    private static final NodeVariableString ENGINE_STAGE;
    private static final NodeVariableString ENGINE_FACING;
    private static final ModelHolderVariable ENGINE_STONE;
    private static final ModelHolderVariable ENGINE_IRON;

    private static ModelHolderVariable getModel(String loc, FunctionContext fnCtx) {
        return new ModelHolderVariable("buildcraftenergy:models/" + loc, fnCtx);
    }

    public static void fmlPreInit() {
        MinecraftForge.EVENT_BUS.register(BCEnergyModels.class);
    }

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        IRegistry modelRegistry = event.getModelRegistry();
        BCEnergyModels.ENGINE_PROGRESS.value = 0.2;
        BCEnergyModels.ENGINE_STAGE.value = EnumPowerStage.BLUE.getModelName();
        BCEnergyModels.ENGINE_FACING.value = EnumFacing.UP.func_176610_l();
        ModelVariableData varData = new ModelVariableData();
        varData.setNodes(ENGINE_STONE.createTickableNodes());
        varData.tick();
        varData.refresh();
        ArrayList<Object> quads = new ArrayList<BakedQuad>();
        for (MutableQuad quad : ENGINE_STONE.getCutoutQuads()) {
            quads.add(quad.toBakedItem());
        }
        BCEnergyModels.registerModel((IRegistry<ModelResourceLocation, IBakedModel>)modelRegistry, EnumEngineType.STONE.getItemModelLocation() + "#inventory", new ModelItemSimple(quads, ModelItemSimple.TRANSFORM_BLOCK));
        quads = new ArrayList();
        varData.setNodes(ENGINE_IRON.createTickableNodes());
        varData.tick();
        varData.refresh();
        for (MutableQuad quad : ENGINE_IRON.getCutoutQuads()) {
            quads.add(quad.toBakedItem());
        }
        BCEnergyModels.registerModel((IRegistry<ModelResourceLocation, IBakedModel>)modelRegistry, EnumEngineType.IRON.getItemModelLocation() + "#inventory", new ModelItemSimple(quads, ModelItemSimple.TRANSFORM_BLOCK));
        for (BCFluid fluid : BCEnergyFluids.allFluids) {
            String mrl = "buildcraftenergy:fluid_block_" + fluid.getBlockName();
            ModelFluid mdl = new ModelFluid((Fluid)fluid);
            BCEnergyModels.registerModel((IRegistry<ModelResourceLocation, IBakedModel>)modelRegistry, mrl, mdl.bake(mdl.getDefaultState(), DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter()));
        }
    }

    private static void registerModel(IRegistry<ModelResourceLocation, IBakedModel> modelRegistry, String reg, IBakedModel val) {
        modelRegistry.func_82595_a((Object)new ModelResourceLocation(reg), (Object)val);
    }

    private static MutableQuad[] getEngineQuads(ModelHolderVariable model, TileEngineBase_BC8 tile, float partialTicks) {
        BCEnergyModels.ENGINE_PROGRESS.value = tile.getProgressClient(partialTicks);
        BCEnergyModels.ENGINE_STAGE.value = tile.getPowerStage().getModelName();
        BCEnergyModels.ENGINE_FACING.value = tile.getCurrentFacing().func_176610_l();
        if (tile.clientModelData.hasNoNodes()) {
            tile.clientModelData.setNodes(model.createTickableNodes());
        }
        tile.clientModelData.refresh();
        return model.getCutoutQuads();
    }

    public static MutableQuad[] getStoneEngineQuads(TileEngineStone_BC8 tile, float partialTicks) {
        return BCEnergyModels.getEngineQuads(ENGINE_STONE, tile, partialTicks);
    }

    public static MutableQuad[] getIronEngineQuads(TileEngineIron_BC8 tile, float partialTicks) {
        return BCEnergyModels.getEngineQuads(ENGINE_IRON, tile, partialTicks);
    }

    static {
        FunctionContext fnCtx = DefaultContexts.createWithAll();
        ENGINE_PROGRESS = fnCtx.putVariableDouble("progress");
        ENGINE_STAGE = fnCtx.putVariableString("stage");
        ENGINE_FACING = fnCtx.putVariableString("facing");
        ENGINE_STONE = BCEnergyModels.getModel("block/engine_stone.json", fnCtx);
        ENGINE_IRON = BCEnergyModels.getModel("block/engine_iron.json", fnCtx);
    }
}

