/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.api.core.BCLog;
import buildcraft.core.BCCoreConfig;
import buildcraft.lib.config.EnumRestartRequirement;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.Level;

public class BCEnergyConfig {
    public static boolean enableOilGeneration;
    public static final TIntSet excludedDimensions;
    public static final Set<ResourceLocation> excessiveBiomes;
    public static final Set<ResourceLocation> surfaceDepositBiomes;
    public static final Set<ResourceLocation> excludedBiomes;
    private static Property propEnableOilGeneration;
    private static Property propExcessiveBiomes;
    private static Property propSurfaceDepositBiomes;
    private static Property propExcludedBiomes;
    private static Property propExcludedDimensions;

    public static void preInit() {
        EnumRestartRequirement world = EnumRestartRequirement.WORLD;
        EnumRestartRequirement game = EnumRestartRequirement.GAME;
        propEnableOilGeneration = BCCoreConfig.config.get("worldgen", "enableOilGen", true);
        propEnableOilGeneration.setComment("Should any oil sprouts or lakes generate, at all?");
        game.setTo(propEnableOilGeneration);
        String[] _excessive = new String[]{"buildcraftenergy:oil_desert", "buildcraftenergy:oil_ocean"};
        propExcessiveBiomes = BCCoreConfig.config.get("worldgen", "excessiveBiomes", _excessive);
        propExcessiveBiomes.setComment("Biome registry names (e.g. 'minecraft:ocean','minecraft:plains') of biomes that should have GREATLY increased oil generation rates.");
        world.setTo(propExcessiveBiomes);
        String[] _surface = new String[]{};
        propSurfaceDepositBiomes = BCCoreConfig.config.get("worldgen", "surfaceDepositBiomes", _surface);
        propSurfaceDepositBiomes.setComment("Biome registry names (e.g. 'minecraft:ocean','minecraft:hills') of biomes that should have slightly increased oil generation rates.");
        world.setTo(propSurfaceDepositBiomes);
        String[] _excluded = new String[]{"minecraft:hell", "minecraft:sky"};
        propExcludedBiomes = BCCoreConfig.config.get("worldgen", "excludedBiomes", _excluded);
        propExcludedBiomes.setComment("Biome registry names (e.g. 'minecraft:hell','minecraft:jungle') of biomes that should never generate oil.");
        int[] _dims = new int[]{-1, 1};
        propExcludedDimensions = BCCoreConfig.config.get("worldgen", "excludedDimensions", _dims);
        propExcludedDimensions.setComment("Dimension ID's (e.g. '-1' for the nether,'1' for the end) of dimensions that should never generate oil.");
        BCEnergyConfig.reloadConfig(EnumRestartRequirement.GAME);
        BCCoreConfig.addReloadListener(BCEnergyConfig::reloadConfig);
    }

    public static void reloadConfig(EnumRestartRequirement restarted) {
        if (EnumRestartRequirement.WORLD.hasBeenRestarted(restarted)) {
            BCEnergyConfig.addBiomeNames(propExcludedBiomes, excessiveBiomes);
            BCEnergyConfig.addBiomeNames(propExcessiveBiomes, excessiveBiomes);
            BCEnergyConfig.addBiomeNames(propSurfaceDepositBiomes, surfaceDepositBiomes);
            excludedDimensions.clear();
            excludedDimensions.addAll(propExcludedBiomes.getIntList());
            if (EnumRestartRequirement.GAME.hasBeenRestarted(restarted)) {
                enableOilGeneration = propEnableOilGeneration.getBoolean();
            } else {
                BCEnergyConfig.validateBiomeNames();
            }
        }
    }

    private static void addBiomeNames(Property prop, Set<ResourceLocation> set) {
        set.clear();
        for (String s : prop.getStringList()) {
            set.add(new ResourceLocation(s));
        }
    }

    public static void validateBiomeNames() {
        HashSet<ResourceLocation> invalids = new HashSet<ResourceLocation>();
        BCEnergyConfig.addInvalidBiomeNames(excessiveBiomes, invalids);
        BCEnergyConfig.addInvalidBiomeNames(excludedBiomes, invalids);
        BCEnergyConfig.addInvalidBiomeNames(surfaceDepositBiomes, invalids);
        if (invalids.isEmpty()) {
            return;
        }
        ArrayList<ResourceLocation> invalidList = new ArrayList<ResourceLocation>();
        invalidList.addAll(invalids);
        Collections.sort(invalidList, Comparator.comparing(ResourceLocation::toString));
        ArrayList<ResourceLocation> allValid = new ArrayList<ResourceLocation>();
        allValid.addAll(ForgeRegistries.BIOMES.getKeys());
        Collections.sort(allValid, Comparator.comparing(ResourceLocation::toString));
        BCLog.logger.warn("****************************************************");
        BCLog.logger.warn("*");
        BCLog.logger.warn("* Unknown biome name detected in buildcraft config!");
        BCLog.logger.warn("* (Config file = " + BCCoreConfig.config.getConfigFile().getAbsolutePath() + ")");
        BCLog.logger.warn("*");
        BCLog.logger.warn("* Unknown biomes: ");
        BCEnergyConfig.printList(Level.WARN, invalidList);
        BCLog.logger.warn("*");
        BCLog.logger.info("* All possible known names: ");
        BCEnergyConfig.printList(Level.INFO, allValid);
        BCLog.logger.info("*");
        BCLog.logger.warn("****************************************************");
    }

    private static void printList(Level level, List<ResourceLocation> list) {
        for (ResourceLocation location : list) {
            BCLog.logger.log(level, "*    - " + location);
        }
    }

    private static void addInvalidBiomeNames(Set<ResourceLocation> toTest, Set<ResourceLocation> invalidDest) {
        for (ResourceLocation test : toTest) {
            if (ForgeRegistries.BIOMES.containsKey(test)) continue;
            invalidDest.add(test);
        }
    }

    static {
        excludedDimensions = new TIntHashSet();
        excessiveBiomes = new HashSet<ResourceLocation>();
        surfaceDepositBiomes = new HashSet<ResourceLocation>();
        excludedBiomes = new HashSet<ResourceLocation>();
    }
}

