/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.tile;

import buildcraft.api.enums.EnumPowerStage;
import buildcraft.api.mj.IMjConnector;
import buildcraft.lib.engine.EngineConnector;
import buildcraft.lib.engine.TileEngineBase_BC8;
import buildcraft.lib.misc.EntityUtil;
import buildcraft.lib.misc.MathUtil;
import buildcraft.lib.net.PacketBufferBC;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class TileEngineCreative
extends TileEngineBase_BC8 {
    public static final long[] outputs = new long[]{1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L};
    public int currentOutputIndex = 0;

    @Override
    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (side == Side.SERVER && id == NET_RENDER_DATA) {
            buffer.writeByte(this.currentOutputIndex);
        }
    }

    @Override
    public void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(id, buffer, side, ctx);
        if (side == Side.CLIENT && id == NET_RENDER_DATA) {
            this.currentOutputIndex = buffer.readUnsignedByte() % outputs.length;
        }
    }

    @Override
    protected void engineUpdate() {
        if (this.isBurning()) {
            this.power += this.getCurrentOutput();
        }
    }

    @Override
    @Nonnull
    protected IMjConnector createConnector() {
        return new EngineConnector(false);
    }

    @Override
    public boolean isBurning() {
        return this.isRedstonePowered;
    }

    @Override
    public double getPistonSpeed() {
        double max = 0.08;
        double min = 0.01;
        double interp = (double)this.currentOutputIndex / (double)(outputs.length - 1);
        return MathUtil.interp(interp, 0.01, 0.08);
    }

    @Override
    protected EnumPowerStage computePowerStage() {
        return EnumPowerStage.BLACK;
    }

    @Override
    public long getMaxPower() {
        return this.getCurrentOutput();
    }

    @Override
    public long maxPowerReceived() {
        return 2000000000L;
    }

    @Override
    public long maxPowerExtracted() {
        return 500000000L;
    }

    @Override
    public float explosionRange() {
        return 0.0f;
    }

    @Override
    public long getCurrentOutput() {
        return outputs[MathUtil.clamp(this.currentOutputIndex, 0, outputs.length - 1)] * 1000000L;
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (EntityUtil.getWrenchHand((EntityLivingBase)player) != null && player.func_70093_af()) {
            if (!this.field_145850_b.field_72995_K) {
                ++this.currentOutputIndex;
                this.currentOutputIndex %= outputs.length;
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.pipe.power.iron.mode", new Object[]{outputs[this.currentOutputIndex]}), true);
                this.sendNetworkUpdate(NET_RENDER_DATA);
            }
            return true;
        }
        return false;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("currentOutputIndex", this.currentOutputIndex);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.currentOutputIndex = nbt.func_74762_e("currentOutputIndex");
        this.currentOutputIndex = MathUtil.clamp(this.currentOutputIndex, 0, outputs.length);
    }
}

