/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.statements;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.StatementParameterItemStack;
import buildcraft.core.BCCoreSprites;
import buildcraft.core.BCCoreStatements;
import buildcraft.core.statements.BCStatement;
import buildcraft.lib.client.sprite.SpriteHolderRegistry;
import buildcraft.lib.misc.CapUtil;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.StackUtil;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

public class TriggerInventoryLevel
extends BCStatement
implements ITriggerExternal {
    public TriggerType type;

    public TriggerInventoryLevel(TriggerType type) {
        super("buildcraft:inventorylevel." + type.name().toLowerCase(Locale.ROOT), "buildcraft.inventorylevel." + type.name().toLowerCase(Locale.ROOT), "buildcraft.filteredBuffer." + type.name().toLowerCase(Locale.ROOT));
        this.type = type;
    }

    @Override
    public int maxParameters() {
        return 1;
    }

    @Override
    public int minParameters() {
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SpriteHolderRegistry.SpriteHolder getSpriteHolder() {
        return BCCoreSprites.TRIGGER_INVENTORY_LEVEL.get((Object)this.type);
    }

    @Override
    public String getDescription() {
        return String.format(LocaleUtil.localize("gate.trigger.inventorylevel.below"), (int)(this.type.level * 100.0f));
    }

    @Override
    public boolean isTriggerActive(TileEntity tile, EnumFacing side, IStatementContainer container, IStatementParameter[] parameters) {
        if (parameters == null || parameters.length < 1 || parameters[0] == null) {
            return false;
        }
        if (tile.hasCapability(CapUtil.CAP_ITEMS, side.func_176734_d())) {
            IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapUtil.CAP_ITEMS, side.func_176734_d());
            if (itemHandler == null) {
                return false;
            }
            ItemStack searchStack = parameters[0].getItemStack();
            if (searchStack.func_190926_b()) {
                return false;
            }
            int stackSpace = 0;
            int foundItems = 0;
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
                if (!stackInSlot.func_190926_b() && !StackUtil.canStacksOrListsMerge(stackInSlot, searchStack)) continue;
                ++stackSpace;
                foundItems += stackInSlot.func_190926_b() ? 0 : stackInSlot.func_190916_E();
            }
            if (stackSpace > 0) {
                float percentage = (float)foundItems / ((float)stackSpace * (float)searchStack.func_77976_d());
                return percentage < this.type.level;
            }
        }
        return false;
    }

    @Override
    public IStatementParameter createParameter(int index) {
        return new StatementParameterItemStack();
    }

    @Override
    public IStatement[] getPossible() {
        return BCCoreStatements.TRIGGER_INVENTORY_ALL;
    }

    public static enum TriggerType {
        BELOW25(0.25f),
        BELOW50(0.5f),
        BELOW75(0.75f);

        public static final TriggerType[] VALUES;
        public final float level;

        private TriggerType(float level) {
            this.level = level;
        }

        static {
            VALUES = TriggerType.values();
        }
    }
}

