/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.statements;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.StatementParameterItemStack;
import buildcraft.core.BCCoreSprites;
import buildcraft.core.BCCoreStatements;
import buildcraft.core.statements.BCStatement;
import buildcraft.lib.client.sprite.SpriteHolderRegistry;
import buildcraft.lib.misc.CapUtil;
import buildcraft.lib.misc.LocaleUtil;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TriggerFluidContainer
extends BCStatement
implements ITriggerExternal {
    public State state;

    public TriggerFluidContainer(State state) {
        super("buildcraft:fluid." + state.name().toLowerCase(Locale.ROOT), "buildcraft.fluid." + state.name().toLowerCase(Locale.ROOT));
        this.state = state;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SpriteHolderRegistry.SpriteHolder getSpriteHolder() {
        return BCCoreSprites.TRIGGER_FLUID.get((Object)this.state);
    }

    @Override
    public int maxParameters() {
        return this.state == State.CONTAINS || this.state == State.SPACE ? 1 : 0;
    }

    @Override
    public String getDescription() {
        return LocaleUtil.localize("gate.trigger.fluid." + this.state.name().toLowerCase(Locale.ROOT));
    }

    @Override
    public boolean isTriggerActive(TileEntity tile, EnumFacing side, IStatementContainer statementContainer, IStatementParameter[] parameters) {
        IFluidHandler handler = (IFluidHandler)tile.getCapability(CapUtil.CAP_FLUIDS, side.func_176734_d());
        if (handler != null) {
            IFluidTankProperties[] liquids;
            FluidStack searchedFluid = null;
            if (parameters != null && parameters.length >= 1 && parameters[0] != null && !parameters[0].getItemStack().func_190926_b()) {
                searchedFluid = FluidUtil.getFluidContained((ItemStack)parameters[0].getItemStack());
            }
            if (searchedFluid != null) {
                searchedFluid.amount = 1;
            }
            if ((liquids = handler.getTankProperties()) == null || liquids.length == 0) {
                return false;
            }
            switch (this.state) {
                case EMPTY: {
                    FluidStack drained = handler.drain(1, false);
                    return drained == null || drained.amount <= 0;
                }
                case CONTAINS: {
                    for (IFluidTankProperties c : liquids) {
                        FluidStack fluid;
                        if (c == null || (fluid = c.getContents()) == null || fluid.amount <= 0 || searchedFluid != null && !searchedFluid.isFluidEqual(fluid)) continue;
                        return true;
                    }
                    return false;
                }
                case SPACE: {
                    if (searchedFluid == null) {
                        for (IFluidTankProperties c : liquids) {
                            FluidStack fluid;
                            if (c == null || (fluid = c.getContents()) != null && fluid.amount >= c.getCapacity()) continue;
                            return true;
                        }
                        return false;
                    }
                    return handler.fill(searchedFluid, false) > 0;
                }
                case FULL: {
                    if (searchedFluid == null) {
                        for (IFluidTankProperties c : liquids) {
                            FluidStack fluid;
                            if (c == null || (fluid = c.getContents()) != null && fluid.amount >= c.getCapacity()) continue;
                            return false;
                        }
                        return true;
                    }
                    return handler.fill(searchedFluid, false) <= 0;
                }
            }
        }
        return false;
    }

    @Override
    public IStatementParameter createParameter(int index) {
        return new StatementParameterItemStack();
    }

    @Override
    public IStatement[] getPossible() {
        return BCCoreStatements.TRIGGER_FLUID_ALL;
    }

    public static enum State {
        EMPTY,
        CONTAINS,
        SPACE,
        FULL;

        public static final State[] VALUES;

        static {
            VALUES = State.values();
        }
    }
}

