/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.statements;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import buildcraft.core.BCCoreSprites;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.StackUtil;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class StatementParameterRedstoneLevel
implements IStatementParameter {
    public int level;
    private int minLevel;
    private int maxLevel;

    public StatementParameterRedstoneLevel() {
        this(0, 0, 15);
    }

    public StatementParameterRedstoneLevel(int min, int max) {
        this(0, min, max);
    }

    public StatementParameterRedstoneLevel(int def, int min, int max) {
        this.level = def;
        this.minLevel = min;
        this.maxLevel = max;
    }

    @Override
    @Nonnull
    public ItemStack getItemStack() {
        return StackUtil.EMPTY;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getGuiSprite() {
        return BCCoreSprites.PARAM_REDSTONE_LEVEL[this.level & 0xF].getSprite();
    }

    @Override
    public boolean onClick(IStatementContainer source, IStatement stmt, ItemStack stack, StatementMouseClick mouse) {
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74774_a("l", (byte)this.level);
        nbt.func_74774_a("mi", (byte)this.minLevel);
        nbt.func_74774_a("ma", (byte)this.maxLevel);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.level = nbt.func_74764_b("l") ? (int)nbt.func_74771_c("l") : 15;
        this.minLevel = nbt.func_74764_b("mi") ? (int)nbt.func_74771_c("mi") : 0;
        this.maxLevel = nbt.func_74764_b("ma") ? (int)nbt.func_74771_c("ma") : 15;
    }

    public boolean equals(Object object) {
        if (object instanceof StatementParameterRedstoneLevel) {
            StatementParameterRedstoneLevel param = (StatementParameterRedstoneLevel)object;
            return param.level == this.level;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.level);
    }

    @Override
    public String getDescription() {
        return String.format(LocaleUtil.localize("gate.trigger.redstone.input.level"), this.level);
    }

    @Override
    public String getUniqueTag() {
        return "buildcraft:redstoneLevel";
    }

    @Override
    public IStatementParameter rotateLeft() {
        return this;
    }

    @Override
    public IStatementParameter[] getPossible(IStatementContainer source, IStatement stmt) {
        IStatementParameter[] possible = new IStatementParameter[this.maxLevel - this.minLevel];
        for (int i = 0; i < this.maxLevel - this.minLevel; ++i) {
            int l = this.minLevel + i;
            possible[i] = this.level == l ? this : new StatementParameterRedstoneLevel(l, this.minLevel, this.maxLevel);
        }
        return possible;
    }
}

