/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.statements;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import buildcraft.lib.misc.StackUtil;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class StatementParameterItemStackExact
implements IStatementParameter {
    protected ItemStack stack;

    @Override
    @Nonnull
    public ItemStack getItemStack() {
        return StackUtil.EMPTY;
    }

    @Override
    public boolean onClick(IStatementContainer source, IStatement stmt, ItemStack stack, StatementMouseClick mouse) {
        if (stack != null) {
            if (StatementParameterItemStackExact.areItemsEqual(this.stack, stack)) {
                if (mouse.getButton() == 0) {
                    this.stack.func_190920_e(this.stack.func_190916_E() + (mouse.isShift() ? 16 : 1));
                    if (this.stack.func_190916_E() > 64) {
                        this.stack.func_190920_e(64);
                    }
                } else {
                    this.stack.func_190920_e(this.stack.func_190916_E() - (mouse.isShift() ? 16 : 1));
                    if (this.stack.func_190916_E() < 0) {
                        this.stack.func_190920_e(0);
                    }
                }
            } else {
                this.stack = stack.func_77946_l();
            }
        } else if (this.stack != null) {
            if (mouse.getButton() == 0) {
                this.stack.func_190920_e(this.stack.func_190916_E() + (mouse.isShift() ? 16 : 1));
                if (this.stack.func_190916_E() > 64) {
                    this.stack.func_190920_e(64);
                }
            } else {
                this.stack.func_190920_e(this.stack.func_190916_E() - (mouse.isShift() ? 16 : 1));
                if (this.stack.func_190916_E() < 0) {
                    this.stack = null;
                }
            }
        }
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        if (this.stack != null) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            this.stack.func_77955_b(tagCompound);
            compound.func_74782_a("stack", (NBTBase)tagCompound);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.stack = new ItemStack(compound.func_74775_l("stack"));
    }

    public boolean equals(Object object) {
        if (object instanceof StatementParameterItemStackExact) {
            StatementParameterItemStackExact param = (StatementParameterItemStackExact)object;
            return StatementParameterItemStackExact.areItemsEqual(this.stack, param.stack);
        }
        return false;
    }

    private static boolean areItemsEqual(ItemStack stack1, ItemStack stack2) {
        if (stack1 != null) {
            return stack2 != null && stack1.func_77969_a(stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
        }
        return stack2 == null;
    }

    public int hashCode() {
        return Objects.hash(this.stack);
    }

    @Override
    public String getDescription() {
        if (this.stack != null) {
            return this.stack.func_82833_r();
        }
        return "";
    }

    @Override
    public String getUniqueTag() {
        return "buildcraft:stackExact";
    }

    @Override
    public IStatementParameter rotateLeft() {
        return this;
    }

    @Override
    public TextureAtlasSprite getGuiSprite() {
        return null;
    }

    @Override
    public IStatementParameter[] getPossible(IStatementContainer source, IStatement stmt) {
        return null;
    }
}

