/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.marker.volume;

import buildcraft.api.core.BCLog;
import buildcraft.core.marker.volume.Lock;
import buildcraft.core.marker.volume.MessageVolumeBoxes;
import buildcraft.core.marker.volume.VolumeBox;
import buildcraft.lib.net.MessageManager;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;

public class WorldSavedDataVolumeBoxes
extends WorldSavedData {
    public static final String DATA_NAME = "buildcraft_volume_boxes";
    public World world;
    public final List<VolumeBox> boxes = new ArrayList<VolumeBox>();

    public WorldSavedDataVolumeBoxes() {
        super(DATA_NAME);
    }

    public WorldSavedDataVolumeBoxes(String name) {
        super(name);
    }

    public VolumeBox getBoxAt(BlockPos pos) {
        return this.boxes.stream().filter(box -> box.box.contains(pos)).findFirst().orElse(null);
    }

    public VolumeBox addBox(BlockPos pos) {
        VolumeBox box = new VolumeBox(pos);
        this.boxes.add(box);
        return box;
    }

    public VolumeBox getBoxFromId(UUID id) {
        return this.boxes.stream().filter(box -> box.id.equals(id)).findFirst().orElse(null);
    }

    public VolumeBox getCurrentEditing(EntityPlayer player) {
        return this.boxes.stream().filter(box -> box.isEditingBy(player)).findFirst().orElse(null);
    }

    public void tick() {
        AtomicBoolean dirty = new AtomicBoolean(false);
        this.boxes.stream().filter(VolumeBox::isEditing).forEach(box -> {
            EntityPlayer player = box.getPlayer(this.world);
            if (player == null) {
                box.pauseEditing();
                dirty.set(true);
            } else {
                AxisAlignedBB oldBox = box.box.getBoundingBox();
                box.box.reset();
                box.box.extendToEncompass(box.getHeld());
                BlockPos lookingAt = new BlockPos(player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0).func_178787_e(player.func_70040_Z().func_186678_a(box.getDist())));
                box.box.extendToEncompass(lookingAt);
                if (!box.box.getBoundingBox().equals((Object)oldBox)) {
                    dirty.set(true);
                }
            }
        });
        for (VolumeBox box2 : this.boxes) {
            List locksToRemove = new ArrayList<Lock>(box2.locks).stream().filter(lock -> !lock.cause.stillWorks(this.world)).collect(Collectors.toList());
            if (locksToRemove.isEmpty()) continue;
            box2.locks.removeAll(locksToRemove);
            dirty.set(true);
        }
        if (dirty.get()) {
            this.func_76185_a();
        }
    }

    public void func_76185_a() {
        super.func_76185_a();
        MessageManager.sendToDimension(new MessageVolumeBoxes(this.boxes), this.world.field_73011_w.getDimension());
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        NBTTagList boxesTag = new NBTTagList();
        this.boxes.stream().map(VolumeBox::writeToNBT).forEach(arg_0 -> ((NBTTagList)boxesTag).func_74742_a(arg_0));
        nbt.func_74782_a("boxes", (NBTBase)boxesTag);
        return nbt;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.boxes.clear();
        NBTTagList boxesTag = nbt.func_150295_c("boxes", 10);
        IntStream.range(0, boxesTag.func_74745_c()).mapToObj(arg_0 -> ((NBTTagList)boxesTag).func_150305_b(arg_0)).map(VolumeBox::new).forEach(this.boxes::add);
    }

    public static WorldSavedDataVolumeBoxes get(World world) {
        MapStorage storage;
        WorldSavedDataVolumeBoxes instance;
        if (world.field_72995_K) {
            BCLog.logger.warn("Creating VolumeBoxes on client, this is a bug");
        }
        if ((instance = (WorldSavedDataVolumeBoxes)(storage = world.getPerWorldStorage()).func_75742_a(WorldSavedDataVolumeBoxes.class, DATA_NAME)) == null) {
            instance = new WorldSavedDataVolumeBoxes();
            storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
        }
        instance.world = world;
        return instance;
    }
}

