/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.marker.volume;

import buildcraft.core.client.BuildCraftLaserManager;
import buildcraft.core.marker.volume.EnumAddonSlot;
import buildcraft.lib.client.render.laser.LaserData_BC8;
import buildcraft.lib.misc.MessageUtil;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.net.PacketBufferBC;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Lock {
    public Cause cause;
    public List<Target> targets = new ArrayList<Target>();

    public Lock() {
    }

    public Lock(Cause cause, Target ... targets) {
        this.cause = cause;
        this.targets.addAll(Arrays.asList(targets));
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound causeTag = new NBTTagCompound();
        causeTag.func_74782_a("type", NBTUtilBC.writeEnum(Cause.EnumCause.getForClass(this.cause.getClass())));
        causeTag.func_74782_a("data", (NBTBase)this.cause.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("cause", (NBTBase)causeTag);
        nbt.func_74782_a("targets", (NBTBase)NBTUtilBC.writeCompoundList(this.targets.stream().map(target -> {
            NBTTagCompound targetTag = new NBTTagCompound();
            targetTag.func_74782_a("type", NBTUtilBC.writeEnum(Target.EnumTarget.getForClass(target.getClass())));
            targetTag.func_74782_a("data", (NBTBase)target.writeToNBT(new NBTTagCompound()));
            return targetTag;
        })));
        return nbt;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagCompound causeTag = nbt.func_74775_l("cause");
        try {
            this.cause = NBTUtilBC.readEnum((NBTBase)causeTag.func_74781_a((String)"type"), Cause.EnumCause.class).clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        this.cause.readFromNBT(causeTag.func_74775_l("data"));
        NBTUtilBC.readCompoundList(nbt.func_74781_a("targets")).map(targetTag -> {
            Target target;
            try {
                target = NBTUtilBC.readEnum((NBTBase)targetTag.func_74781_a((String)"type"), Target.EnumTarget.class).clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            target.readFromNBT(targetTag.func_74775_l("data"));
            return target;
        }).forEach(this.targets::add);
    }

    public void toBytes(PacketBuffer buf) {
        new PacketBufferBC((ByteBuf)buf).writeEnumValue(Cause.EnumCause.getForClass(this.cause.getClass()));
        this.cause.toBytes(buf);
        buf.writeInt(this.targets.size());
        this.targets.forEach(target -> {
            new PacketBuffer((ByteBuf)buf).func_179249_a((Enum)Target.EnumTarget.getForClass(target.getClass()));
            target.toBytes(buf);
        });
    }

    public void fromBytes(PacketBuffer buf) {
        try {
            this.cause = new PacketBufferBC((ByteBuf)buf).func_179257_a(Cause.EnumCause.class).clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        this.cause.fromBytes(buf);
        this.targets.clear();
        IntStream.range(0, buf.readInt()).mapToObj(i -> {
            Target target;
            try {
                target = new PacketBufferBC((ByteBuf)buf).func_179257_a(Target.EnumTarget.class).clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            target.fromBytes(buf);
            return target;
        }).forEach(this.targets::add);
    }

    public static abstract class Target {
        public abstract NBTTagCompound writeToNBT(NBTTagCompound var1);

        public abstract void readFromNBT(NBTTagCompound var1);

        public abstract void toBytes(PacketBuffer var1);

        public abstract void fromBytes(PacketBuffer var1);

        static enum EnumTarget {
            RESIZE(TargetResize.class),
            ADDON(TargetAddon.class),
            USED_BY_MACHINE(TargetUsedByMachine.class);

            public final Class<? extends Target> clazz;

            private EnumTarget(Class<? extends Target> clazz) {
                this.clazz = clazz;
            }

            public static EnumTarget getForClass(Class<? extends Target> clazz) {
                return Arrays.stream(EnumTarget.values()).filter(enumTarget -> enumTarget.clazz == clazz).findFirst().orElse(null);
            }
        }

        public static class TargetUsedByMachine
        extends Target {
            public EnumType type;

            public TargetUsedByMachine() {
            }

            public TargetUsedByMachine(EnumType type) {
                this.type = type;
            }

            @Override
            public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
                nbt.func_74782_a("type", NBTUtilBC.writeEnum(this.type));
                return nbt;
            }

            @Override
            public void readFromNBT(NBTTagCompound nbt) {
                this.type = NBTUtilBC.readEnum(nbt.func_74781_a("type"), EnumType.class);
            }

            @Override
            public void toBytes(PacketBuffer buf) {
                new PacketBufferBC((ByteBuf)buf).writeEnumValue(this.type);
            }

            @Override
            public void fromBytes(PacketBuffer buf) {
                this.type = new PacketBufferBC((ByteBuf)buf).func_179257_a(EnumType.class);
            }

            public static enum EnumType {
                STRIPES_WRITE(BuildCraftLaserManager.STRIPES_WRITE),
                STRIPES_READ(BuildCraftLaserManager.STRIPES_READ);

                public final LaserData_BC8.LaserType laserType;

                private EnumType(LaserData_BC8.LaserType laserType) {
                    this.laserType = laserType;
                }
            }
        }

        public static class TargetAddon
        extends Target {
            public EnumAddonSlot slot;

            public TargetAddon() {
            }

            public TargetAddon(EnumAddonSlot slot) {
                this.slot = slot;
            }

            @Override
            public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
                nbt.func_74782_a("slot", NBTUtilBC.writeEnum(this.slot));
                return nbt;
            }

            @Override
            public void readFromNBT(NBTTagCompound nbt) {
                this.slot = NBTUtilBC.readEnum(nbt.func_74781_a("slot"), EnumAddonSlot.class);
            }

            @Override
            public void toBytes(PacketBuffer buf) {
                new PacketBufferBC((ByteBuf)buf).writeEnumValue(this.slot);
            }

            @Override
            public void fromBytes(PacketBuffer buf) {
                this.slot = new PacketBufferBC((ByteBuf)buf).func_179257_a(EnumAddonSlot.class);
            }
        }

        public static class TargetResize
        extends Target {
            @Override
            public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
                return nbt;
            }

            @Override
            public void readFromNBT(NBTTagCompound nbt) {
            }

            @Override
            public void toBytes(PacketBuffer buf) {
            }

            @Override
            public void fromBytes(PacketBuffer buf) {
            }
        }
    }

    public static abstract class Cause {
        public abstract NBTTagCompound writeToNBT(NBTTagCompound var1);

        public abstract void readFromNBT(NBTTagCompound var1);

        public abstract void toBytes(PacketBuffer var1);

        public abstract void fromBytes(PacketBuffer var1);

        public abstract boolean stillWorks(World var1);

        static enum EnumCause {
            BLOCK(CauseBlock.class);

            public final Class<? extends Cause> clazz;

            private EnumCause(Class<? extends Cause> clazz) {
                this.clazz = clazz;
            }

            public static EnumCause getForClass(Class<? extends Cause> clazz) {
                return Arrays.stream(EnumCause.values()).filter(enumCause -> enumCause.clazz == clazz).findFirst().orElse(null);
            }
        }

        public static class CauseBlock
        extends Cause {
            public BlockPos pos;
            public Block block;

            public CauseBlock() {
            }

            public CauseBlock(BlockPos pos, Block block) {
                this.pos = pos;
                this.block = block;
            }

            @Override
            public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
                nbt.func_74782_a("pos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.pos));
                nbt.func_74778_a("block", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.block)).toString());
                return nbt;
            }

            @Override
            public void readFromNBT(NBTTagCompound nbt) {
                this.pos = NBTUtil.func_186861_c((NBTTagCompound)nbt.func_74775_l("pos"));
                this.block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(nbt.func_74779_i("block")));
            }

            @Override
            public void toBytes(PacketBuffer buf) {
                MessageUtil.writeBlockPos(buf, this.pos);
                buf.func_180714_a(((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.block)).toString());
            }

            @Override
            public void fromBytes(PacketBuffer buf) {
                this.pos = MessageUtil.readBlockPos(buf);
                this.block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(buf.func_150789_c(1024)));
            }

            @Override
            public boolean stillWorks(World world) {
                return world.func_180495_p(this.pos).func_177230_c() == this.block;
            }
        }
    }
}

